/*
 * Decompiled with CFR 0.152.
 */
package com.datahub.util;

import com.datahub.util.ModelUtils;
import com.datahub.util.exception.InvalidSchemaException;
import com.datahub.util.exception.ModelConversionException;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.AbstractArrayTemplate;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.JacksonDataTemplateCodec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.UnionTemplate;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RecordUtils {
    private static final JacksonDataTemplateCodec DATA_TEMPLATE_CODEC = new JacksonDataTemplateCodec();
    private static final String ARRAY_WILDCARD = "*";
    private static final Pattern LEADING_SPACESLASH_PATTERN = Pattern.compile("^[/ ]+");
    private static final Pattern TRAILING_SPACESLASH_PATTERN = Pattern.compile("[/ ]+$");
    private static final Pattern SLASH_PATERN = Pattern.compile("/");
    private static final ConcurrentHashMap<Class<? extends RecordTemplate>, Map<String, Method>> METHOD_CACHE = new ConcurrentHashMap();

    private RecordUtils() {
    }

    @Nonnull
    public static String capitalizeFirst(@Nonnull String name) {
        if (name.length() > 0) {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    @Nonnull
    public static String toJsonString(@Nonnull RecordTemplate recordTemplate) {
        try {
            return DATA_TEMPLATE_CODEC.mapToString(recordTemplate.data());
        }
        catch (IOException e) {
            throw new ModelConversionException("Failed to serialize RecordTemplate: " + recordTemplate.toString());
        }
    }

    public static String toJsonString(@Nonnull List<? extends RecordTemplate> recordTemplates) {
        StringBuilder json = new StringBuilder();
        for (RecordTemplate recordTemplate : recordTemplates) {
            json.append(RecordUtils.toJsonString(recordTemplate));
        }
        return json.toString();
    }

    @Nonnull
    public static <T extends RecordTemplate> T toRecordTemplate(@Nonnull Class<T> type, @Nonnull String jsonString) {
        DataMap dataMap;
        try {
            dataMap = DATA_TEMPLATE_CODEC.stringToMap(jsonString);
        }
        catch (IOException e) {
            throw new ModelConversionException("Failed to deserialize DataMap: " + jsonString);
        }
        return RecordUtils.toRecordTemplate(type, dataMap);
    }

    @Nonnull
    public static DataMap toDataMap(@Nonnull String jsonString) {
        DataMap dataMap;
        try {
            dataMap = DATA_TEMPLATE_CODEC.stringToMap(jsonString);
        }
        catch (IOException e) {
            throw new ModelConversionException("Failed to deserialize DataMap: " + jsonString);
        }
        return dataMap;
    }

    @Nonnull
    public static <T extends RecordTemplate> T toRecordTemplate(@Nonnull Class<T> type, @Nonnull DataMap dataMap) {
        Constructor<T> constructor;
        try {
            constructor = type.getConstructor(DataMap.class);
        }
        catch (NoSuchMethodException e) {
            throw new ModelConversionException("Unable to find constructor for " + type.getCanonicalName(), e);
        }
        try {
            return (T)((RecordTemplate)constructor.newInstance(dataMap));
        }
        catch (Exception e) {
            throw new ModelConversionException("Failed to invoke constructor for " + type.getCanonicalName(), e);
        }
    }

    @Nonnull
    public static RecordTemplate toRecordTemplate(@Nonnull String className, @Nonnull DataMap dataMap) {
        Class<RecordTemplate> clazz;
        try {
            clazz = Class.forName(className).asSubclass(RecordTemplate.class);
        }
        catch (ClassNotFoundException e) {
            throw new ModelConversionException("Unable to find class " + className, e);
        }
        return RecordUtils.toRecordTemplate(clazz, dataMap);
    }

    @Nonnull
    public static <ASPECT extends RecordTemplate, ENTITY extends RecordTemplate> ASPECT extractAspectFromSingleAspectEntity(@Nonnull ENTITY entity, @Nonnull Class<ASPECT> aspectClass) {
        RecordTemplate aspect;
        Constructor<ASPECT> constructor;
        try {
            Class[] constructorParamArray = new Class[]{};
            constructor = aspectClass.getConstructor(constructorParamArray);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Exception occurred while trying to get the default constructor for the aspect. ", e);
        }
        try {
            aspect = (RecordTemplate)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Exception occurred while creating an instance of the aspect. ", e);
        }
        Set aspectFields = aspect.schema().getFields().stream().map(RecordDataSchema.Field::getName).collect(Collectors.toSet());
        Set<String> entityFields = entity.schema().getFields().stream().map(RecordDataSchema.Field::getName).collect(Collectors.toSet());
        entityFields.removeAll(aspectFields);
        try {
            DataMap entityDataMap = entity.data().clone();
            entityFields.forEach(entityDataMap::remove);
            return RecordUtils.toRecordTemplate(aspectClass, entityDataMap);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static <T extends RecordTemplate> RecordDataSchema.Field getRecordDataSchemaField(@Nonnull T recordTemplate, @Nonnull String fieldName) {
        RecordDataSchema.Field field = recordTemplate.schema().getField(fieldName);
        if (field == null) {
            throw new InvalidSchemaException(String.format("Missing expected field '%s' in %s", fieldName, recordTemplate.getClass().getCanonicalName()));
        }
        return field;
    }

    public static <T extends RecordTemplate, V> void setRecordTemplatePrimitiveField(@Nonnull T recordTemplate, @Nonnull String fieldName, @Nonnull V value) {
        RecordDataSchema.Field field = RecordUtils.getRecordDataSchemaField(recordTemplate, fieldName);
        Method putDirect = RecordUtils.getProtectedMethod(RecordTemplate.class, "putDirect", RecordDataSchema.Field.class, Class.class, Object.class, SetMode.class);
        RecordUtils.invokeProtectedMethod(recordTemplate, putDirect, new Object[]{field, value.getClass(), value, SetMode.DISALLOW_NULL});
    }

    public static <T extends RecordTemplate, V> void setRecordTemplateComplexField(@Nonnull T recordTemplate, @Nonnull String fieldName, @Nonnull V value) {
        RecordDataSchema.Field field = RecordUtils.getRecordDataSchemaField(recordTemplate, fieldName);
        Method putWrapped = RecordUtils.getProtectedMethod(RecordTemplate.class, "putWrapped", RecordDataSchema.Field.class, Class.class, DataTemplate.class, SetMode.class);
        RecordUtils.invokeProtectedMethod(recordTemplate, putWrapped, new Object[]{field, value.getClass(), value, SetMode.DISALLOW_NULL});
    }

    @Nonnull
    public static <T extends RecordTemplate, V> V getRecordTemplateField(@Nonnull T recordTemplate, @Nonnull String fieldName, @Nonnull Class<V> valueClass) {
        RecordDataSchema.Field field = RecordUtils.getRecordDataSchemaField(recordTemplate, fieldName);
        Method obtainCustomType = RecordUtils.getProtectedMethod(RecordTemplate.class, "obtainCustomType", RecordDataSchema.Field.class, Class.class, GetMode.class);
        return (V)RecordUtils.invokeProtectedMethod(recordTemplate, obtainCustomType, new Object[]{field, valueClass, GetMode.STRICT});
    }

    @Nonnull
    public static <T extends RecordTemplate, V extends DataTemplate> V getRecordTemplateWrappedField(@Nonnull T recordTemplate, @Nonnull String fieldName, @Nonnull Class<V> valueClass) {
        RecordDataSchema.Field field = RecordUtils.getRecordDataSchemaField(recordTemplate, fieldName);
        Method obtainWrapped = RecordUtils.getProtectedMethod(RecordTemplate.class, "obtainWrapped", RecordDataSchema.Field.class, Class.class, GetMode.class);
        return (V)((DataTemplate)RecordUtils.invokeProtectedMethod(recordTemplate, obtainWrapped, new Object[]{field, valueClass, GetMode.STRICT}));
    }

    @Nonnull
    public static <V extends RecordTemplate> RecordTemplate getSelectedRecordTemplateFromUnion(@Nonnull UnionTemplate unionTemplate) {
        DataSchema dataSchema = unionTemplate.memberType();
        if (!(dataSchema instanceof RecordDataSchema)) {
            throw new InvalidSchemaException("The currently selected member isn't a RecordTemplate in " + unionTemplate.getClass().getCanonicalName());
        }
        Class<RecordTemplate> clazz = ModelUtils.getClassFromName(((RecordDataSchema)dataSchema).getBindingName(), RecordTemplate.class);
        Method obtainWrapped = RecordUtils.getProtectedMethod(UnionTemplate.class, "obtainWrapped", DataSchema.class, Class.class, String.class);
        List<UnionDataSchema.Member> members = ((UnionDataSchema)unionTemplate.schema()).getMembers();
        for (UnionDataSchema.Member m4 : members) {
            if (!m4.hasAlias() || !m4.getType().getDereferencedDataSchema().getUnionMemberKey().equals(clazz.getName())) continue;
            return (RecordTemplate)RecordUtils.invokeProtectedMethod(unionTemplate, obtainWrapped, dataSchema, clazz, m4.getAlias());
        }
        return (RecordTemplate)RecordUtils.invokeProtectedMethod(unionTemplate, obtainWrapped, dataSchema, clazz, ((RecordDataSchema)dataSchema).getFullName());
    }

    @Nonnull
    public static <V extends RecordTemplate> RecordTemplate setSelectedRecordTemplateInUnion(@Nonnull UnionTemplate unionTemplate, @Nonnull RecordTemplate selectedMember) {
        Method selectWrapped = RecordUtils.getProtectedMethod(UnionTemplate.class, "selectWrapped", DataSchema.class, Class.class, String.class, DataTemplate.class);
        List<UnionDataSchema.Member> members = ((UnionDataSchema)unionTemplate.schema()).getMembers();
        for (UnionDataSchema.Member m4 : members) {
            if (!m4.hasAlias() || !m4.getType().getDereferencedDataSchema().getUnionMemberKey().equals(selectedMember.getClass().getName())) continue;
            return (RecordTemplate)RecordUtils.invokeProtectedMethod(unionTemplate, selectWrapped, selectedMember.schema(), selectedMember.getClass(), m4.getAlias(), selectedMember);
        }
        return (RecordTemplate)RecordUtils.invokeProtectedMethod(unionTemplate, selectWrapped, selectedMember.schema(), selectedMember.getClass(), selectedMember.schema().getUnionMemberKey(), selectedMember);
    }

    @Nonnull
    private static Method getProtectedMethod(@Nonnull Class clazz, @Nonnull String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private static <T> T invokeProtectedMethod(Object object, Method method, Object ... args) {
        try {
            method.setAccessible(true);
            Object object2 = method.invoke(object, args);
            return (T)object2;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            method.setAccessible(false);
        }
    }

    @Nonnull
    private static Map<String, Method> getMethodsFromRecordTemplate(@Nonnull RecordTemplate recordTemplate) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        for (RecordDataSchema.Field field : recordTemplate.schema().getFields()) {
            String capitalizedName = RecordUtils.capitalizeFirst(field.getName());
            String getMethodName = (field.getType().getType().equals((Object)DataSchema.Type.BOOLEAN) ? "is" : "get") + capitalizedName;
            try {
                methodMap.put(field.getName(), recordTemplate.getClass().getMethod(getMethodName, new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(String.format("Failed to get method [%s], for class [%s], field [%s]", getMethodName, recordTemplate.getClass().getCanonicalName(), field.getName()), e);
            }
        }
        return Collections.unmodifiableMap(methodMap);
    }

    @Nullable
    private static Object invokeMethod(@Nonnull RecordTemplate record, @Nonnull String fieldName) {
        METHOD_CACHE.putIfAbsent(record.getClass(), RecordUtils.getMethodsFromRecordTemplate(record));
        try {
            return METHOD_CACHE.get(record.getClass()).get(fieldName).invoke((Object)record, new Object[0]);
        }
        catch (IllegalAccessException | NullPointerException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Failed to execute method for class [%s], field [%s]", record.getClass().getCanonicalName(), fieldName), e);
        }
    }

    @Nullable
    private static Object getUnionMember(@Nonnull UnionTemplate union, @Nonnull String memberName) {
        if (union.data() instanceof DataMap) {
            return ((DataMap)union.data()).get(memberName);
        }
        throw new RuntimeException(String.format("Failed to extract member from union [%s], member [%s]", union.getClass().getCanonicalName(), memberName));
    }

    @Nonnull
    private static List<Object> getReferenceForAbstractArray(@Nonnull AbstractArrayTemplate<Object> reference, @Nonnull PathSpec ps) {
        if (!reference.isEmpty()) {
            return Arrays.stream(reference.toArray()).map(x -> RecordUtils.getFieldValue(x, ps)).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nullable
    private static List<Object> getNullableReferenceForAbstractArray(@Nonnull AbstractArrayTemplate<Object> reference, @Nonnull PathSpec ps) {
        if (!reference.isEmpty()) {
            return Arrays.stream(reference.toArray()).map(x -> RecordUtils.getNullableFieldValue(x, ps)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static Optional<Object> getFieldValue(@Nonnull Object record, @Nonnull String pathSpecAsString) {
        pathSpecAsString = LEADING_SPACESLASH_PATTERN.matcher(pathSpecAsString).replaceAll("");
        if (!(pathSpecAsString = TRAILING_SPACESLASH_PATTERN.matcher(pathSpecAsString).replaceAll("")).isEmpty()) {
            return RecordUtils.getFieldValue(record, new PathSpec(SLASH_PATERN.split(pathSpecAsString)));
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<Object> getFieldValue(@Nonnull Object record, @Nonnull PathSpec ps) {
        Object reference = record;
        int pathSize = ps.getPathComponents().size();
        for (int i = 0; i < pathSize; ++i) {
            String part = ps.getPathComponents().get(i);
            if (part.equals(ARRAY_WILDCARD)) continue;
            if (StringUtils.isNumeric(part)) {
                throw new UnsupportedOperationException(String.format("Array indexing is not supported for %s (%s from %s)", part, ps, reference));
            }
            if (reference instanceof RecordTemplate) {
                if ((reference = RecordUtils.invokeMethod((RecordTemplate)reference, part)) != null) continue;
                return Optional.empty();
            }
            if (reference instanceof UnionTemplate) {
                if ((reference = RecordUtils.getUnionMember((UnionTemplate)reference, part)) != null) continue;
                return Optional.empty();
            }
            if (reference instanceof AbstractArrayTemplate) {
                return Optional.of(RecordUtils.getReferenceForAbstractArray((AbstractArrayTemplate)reference, new PathSpec(ps.getPathComponents().subList(i, pathSize))));
            }
            throw new UnsupportedOperationException(String.format("Failed at extracting %s (%s from %s)", part, ps, record));
        }
        return Optional.of(reference);
    }

    @Nullable
    public static Object getNullableFieldValue(@Nonnull Object record, @Nonnull PathSpec ps) {
        Object reference = record;
        int pathSize = ps.getPathComponents().size();
        for (int i = 0; i < pathSize; ++i) {
            String part = ps.getPathComponents().get(i);
            if (part.equals(ARRAY_WILDCARD)) continue;
            if (StringUtils.isNumeric(part)) {
                throw new UnsupportedOperationException(String.format("Array indexing is not supported for %s (%s from %s)", part, ps, reference));
            }
            if (reference instanceof RecordTemplate) {
                reference = RecordUtils.invokeMethod((RecordTemplate)reference, part);
                continue;
            }
            if (reference instanceof UnionTemplate) {
                reference = RecordUtils.getUnionMember((UnionTemplate)reference, part);
                continue;
            }
            if (reference instanceof AbstractArrayTemplate) {
                return RecordUtils.getNullableReferenceForAbstractArray((AbstractArrayTemplate)reference, new PathSpec(ps.getPathComponents().subList(i, pathSize)));
            }
            return null;
        }
        return reference;
    }
}

