/*
 * Decompiled with CFR 0.152.
 */
package com.homihq.db2rest.jdbc.config.dialect;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.homihq.db2rest.core.exception.GenericDataAccessException;
import com.homihq.db2rest.jdbc.config.dialect.Dialect;
import com.homihq.db2rest.jdbc.config.model.Database;
import com.homihq.db2rest.jdbc.config.model.DbTable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDialect
extends Dialect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OracleDialect.class);

    public OracleDialect(ObjectMapper objectMapper) {
        super(objectMapper, "\"");
    }

    public boolean isSupportedDb(String productName, int majorVersion) {
        return StringUtils.equalsIgnoreCase((CharSequence)productName, (CharSequence)Database.ORACLE.getProductName());
    }

    public String getReadSqlTemplate() {
        return "read-ora-12";
    }

    public boolean supportBatchReturnKeys() {
        return false;
    }

    public void processTypes(DbTable table, List<String> insertableColumns, Map<String, Object> data) {
        try {
            for (String columnName : insertableColumns) {
                Object value = data.get(columnName);
                String columnDataTypeName = table.getColumnDataTypeName(columnName);
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)columnDataTypeName, (CharSequence[])new CharSequence[]{"json"})) {
                    data.put(columnName, this.getObjectMapper().writeValueAsString(value));
                    continue;
                }
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)columnDataTypeName, (CharSequence[])new CharSequence[]{"TIMESTAMP(6)"})) continue;
                LocalDateTime v = this.convertToLocalDateTime((String)value);
                data.put(columnName, v);
            }
        }
        catch (Exception exception) {
            throw new GenericDataAccessException(exception.getMessage());
        }
    }

    private LocalDateTime convertToLocalDateTime(String value) {
        try {
            return LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
        }
        catch (Exception e) {
            throw new GenericDataAccessException("Error converting to LocalDateTime type - " + e.getLocalizedMessage());
        }
    }

    private String getQuotedName(String name) {
        return this.getCoverChar() + name + this.getCoverChar();
    }

    public String renderTableName(DbTable table, boolean containsWhere, boolean deleteOp) {
        return this.getQuotedName(table.schema()) + "." + this.getQuotedName(table.name()) + " " + table.alias();
    }

    public String renderTableNameWithoutAlias(DbTable table) {
        return this.getQuotedName(table.schema()) + "." + this.getQuotedName(table.name());
    }
}

