# coding: utf-8

"""
    mzTab validation API.

    This is an mzTab validation service.  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: nils.hoffmann@isas.de
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from swagger_client.models.comment import Comment  # noqa: F401,E501
from swagger_client.models.opt_column_mapping import OptColumnMapping  # noqa: F401,E501
from swagger_client.models.parameter import Parameter  # noqa: F401,E501
from swagger_client.models.spectra_ref import SpectraRef  # noqa: F401,E501


class SmallMoleculeEvidence(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'prefix': 'str',
        'header_prefix': 'str',
        'sme_id': 'int',
        'evidence_input_id': 'str',
        'database_identifier': 'str',
        'chemical_formula': 'str',
        'smiles': 'str',
        'inchi': 'str',
        'chemical_name': 'str',
        'uri': 'str',
        'derivatized_form': 'Parameter',
        'adduct_ion': 'str',
        'exp_mass_to_charge': 'float',
        'charge': 'int',
        'theoretical_mass_to_charge': 'float',
        'spectra_ref': 'list[SpectraRef]',
        'identification_method': 'Parameter',
        'ms_level': 'Parameter',
        'id_confidence_measure': 'list[float]',
        'rank': 'int',
        'opt': 'list[OptColumnMapping]',
        'comment': 'list[Comment]'
    }

    attribute_map = {
        'prefix': 'prefix',
        'header_prefix': 'header_prefix',
        'sme_id': 'sme_id',
        'evidence_input_id': 'evidence_input_id',
        'database_identifier': 'database_identifier',
        'chemical_formula': 'chemical_formula',
        'smiles': 'smiles',
        'inchi': 'inchi',
        'chemical_name': 'chemical_name',
        'uri': 'uri',
        'derivatized_form': 'derivatized_form',
        'adduct_ion': 'adduct_ion',
        'exp_mass_to_charge': 'exp_mass_to_charge',
        'charge': 'charge',
        'theoretical_mass_to_charge': 'theoretical_mass_to_charge',
        'spectra_ref': 'spectra_ref',
        'identification_method': 'identification_method',
        'ms_level': 'ms_level',
        'id_confidence_measure': 'id_confidence_measure',
        'rank': 'rank',
        'opt': 'opt',
        'comment': 'comment'
    }

    def __init__(self, prefix='SME', header_prefix='SEH', sme_id=None, evidence_input_id=None, database_identifier=None, chemical_formula=None, smiles=None, inchi=None, chemical_name=None, uri=None, derivatized_form=None, adduct_ion=None, exp_mass_to_charge=None, charge=None, theoretical_mass_to_charge=None, spectra_ref=None, identification_method=None, ms_level=None, id_confidence_measure=None, rank=None, opt=None, comment=None):  # noqa: E501
        """SmallMoleculeEvidence - a model defined in Swagger"""  # noqa: E501

        self._prefix = None
        self._header_prefix = None
        self._sme_id = None
        self._evidence_input_id = None
        self._database_identifier = None
        self._chemical_formula = None
        self._smiles = None
        self._inchi = None
        self._chemical_name = None
        self._uri = None
        self._derivatized_form = None
        self._adduct_ion = None
        self._exp_mass_to_charge = None
        self._charge = None
        self._theoretical_mass_to_charge = None
        self._spectra_ref = None
        self._identification_method = None
        self._ms_level = None
        self._id_confidence_measure = None
        self._rank = None
        self._opt = None
        self._comment = None
        self.discriminator = None

        self.prefix = prefix
        self.header_prefix = header_prefix
        if sme_id is not None:
            self.sme_id = sme_id
        if evidence_input_id is not None:
            self.evidence_input_id = evidence_input_id
        if database_identifier is not None:
            self.database_identifier = database_identifier
        if chemical_formula is not None:
            self.chemical_formula = chemical_formula
        if smiles is not None:
            self.smiles = smiles
        if inchi is not None:
            self.inchi = inchi
        if chemical_name is not None:
            self.chemical_name = chemical_name
        if uri is not None:
            self.uri = uri
        if derivatized_form is not None:
            self.derivatized_form = derivatized_form
        if adduct_ion is not None:
            self.adduct_ion = adduct_ion
        if exp_mass_to_charge is not None:
            self.exp_mass_to_charge = exp_mass_to_charge
        if charge is not None:
            self.charge = charge
        if theoretical_mass_to_charge is not None:
            self.theoretical_mass_to_charge = theoretical_mass_to_charge
        if spectra_ref is not None:
            self.spectra_ref = spectra_ref
        if identification_method is not None:
            self.identification_method = identification_method
        if ms_level is not None:
            self.ms_level = ms_level
        if id_confidence_measure is not None:
            self.id_confidence_measure = id_confidence_measure
        if rank is not None:
            self.rank = rank
        if opt is not None:
            self.opt = opt
        if comment is not None:
            self.comment = comment

    @property
    def prefix(self):
        """Gets the prefix of this SmallMoleculeEvidence.  # noqa: E501


        :return: The prefix of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """Sets the prefix of this SmallMoleculeEvidence.


        :param prefix: The prefix of this SmallMoleculeEvidence.  # noqa: E501
        :type: str
        """
        if prefix is None:
            raise ValueError("Invalid value for `prefix`, must not be `None`")  # noqa: E501
        allowed_values = ["SME"]  # noqa: E501
        if prefix not in allowed_values:
            raise ValueError(
                "Invalid value for `prefix` ({0}), must be one of {1}"  # noqa: E501
                .format(prefix, allowed_values)
            )

        self._prefix = prefix

    @property
    def header_prefix(self):
        """Gets the header_prefix of this SmallMoleculeEvidence.  # noqa: E501


        :return: The header_prefix of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._header_prefix

    @header_prefix.setter
    def header_prefix(self, header_prefix):
        """Sets the header_prefix of this SmallMoleculeEvidence.


        :param header_prefix: The header_prefix of this SmallMoleculeEvidence.  # noqa: E501
        :type: str
        """
        if header_prefix is None:
            raise ValueError("Invalid value for `header_prefix`, must not be `None`")  # noqa: E501
        allowed_values = ["SEH"]  # noqa: E501
        if header_prefix not in allowed_values:
            raise ValueError(
                "Invalid value for `header_prefix` ({0}), must be one of {1}"  # noqa: E501
                .format(header_prefix, allowed_values)
            )

        self._header_prefix = header_prefix

    @property
    def sme_id(self):
        """Gets the sme_id of this SmallMoleculeEvidence.  # noqa: E501


        :return: The sme_id of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: int
        """
        return self._sme_id

    @sme_id.setter
    def sme_id(self, sme_id):
        """Sets the sme_id of this SmallMoleculeEvidence.


        :param sme_id: The sme_id of this SmallMoleculeEvidence.  # noqa: E501
        :type: int
        """

        self._sme_id = sme_id

    @property
    def evidence_input_id(self):
        """Gets the evidence_input_id of this SmallMoleculeEvidence.  # noqa: E501


        :return: The evidence_input_id of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._evidence_input_id

    @evidence_input_id.setter
    def evidence_input_id(self, evidence_input_id):
        """Sets the evidence_input_id of this SmallMoleculeEvidence.


        :param evidence_input_id: The evidence_input_id of this SmallMoleculeEvidence.  # noqa: E501
        :type: str
        """

        self._evidence_input_id = evidence_input_id

    @property
    def database_identifier(self):
        """Gets the database_identifier of this SmallMoleculeEvidence.  # noqa: E501


        :return: The database_identifier of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._database_identifier

    @database_identifier.setter
    def database_identifier(self, database_identifier):
        """Sets the database_identifier of this SmallMoleculeEvidence.


        :param database_identifier: The database_identifier of this SmallMoleculeEvidence.  # noqa: E501
        :type: str
        """

        self._database_identifier = database_identifier

    @property
    def chemical_formula(self):
        """Gets the chemical_formula of this SmallMoleculeEvidence.  # noqa: E501


        :return: The chemical_formula of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._chemical_formula

    @chemical_formula.setter
    def chemical_formula(self, chemical_formula):
        """Sets the chemical_formula of this SmallMoleculeEvidence.


        :param chemical_formula: The chemical_formula of this SmallMoleculeEvidence.  # noqa: E501
        :type: str
        """

        self._chemical_formula = chemical_formula

    @property
    def smiles(self):
        """Gets the smiles of this SmallMoleculeEvidence.  # noqa: E501


        :return: The smiles of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._smiles

    @smiles.setter
    def smiles(self, smiles):
        """Sets the smiles of this SmallMoleculeEvidence.


        :param smiles: The smiles of this SmallMoleculeEvidence.  # noqa: E501
        :type: str
        """

        self._smiles = smiles

    @property
    def inchi(self):
        """Gets the inchi of this SmallMoleculeEvidence.  # noqa: E501


        :return: The inchi of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._inchi

    @inchi.setter
    def inchi(self, inchi):
        """Sets the inchi of this SmallMoleculeEvidence.


        :param inchi: The inchi of this SmallMoleculeEvidence.  # noqa: E501
        :type: str
        """

        self._inchi = inchi

    @property
    def chemical_name(self):
        """Gets the chemical_name of this SmallMoleculeEvidence.  # noqa: E501


        :return: The chemical_name of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._chemical_name

    @chemical_name.setter
    def chemical_name(self, chemical_name):
        """Sets the chemical_name of this SmallMoleculeEvidence.


        :param chemical_name: The chemical_name of this SmallMoleculeEvidence.  # noqa: E501
        :type: str
        """

        self._chemical_name = chemical_name

    @property
    def uri(self):
        """Gets the uri of this SmallMoleculeEvidence.  # noqa: E501


        :return: The uri of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this SmallMoleculeEvidence.


        :param uri: The uri of this SmallMoleculeEvidence.  # noqa: E501
        :type: str
        """

        self._uri = uri

    @property
    def derivatized_form(self):
        """Gets the derivatized_form of this SmallMoleculeEvidence.  # noqa: E501


        :return: The derivatized_form of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: Parameter
        """
        return self._derivatized_form

    @derivatized_form.setter
    def derivatized_form(self, derivatized_form):
        """Sets the derivatized_form of this SmallMoleculeEvidence.


        :param derivatized_form: The derivatized_form of this SmallMoleculeEvidence.  # noqa: E501
        :type: Parameter
        """

        self._derivatized_form = derivatized_form

    @property
    def adduct_ion(self):
        """Gets the adduct_ion of this SmallMoleculeEvidence.  # noqa: E501


        :return: The adduct_ion of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: str
        """
        return self._adduct_ion

    @adduct_ion.setter
    def adduct_ion(self, adduct_ion):
        """Sets the adduct_ion of this SmallMoleculeEvidence.


        :param adduct_ion: The adduct_ion of this SmallMoleculeEvidence.  # noqa: E501
        :type: str
        """
        if adduct_ion is not None and not re.search('^\\[\\d*M([-][\\w]*)\\]\\d*[+-]$', adduct_ion):  # noqa: E501
            raise ValueError("Invalid value for `adduct_ion`, must be a follow pattern or equal to `/^\\[\\d*M([-][\\w]*)\\]\\d*[+-]$/`")  # noqa: E501

        self._adduct_ion = adduct_ion

    @property
    def exp_mass_to_charge(self):
        """Gets the exp_mass_to_charge of this SmallMoleculeEvidence.  # noqa: E501


        :return: The exp_mass_to_charge of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: float
        """
        return self._exp_mass_to_charge

    @exp_mass_to_charge.setter
    def exp_mass_to_charge(self, exp_mass_to_charge):
        """Sets the exp_mass_to_charge of this SmallMoleculeEvidence.


        :param exp_mass_to_charge: The exp_mass_to_charge of this SmallMoleculeEvidence.  # noqa: E501
        :type: float
        """

        self._exp_mass_to_charge = exp_mass_to_charge

    @property
    def charge(self):
        """Gets the charge of this SmallMoleculeEvidence.  # noqa: E501


        :return: The charge of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: int
        """
        return self._charge

    @charge.setter
    def charge(self, charge):
        """Sets the charge of this SmallMoleculeEvidence.


        :param charge: The charge of this SmallMoleculeEvidence.  # noqa: E501
        :type: int
        """

        self._charge = charge

    @property
    def theoretical_mass_to_charge(self):
        """Gets the theoretical_mass_to_charge of this SmallMoleculeEvidence.  # noqa: E501


        :return: The theoretical_mass_to_charge of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: float
        """
        return self._theoretical_mass_to_charge

    @theoretical_mass_to_charge.setter
    def theoretical_mass_to_charge(self, theoretical_mass_to_charge):
        """Sets the theoretical_mass_to_charge of this SmallMoleculeEvidence.


        :param theoretical_mass_to_charge: The theoretical_mass_to_charge of this SmallMoleculeEvidence.  # noqa: E501
        :type: float
        """

        self._theoretical_mass_to_charge = theoretical_mass_to_charge

    @property
    def spectra_ref(self):
        """Gets the spectra_ref of this SmallMoleculeEvidence.  # noqa: E501


        :return: The spectra_ref of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: list[SpectraRef]
        """
        return self._spectra_ref

    @spectra_ref.setter
    def spectra_ref(self, spectra_ref):
        """Sets the spectra_ref of this SmallMoleculeEvidence.


        :param spectra_ref: The spectra_ref of this SmallMoleculeEvidence.  # noqa: E501
        :type: list[SpectraRef]
        """

        self._spectra_ref = spectra_ref

    @property
    def identification_method(self):
        """Gets the identification_method of this SmallMoleculeEvidence.  # noqa: E501


        :return: The identification_method of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: Parameter
        """
        return self._identification_method

    @identification_method.setter
    def identification_method(self, identification_method):
        """Sets the identification_method of this SmallMoleculeEvidence.


        :param identification_method: The identification_method of this SmallMoleculeEvidence.  # noqa: E501
        :type: Parameter
        """

        self._identification_method = identification_method

    @property
    def ms_level(self):
        """Gets the ms_level of this SmallMoleculeEvidence.  # noqa: E501


        :return: The ms_level of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: Parameter
        """
        return self._ms_level

    @ms_level.setter
    def ms_level(self, ms_level):
        """Sets the ms_level of this SmallMoleculeEvidence.


        :param ms_level: The ms_level of this SmallMoleculeEvidence.  # noqa: E501
        :type: Parameter
        """

        self._ms_level = ms_level

    @property
    def id_confidence_measure(self):
        """Gets the id_confidence_measure of this SmallMoleculeEvidence.  # noqa: E501


        :return: The id_confidence_measure of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: list[float]
        """
        return self._id_confidence_measure

    @id_confidence_measure.setter
    def id_confidence_measure(self, id_confidence_measure):
        """Sets the id_confidence_measure of this SmallMoleculeEvidence.


        :param id_confidence_measure: The id_confidence_measure of this SmallMoleculeEvidence.  # noqa: E501
        :type: list[float]
        """

        self._id_confidence_measure = id_confidence_measure

    @property
    def rank(self):
        """Gets the rank of this SmallMoleculeEvidence.  # noqa: E501


        :return: The rank of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: int
        """
        return self._rank

    @rank.setter
    def rank(self, rank):
        """Sets the rank of this SmallMoleculeEvidence.


        :param rank: The rank of this SmallMoleculeEvidence.  # noqa: E501
        :type: int
        """

        self._rank = rank

    @property
    def opt(self):
        """Gets the opt of this SmallMoleculeEvidence.  # noqa: E501


        :return: The opt of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: list[OptColumnMapping]
        """
        return self._opt

    @opt.setter
    def opt(self, opt):
        """Sets the opt of this SmallMoleculeEvidence.


        :param opt: The opt of this SmallMoleculeEvidence.  # noqa: E501
        :type: list[OptColumnMapping]
        """

        self._opt = opt

    @property
    def comment(self):
        """Gets the comment of this SmallMoleculeEvidence.  # noqa: E501


        :return: The comment of this SmallMoleculeEvidence.  # noqa: E501
        :rtype: list[Comment]
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this SmallMoleculeEvidence.


        :param comment: The comment of this SmallMoleculeEvidence.  # noqa: E501
        :type: list[Comment]
        """

        self._comment = comment

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SmallMoleculeEvidence):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
