# coding: utf-8

"""
    mzTab validation API.

    This is an mzTab validation service.  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: nils.hoffmann@isas.de
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from swagger_client.models.assay import Assay  # noqa: F401,E501
from swagger_client.models.column_parameter_mapping import ColumnParameterMapping  # noqa: F401,E501
from swagger_client.models.contact import Contact  # noqa: F401,E501
from swagger_client.models.cv import CV  # noqa: F401,E501
from swagger_client.models.database import Database  # noqa: F401,E501
from swagger_client.models.instrument import Instrument  # noqa: F401,E501
from swagger_client.models.ms_run import MsRun  # noqa: F401,E501
from swagger_client.models.parameter import Parameter  # noqa: F401,E501
from swagger_client.models.publication import Publication  # noqa: F401,E501
from swagger_client.models.sample import Sample  # noqa: F401,E501
from swagger_client.models.sample_processing import SampleProcessing  # noqa: F401,E501
from swagger_client.models.software import Software  # noqa: F401,E501
from swagger_client.models.study_variable import StudyVariable  # noqa: F401,E501
from swagger_client.models.uri import Uri  # noqa: F401,E501


class Metadata(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'prefix': 'str',
        'mz_tab_version': 'str',
        'mz_tab_id': 'str',
        'title': 'str',
        'description': 'str',
        'sample_processing': 'list[SampleProcessing]',
        'instrument': 'list[Instrument]',
        'software': 'list[Software]',
        'publication': 'list[Publication]',
        'contact': 'list[Contact]',
        'uri': 'list[Uri]',
        'external_study_uri': 'list[Uri]',
        'quantification_method': 'Parameter',
        'study_variable': 'list[StudyVariable]',
        'assay': 'list[Assay]',
        'ms_run': 'list[MsRun]',
        'custom': 'list[Parameter]',
        'sample': 'list[Sample]',
        'cv': 'list[CV]',
        'database': 'list[Database]',
        'derivatization_agent': 'list[Parameter]',
        'small_molecule_quantification_unit': 'Parameter',
        'small_molecule_feature_quantification_unit': 'Parameter',
        'small_molecule_identification_reliability': 'Parameter',
        'id_confidence_measure': 'list[Parameter]',
        'colunit_small_molecule': 'list[ColumnParameterMapping]',
        'colunit_small_molecule_feature': 'list[ColumnParameterMapping]',
        'colunit_small_molecule_evidence': 'list[ColumnParameterMapping]'
    }

    attribute_map = {
        'prefix': 'prefix',
        'mz_tab_version': 'mzTab-version',
        'mz_tab_id': 'mzTab-ID',
        'title': 'title',
        'description': 'description',
        'sample_processing': 'sample_processing',
        'instrument': 'instrument',
        'software': 'software',
        'publication': 'publication',
        'contact': 'contact',
        'uri': 'uri',
        'external_study_uri': 'external_study_uri',
        'quantification_method': 'quantification_method',
        'study_variable': 'study_variable',
        'assay': 'assay',
        'ms_run': 'ms_run',
        'custom': 'custom',
        'sample': 'sample',
        'cv': 'cv',
        'database': 'database',
        'derivatization_agent': 'derivatization_agent',
        'small_molecule_quantification_unit': 'small_molecule-quantification_unit',
        'small_molecule_feature_quantification_unit': 'small_molecule_feature-quantification_unit',
        'small_molecule_identification_reliability': 'small_molecule-identification_reliability',
        'id_confidence_measure': 'id_confidence_measure',
        'colunit_small_molecule': 'colunit-small_molecule',
        'colunit_small_molecule_feature': 'colunit-small_molecule_feature',
        'colunit_small_molecule_evidence': 'colunit-small_molecule_evidence'
    }

    def __init__(self, prefix='MTD', mz_tab_version=None, mz_tab_id=None, title=None, description=None, sample_processing=None, instrument=None, software=None, publication=None, contact=None, uri=None, external_study_uri=None, quantification_method=None, study_variable=None, assay=None, ms_run=None, custom=None, sample=None, cv=None, database=None, derivatization_agent=None, small_molecule_quantification_unit=None, small_molecule_feature_quantification_unit=None, small_molecule_identification_reliability=None, id_confidence_measure=None, colunit_small_molecule=None, colunit_small_molecule_feature=None, colunit_small_molecule_evidence=None):  # noqa: E501
        """Metadata - a model defined in Swagger"""  # noqa: E501

        self._prefix = None
        self._mz_tab_version = None
        self._mz_tab_id = None
        self._title = None
        self._description = None
        self._sample_processing = None
        self._instrument = None
        self._software = None
        self._publication = None
        self._contact = None
        self._uri = None
        self._external_study_uri = None
        self._quantification_method = None
        self._study_variable = None
        self._assay = None
        self._ms_run = None
        self._custom = None
        self._sample = None
        self._cv = None
        self._database = None
        self._derivatization_agent = None
        self._small_molecule_quantification_unit = None
        self._small_molecule_feature_quantification_unit = None
        self._small_molecule_identification_reliability = None
        self._id_confidence_measure = None
        self._colunit_small_molecule = None
        self._colunit_small_molecule_feature = None
        self._colunit_small_molecule_evidence = None
        self.discriminator = None

        self.prefix = prefix
        self.mz_tab_version = mz_tab_version
        self.mz_tab_id = mz_tab_id
        if title is not None:
            self.title = title
        if description is not None:
            self.description = description
        if sample_processing is not None:
            self.sample_processing = sample_processing
        if instrument is not None:
            self.instrument = instrument
        self.software = software
        if publication is not None:
            self.publication = publication
        if contact is not None:
            self.contact = contact
        if uri is not None:
            self.uri = uri
        if external_study_uri is not None:
            self.external_study_uri = external_study_uri
        self.quantification_method = quantification_method
        self.study_variable = study_variable
        self.assay = assay
        self.ms_run = ms_run
        if custom is not None:
            self.custom = custom
        if sample is not None:
            self.sample = sample
        self.cv = cv
        self.database = database
        if derivatization_agent is not None:
            self.derivatization_agent = derivatization_agent
        self.small_molecule_quantification_unit = small_molecule_quantification_unit
        self.small_molecule_feature_quantification_unit = small_molecule_feature_quantification_unit
        if small_molecule_identification_reliability is not None:
            self.small_molecule_identification_reliability = small_molecule_identification_reliability
        self.id_confidence_measure = id_confidence_measure
        if colunit_small_molecule is not None:
            self.colunit_small_molecule = colunit_small_molecule
        if colunit_small_molecule_feature is not None:
            self.colunit_small_molecule_feature = colunit_small_molecule_feature
        if colunit_small_molecule_evidence is not None:
            self.colunit_small_molecule_evidence = colunit_small_molecule_evidence

    @property
    def prefix(self):
        """Gets the prefix of this Metadata.  # noqa: E501


        :return: The prefix of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """Sets the prefix of this Metadata.


        :param prefix: The prefix of this Metadata.  # noqa: E501
        :type: str
        """
        if prefix is None:
            raise ValueError("Invalid value for `prefix`, must not be `None`")  # noqa: E501
        allowed_values = ["MTD"]  # noqa: E501
        if prefix not in allowed_values:
            raise ValueError(
                "Invalid value for `prefix` ({0}), must be one of {1}"  # noqa: E501
                .format(prefix, allowed_values)
            )

        self._prefix = prefix

    @property
    def mz_tab_version(self):
        """Gets the mz_tab_version of this Metadata.  # noqa: E501


        :return: The mz_tab_version of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._mz_tab_version

    @mz_tab_version.setter
    def mz_tab_version(self, mz_tab_version):
        """Sets the mz_tab_version of this Metadata.


        :param mz_tab_version: The mz_tab_version of this Metadata.  # noqa: E501
        :type: str
        """
        if mz_tab_version is None:
            raise ValueError("Invalid value for `mz_tab_version`, must not be `None`")  # noqa: E501
        if mz_tab_version is not None and not re.search('^\\\\d{1}\\.\\\\d{1}\\.\\\\d{1}-[A-Z]{1}$', mz_tab_version):  # noqa: E501
            raise ValueError("Invalid value for `mz_tab_version`, must be a follow pattern or equal to `/^\\\\d{1}\\.\\\\d{1}\\.\\\\d{1}-[A-Z]{1}$/`")  # noqa: E501

        self._mz_tab_version = mz_tab_version

    @property
    def mz_tab_id(self):
        """Gets the mz_tab_id of this Metadata.  # noqa: E501


        :return: The mz_tab_id of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._mz_tab_id

    @mz_tab_id.setter
    def mz_tab_id(self, mz_tab_id):
        """Sets the mz_tab_id of this Metadata.


        :param mz_tab_id: The mz_tab_id of this Metadata.  # noqa: E501
        :type: str
        """
        if mz_tab_id is None:
            raise ValueError("Invalid value for `mz_tab_id`, must not be `None`")  # noqa: E501

        self._mz_tab_id = mz_tab_id

    @property
    def title(self):
        """Gets the title of this Metadata.  # noqa: E501


        :return: The title of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Metadata.


        :param title: The title of this Metadata.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def description(self):
        """Gets the description of this Metadata.  # noqa: E501


        :return: The description of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Metadata.


        :param description: The description of this Metadata.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def sample_processing(self):
        """Gets the sample_processing of this Metadata.  # noqa: E501


        :return: The sample_processing of this Metadata.  # noqa: E501
        :rtype: list[SampleProcessing]
        """
        return self._sample_processing

    @sample_processing.setter
    def sample_processing(self, sample_processing):
        """Sets the sample_processing of this Metadata.


        :param sample_processing: The sample_processing of this Metadata.  # noqa: E501
        :type: list[SampleProcessing]
        """

        self._sample_processing = sample_processing

    @property
    def instrument(self):
        """Gets the instrument of this Metadata.  # noqa: E501


        :return: The instrument of this Metadata.  # noqa: E501
        :rtype: list[Instrument]
        """
        return self._instrument

    @instrument.setter
    def instrument(self, instrument):
        """Sets the instrument of this Metadata.


        :param instrument: The instrument of this Metadata.  # noqa: E501
        :type: list[Instrument]
        """

        self._instrument = instrument

    @property
    def software(self):
        """Gets the software of this Metadata.  # noqa: E501


        :return: The software of this Metadata.  # noqa: E501
        :rtype: list[Software]
        """
        return self._software

    @software.setter
    def software(self, software):
        """Sets the software of this Metadata.


        :param software: The software of this Metadata.  # noqa: E501
        :type: list[Software]
        """
        if software is None:
            raise ValueError("Invalid value for `software`, must not be `None`")  # noqa: E501

        self._software = software

    @property
    def publication(self):
        """Gets the publication of this Metadata.  # noqa: E501


        :return: The publication of this Metadata.  # noqa: E501
        :rtype: list[Publication]
        """
        return self._publication

    @publication.setter
    def publication(self, publication):
        """Sets the publication of this Metadata.


        :param publication: The publication of this Metadata.  # noqa: E501
        :type: list[Publication]
        """

        self._publication = publication

    @property
    def contact(self):
        """Gets the contact of this Metadata.  # noqa: E501


        :return: The contact of this Metadata.  # noqa: E501
        :rtype: list[Contact]
        """
        return self._contact

    @contact.setter
    def contact(self, contact):
        """Sets the contact of this Metadata.


        :param contact: The contact of this Metadata.  # noqa: E501
        :type: list[Contact]
        """

        self._contact = contact

    @property
    def uri(self):
        """Gets the uri of this Metadata.  # noqa: E501


        :return: The uri of this Metadata.  # noqa: E501
        :rtype: list[Uri]
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this Metadata.


        :param uri: The uri of this Metadata.  # noqa: E501
        :type: list[Uri]
        """

        self._uri = uri

    @property
    def external_study_uri(self):
        """Gets the external_study_uri of this Metadata.  # noqa: E501


        :return: The external_study_uri of this Metadata.  # noqa: E501
        :rtype: list[Uri]
        """
        return self._external_study_uri

    @external_study_uri.setter
    def external_study_uri(self, external_study_uri):
        """Sets the external_study_uri of this Metadata.


        :param external_study_uri: The external_study_uri of this Metadata.  # noqa: E501
        :type: list[Uri]
        """

        self._external_study_uri = external_study_uri

    @property
    def quantification_method(self):
        """Gets the quantification_method of this Metadata.  # noqa: E501


        :return: The quantification_method of this Metadata.  # noqa: E501
        :rtype: Parameter
        """
        return self._quantification_method

    @quantification_method.setter
    def quantification_method(self, quantification_method):
        """Sets the quantification_method of this Metadata.


        :param quantification_method: The quantification_method of this Metadata.  # noqa: E501
        :type: Parameter
        """
        if quantification_method is None:
            raise ValueError("Invalid value for `quantification_method`, must not be `None`")  # noqa: E501

        self._quantification_method = quantification_method

    @property
    def study_variable(self):
        """Gets the study_variable of this Metadata.  # noqa: E501


        :return: The study_variable of this Metadata.  # noqa: E501
        :rtype: list[StudyVariable]
        """
        return self._study_variable

    @study_variable.setter
    def study_variable(self, study_variable):
        """Sets the study_variable of this Metadata.


        :param study_variable: The study_variable of this Metadata.  # noqa: E501
        :type: list[StudyVariable]
        """
        if study_variable is None:
            raise ValueError("Invalid value for `study_variable`, must not be `None`")  # noqa: E501

        self._study_variable = study_variable

    @property
    def assay(self):
        """Gets the assay of this Metadata.  # noqa: E501


        :return: The assay of this Metadata.  # noqa: E501
        :rtype: list[Assay]
        """
        return self._assay

    @assay.setter
    def assay(self, assay):
        """Sets the assay of this Metadata.


        :param assay: The assay of this Metadata.  # noqa: E501
        :type: list[Assay]
        """
        if assay is None:
            raise ValueError("Invalid value for `assay`, must not be `None`")  # noqa: E501

        self._assay = assay

    @property
    def ms_run(self):
        """Gets the ms_run of this Metadata.  # noqa: E501


        :return: The ms_run of this Metadata.  # noqa: E501
        :rtype: list[MsRun]
        """
        return self._ms_run

    @ms_run.setter
    def ms_run(self, ms_run):
        """Sets the ms_run of this Metadata.


        :param ms_run: The ms_run of this Metadata.  # noqa: E501
        :type: list[MsRun]
        """
        if ms_run is None:
            raise ValueError("Invalid value for `ms_run`, must not be `None`")  # noqa: E501

        self._ms_run = ms_run

    @property
    def custom(self):
        """Gets the custom of this Metadata.  # noqa: E501


        :return: The custom of this Metadata.  # noqa: E501
        :rtype: list[Parameter]
        """
        return self._custom

    @custom.setter
    def custom(self, custom):
        """Sets the custom of this Metadata.


        :param custom: The custom of this Metadata.  # noqa: E501
        :type: list[Parameter]
        """

        self._custom = custom

    @property
    def sample(self):
        """Gets the sample of this Metadata.  # noqa: E501


        :return: The sample of this Metadata.  # noqa: E501
        :rtype: list[Sample]
        """
        return self._sample

    @sample.setter
    def sample(self, sample):
        """Sets the sample of this Metadata.


        :param sample: The sample of this Metadata.  # noqa: E501
        :type: list[Sample]
        """

        self._sample = sample

    @property
    def cv(self):
        """Gets the cv of this Metadata.  # noqa: E501


        :return: The cv of this Metadata.  # noqa: E501
        :rtype: list[CV]
        """
        return self._cv

    @cv.setter
    def cv(self, cv):
        """Sets the cv of this Metadata.


        :param cv: The cv of this Metadata.  # noqa: E501
        :type: list[CV]
        """
        if cv is None:
            raise ValueError("Invalid value for `cv`, must not be `None`")  # noqa: E501

        self._cv = cv

    @property
    def database(self):
        """Gets the database of this Metadata.  # noqa: E501


        :return: The database of this Metadata.  # noqa: E501
        :rtype: list[Database]
        """
        return self._database

    @database.setter
    def database(self, database):
        """Sets the database of this Metadata.


        :param database: The database of this Metadata.  # noqa: E501
        :type: list[Database]
        """
        if database is None:
            raise ValueError("Invalid value for `database`, must not be `None`")  # noqa: E501

        self._database = database

    @property
    def derivatization_agent(self):
        """Gets the derivatization_agent of this Metadata.  # noqa: E501


        :return: The derivatization_agent of this Metadata.  # noqa: E501
        :rtype: list[Parameter]
        """
        return self._derivatization_agent

    @derivatization_agent.setter
    def derivatization_agent(self, derivatization_agent):
        """Sets the derivatization_agent of this Metadata.


        :param derivatization_agent: The derivatization_agent of this Metadata.  # noqa: E501
        :type: list[Parameter]
        """

        self._derivatization_agent = derivatization_agent

    @property
    def small_molecule_quantification_unit(self):
        """Gets the small_molecule_quantification_unit of this Metadata.  # noqa: E501


        :return: The small_molecule_quantification_unit of this Metadata.  # noqa: E501
        :rtype: Parameter
        """
        return self._small_molecule_quantification_unit

    @small_molecule_quantification_unit.setter
    def small_molecule_quantification_unit(self, small_molecule_quantification_unit):
        """Sets the small_molecule_quantification_unit of this Metadata.


        :param small_molecule_quantification_unit: The small_molecule_quantification_unit of this Metadata.  # noqa: E501
        :type: Parameter
        """
        if small_molecule_quantification_unit is None:
            raise ValueError("Invalid value for `small_molecule_quantification_unit`, must not be `None`")  # noqa: E501

        self._small_molecule_quantification_unit = small_molecule_quantification_unit

    @property
    def small_molecule_feature_quantification_unit(self):
        """Gets the small_molecule_feature_quantification_unit of this Metadata.  # noqa: E501


        :return: The small_molecule_feature_quantification_unit of this Metadata.  # noqa: E501
        :rtype: Parameter
        """
        return self._small_molecule_feature_quantification_unit

    @small_molecule_feature_quantification_unit.setter
    def small_molecule_feature_quantification_unit(self, small_molecule_feature_quantification_unit):
        """Sets the small_molecule_feature_quantification_unit of this Metadata.


        :param small_molecule_feature_quantification_unit: The small_molecule_feature_quantification_unit of this Metadata.  # noqa: E501
        :type: Parameter
        """
        if small_molecule_feature_quantification_unit is None:
            raise ValueError("Invalid value for `small_molecule_feature_quantification_unit`, must not be `None`")  # noqa: E501

        self._small_molecule_feature_quantification_unit = small_molecule_feature_quantification_unit

    @property
    def small_molecule_identification_reliability(self):
        """Gets the small_molecule_identification_reliability of this Metadata.  # noqa: E501


        :return: The small_molecule_identification_reliability of this Metadata.  # noqa: E501
        :rtype: Parameter
        """
        return self._small_molecule_identification_reliability

    @small_molecule_identification_reliability.setter
    def small_molecule_identification_reliability(self, small_molecule_identification_reliability):
        """Sets the small_molecule_identification_reliability of this Metadata.


        :param small_molecule_identification_reliability: The small_molecule_identification_reliability of this Metadata.  # noqa: E501
        :type: Parameter
        """

        self._small_molecule_identification_reliability = small_molecule_identification_reliability

    @property
    def id_confidence_measure(self):
        """Gets the id_confidence_measure of this Metadata.  # noqa: E501


        :return: The id_confidence_measure of this Metadata.  # noqa: E501
        :rtype: list[Parameter]
        """
        return self._id_confidence_measure

    @id_confidence_measure.setter
    def id_confidence_measure(self, id_confidence_measure):
        """Sets the id_confidence_measure of this Metadata.


        :param id_confidence_measure: The id_confidence_measure of this Metadata.  # noqa: E501
        :type: list[Parameter]
        """
        if id_confidence_measure is None:
            raise ValueError("Invalid value for `id_confidence_measure`, must not be `None`")  # noqa: E501

        self._id_confidence_measure = id_confidence_measure

    @property
    def colunit_small_molecule(self):
        """Gets the colunit_small_molecule of this Metadata.  # noqa: E501


        :return: The colunit_small_molecule of this Metadata.  # noqa: E501
        :rtype: list[ColumnParameterMapping]
        """
        return self._colunit_small_molecule

    @colunit_small_molecule.setter
    def colunit_small_molecule(self, colunit_small_molecule):
        """Sets the colunit_small_molecule of this Metadata.


        :param colunit_small_molecule: The colunit_small_molecule of this Metadata.  # noqa: E501
        :type: list[ColumnParameterMapping]
        """

        self._colunit_small_molecule = colunit_small_molecule

    @property
    def colunit_small_molecule_feature(self):
        """Gets the colunit_small_molecule_feature of this Metadata.  # noqa: E501


        :return: The colunit_small_molecule_feature of this Metadata.  # noqa: E501
        :rtype: list[ColumnParameterMapping]
        """
        return self._colunit_small_molecule_feature

    @colunit_small_molecule_feature.setter
    def colunit_small_molecule_feature(self, colunit_small_molecule_feature):
        """Sets the colunit_small_molecule_feature of this Metadata.


        :param colunit_small_molecule_feature: The colunit_small_molecule_feature of this Metadata.  # noqa: E501
        :type: list[ColumnParameterMapping]
        """

        self._colunit_small_molecule_feature = colunit_small_molecule_feature

    @property
    def colunit_small_molecule_evidence(self):
        """Gets the colunit_small_molecule_evidence of this Metadata.  # noqa: E501


        :return: The colunit_small_molecule_evidence of this Metadata.  # noqa: E501
        :rtype: list[ColumnParameterMapping]
        """
        return self._colunit_small_molecule_evidence

    @colunit_small_molecule_evidence.setter
    def colunit_small_molecule_evidence(self, colunit_small_molecule_evidence):
        """Sets the colunit_small_molecule_evidence of this Metadata.


        :param colunit_small_molecule_evidence: The colunit_small_molecule_evidence of this Metadata.  # noqa: E501
        :type: list[ColumnParameterMapping]
        """

        self._colunit_small_molecule_evidence = colunit_small_molecule_evidence

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Metadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
