/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.util;

import com.novell.ldap.LDAPAttributeSchema;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPObjectClassSchema;
import com.novell.ldap.LDAPSchema;
import java.lang.reflect.Field;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class TableDef {
    String dn;
    String scope;
    String combined;
    ArrayList metadata;
    HashMap attrMetaData;
    private String name;
    private static final String synbase = "1.3.6.1.4.1.1466.115.121.1.";
    private static final String adSynBase = "1.2.840.113556.1.4.90";
    static HashMap syntaxToSQL = new HashMap();
    private HashMap addPatterns;

    public TableDef(String name, String dn, String scope, String[] objectClasses, LDAPConnection ldapcon, HashMap addPatternMap) throws LDAPException {
        this.name = name;
        this.dn = dn;
        this.scope = scope;
        this.combined = scope + ";" + dn;
        this.attrMetaData = new HashMap();
        LDAPSchema schema = ldapcon.fetchSchema(ldapcon.getSchemaDN());
        HashSet<String> proced = new HashSet<String>();
        HashSet procedAttribs = new HashSet();
        proced.add("top");
        int index = 0;
        this.metadata = new ArrayList();
        for (String oc : objectClasses) {
            if (proced.contains(oc)) continue;
            LDAPObjectClassSchema ocSchema = schema.getObjectClassSchema(oc);
            index = this.extractObjectClass(schema, proced, procedAttribs, index, oc, ocSchema);
        }
        this.addPatterns = addPatternMap;
    }

    private int extractObjectClass(LDAPSchema schema, HashSet proced, HashSet procedAttribs, int index, String oc, LDAPObjectClassSchema ocSchema) {
        for (String sup : ocSchema.getSuperiors()) {
            if (proced.contains(sup)) continue;
            index = this.extractObjectClass(schema, proced, procedAttribs, index, sup, schema.getObjectClassSchema(sup));
            proced.add(sup);
        }
        index = this.addObjectClass(oc, this.metadata, schema, index, procedAttribs);
        proced.add(oc);
        return index;
    }

    private int addObjectClass(String oc, ArrayList table, LDAPSchema schema, int index, Set procedAttribs) {
        String name;
        LDAPAttributeSchema attribSchema;
        LinkedHashMap<String, Object> row;
        int i;
        int m;
        LDAPObjectClassSchema ocSchema = schema.getObjectClassSchema(oc);
        String[] attribs = ocSchema.getOptionalAttributes();
        if (attribs != null) {
            m = attribs.length;
            for (i = 0; i < m; ++i) {
                row = new LinkedHashMap<String, Object>();
                attribSchema = schema.getAttributeSchema(attribs[i]);
                name = attribSchema.getNames()[0];
                if (attribSchema == null || procedAttribs.contains(attribSchema.getNames()[0])) continue;
                row.put("TABLE_CAT", null);
                row.put("TABLE_SCHEM", null);
                row.put("TABLE_NAME", this.name);
                row.put("COLUMN_NAME", attribSchema.getNames()[0]);
                row.put("DATA_TYPE", new Integer(this.getType(attribSchema.getSyntaxString())));
                row.put("TYPE_NAME", this.getTypeName(attribSchema.getSyntaxString()));
                row.put("COLUMN_SIZE", new Integer(255));
                row.put("BUFFER_LENGTH", new Integer(0));
                row.put("DECIMAL_DIGITS", new Integer(10));
                row.put("NUM_PREC_RADIX", new Integer(10));
                row.put("NULLABLE", "columnNullable");
                row.put("REMARKS", attribSchema.getDescription());
                row.put("COLUMN_DEF", null);
                row.put("SQL_DATA_TYPE", new Integer(0));
                row.put("SQL_DATETIME_SUB", new Integer(0));
                row.put("CHAR_OCTET_LENGTH", new Integer(255));
                row.put("ORDINAL_POSITION", new Integer(++index));
                row.put("IS_NULLABLE", "YES");
                row.put("SCOPE_CATALOG", null);
                row.put("SCOPE_TABLE", null);
                row.put("SCOPE_DATA_TYPE", null);
                table.add(row);
                this.attrMetaData.put(attribSchema.getNames()[0], row);
                procedAttribs.add(attribSchema.getNames()[0]);
            }
        }
        if ((attribs = ocSchema.getRequiredAttributes()) != null) {
            m = attribs.length;
            for (i = 0; i < m; ++i) {
                row = new LinkedHashMap();
                attribSchema = schema.getAttributeSchema(attribs[i]);
                name = attribSchema.getNames()[0];
                if (attribSchema == null || procedAttribs.contains(attribSchema.getNames()[0])) continue;
                row.put("TABLE_CAT", null);
                row.put("TABLE_SCHEM", null);
                row.put("TABLE_NAME", this.name);
                row.put("COLUMN_NAME", attribSchema.getNames()[0]);
                row.put("DATA_TYPE", new Integer(this.getType(attribSchema.getSyntaxString())));
                row.put("TYPE_NAME", this.getTypeName(attribSchema.getSyntaxString()));
                row.put("COLUMN_SIZE", new Integer(255));
                row.put("BUFFER_LENGTH", new Integer(0));
                row.put("DECIMAL_DIGITS", new Integer(10));
                row.put("NUM_PREC_RADIX", new Integer(10));
                row.put("NULLABLE", "columnNoNulls ");
                row.put("REMARKS", attribSchema.getDescription());
                row.put("COLUMN_DEF", null);
                row.put("SQL_DATA_TYPE", new Integer(0));
                row.put("SQL_DATETIME_SUB", new Integer(0));
                row.put("CHAR_OCTET_LENGTH", new Integer(255));
                row.put("ORDINAL_POSITION", new Integer(++index));
                row.put("IS_NULLABLE", "NO");
                row.put("SCOPE_CATALOG", null);
                row.put("SCOPE_TABLE", null);
                row.put("SCOPE_DATA_TYPE", null);
                this.attrMetaData.put(attribSchema.getNames()[0], row);
                table.add(row);
                procedAttribs.add(attribSchema.getNames()[0]);
            }
        }
        return index;
    }

    private String getTypeName(String syntaxString) {
        int index = syntaxString.indexOf(123);
        if (index != -1) {
            syntaxString = syntaxString.substring(0, index);
        }
        return (String)syntaxToSQL.get(syntaxString);
    }

    private int getType(String syntaxString) {
        Field[] fields = Types.class.getFields();
        String name = this.getTypeName(syntaxString);
        if (name == null) {
            return -1;
        }
        int m = fields.length;
        for (int i = 0; i < m; ++i) {
            if (!fields[i].getName().equals(name)) continue;
            try {
                return fields[i].getInt(null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return -1;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return -1;
            }
        }
        return -1;
    }

    public ArrayList getTable() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public String getScopeBase() {
        return this.combined;
    }

    public HashMap getAddPatterns() {
        return this.addPatterns;
    }

    public String getBase() {
        return this.dn;
    }

    static {
        syntaxToSQL.put("name", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.3", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.5", "BINARY");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.6", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.7", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.8", "BINARY");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.9", "BINARY");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.10", "BINARY");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.11", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.12", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.14", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.15", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.16", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.17", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.21", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.22", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.23", "BINARY");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.24", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.25", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.26", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.27", "INTEGER");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.28", "BINARY");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.30", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.31", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.33", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.34", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.35", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.36", "INTEGER");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.37", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.38", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.39", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.40", "BINARY");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.41", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.43", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.44", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.50", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.51", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.53", "VARCHAR");
        syntaxToSQL.put("1.3.6.1.4.1.1466.115.121.1.54", "VARCHAR");
        syntaxToSQL.put("1.2.840.113556.1.4.903", "BINARY");
        syntaxToSQL.put("1.2.840.113556.1.4.905", "VARCHAR");
        syntaxToSQL.put("1.2.840.113556.1.4.906", "INTEGER");
        syntaxToSQL.put("1.2.840.113556.1.4.907", "BINARY");
    }
}

