/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.util;

import com.octetstring.jdbcLdap.util.Entry;
import java.io.BufferedReader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class LDIF {
    public static final String DN = "dn";
    public static final String SEP = ": ";
    public static final String BIN_SEP = ":: ";
    LinkedList ldif;
    boolean debug;

    public LDIF() {
        this.ldif = new LinkedList();
    }

    public LDIF(String ldif, boolean debug) throws Exception {
        String line;
        this.debug = debug;
        StringReader r = new StringReader(ldif);
        BufferedReader in = new BufferedReader(r);
        String attr = null;
        String val = null;
        this.ldif = new LinkedList();
        HashMap<String, LinkedList<String>> entry = null;
        while ((line = in.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            try {
                attr = line.substring(0, line.indexOf(SEP)).trim();
                val = line.substring(line.indexOf(SEP) + SEP.length());
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                System.out.println("Error on line : " + line);
                System.exit(1);
            }
            if (attr.equalsIgnoreCase(DN)) {
                entry = new HashMap<String, LinkedList<String>>();
                this.ldif.add(new Entry(val, entry));
                continue;
            }
            LinkedList<String> attrib = (LinkedList<String>)entry.get(attr);
            if (attrib == null) {
                attrib = new LinkedList<String>();
                entry.put(attr, attrib);
            }
            attrib.add(val);
        }
    }

    public LDIF(ResultSet rs, String dnField, boolean debug) throws Exception {
        this.debug = debug;
        this.ldif = new LinkedList();
        HashMap entry = null;
        while (rs.next()) {
            entry = new HashMap();
            String dn = rs.getString(dnField);
            this.ldif.add(new Entry(dn, entry));
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String attr = rsmd.getColumnName(i);
                String val = rs.getString(attr);
                if (attr.equals(dnField) || val.trim().length() == 0) continue;
                LinkedList<String> attrib = new LinkedList<String>();
                entry.put(attr, attrib);
                if (val.charAt(0) == '[' && val.charAt(val.length() - 1) == ']') {
                    StringTokenizer tok = new StringTokenizer(val.substring(1, val.length() - 1), "][", false);
                    while (tok.hasMoreTokens()) {
                        attrib.add(tok.nextToken());
                    }
                    continue;
                }
                attrib.add(val);
            }
        }
    }

    public boolean compareLdif(LDIF o, LDIF diffLdif) {
        if (!(o instanceof LDIF)) {
            return false;
        }
        LinkedList ldif1 = (LinkedList)this.ldif.clone();
        LinkedList ldif2 = (LinkedList)o.ldif.clone();
        LinkedList<Entry> diff = new LinkedList<Entry>();
        boolean match = true;
        boolean equals = true;
        if (this.debug) {
            System.out.println("ldif 1: " + ldif1.size());
            System.out.println("ldif 2: " + ldif2.size());
        }
        Entry ent22 = null;
        String dn = null;
        Iterator entries2 = null;
        Iterator entries = ldif1.iterator();
        boolean found = false;
        while (entries.hasNext()) {
            Entry ent = (Entry)entries.next();
            dn = ent.getDn();
            entries2 = ldif2.iterator();
            found = false;
            match = true;
            while (entries2.hasNext()) {
                ent22 = (Entry)entries2.next();
                if (!ent22.getDn().equalsIgnoreCase(dn)) continue;
                found = true;
                ldif2.remove(ent22);
                break;
            }
            if (!found) {
                System.out.println("DN " + dn + " not found");
                match = false;
            }
            HashMap attribs = ent.getAtts();
            HashMap attribs2 = null;
            if (found) {
                attribs2 = (HashMap)ent22.getAtts().clone();
            }
            Iterator attribsKeys = attribs.keySet().iterator();
            while (found && attribsKeys.hasNext()) {
                String attrib1 = (String)attribsKeys.next();
                if (this.debug) {
                    System.out.println("Looking for : " + attrib1);
                }
                LinkedList ts1 = (LinkedList)attribs.get(attrib1);
                Iterator itat = attribs2.keySet().iterator();
                LinkedList ts2 = null;
                while (itat.hasNext()) {
                    String tmpval = (String)itat.next();
                    if (!tmpval.equalsIgnoreCase(attrib1)) continue;
                    ts2 = (LinkedList)attribs2.remove(tmpval);
                    ts2 = (LinkedList)ts2.clone();
                    break;
                }
                if (ts2 == null) {
                    match = false;
                    System.out.println("FAILED : " + dn);
                    break;
                }
                Iterator tsi = ts1.iterator();
                while (tsi.hasNext()) {
                    String val = (String)tsi.next();
                    if (this.debug) {
                        System.out.println("\tAttib : " + attrib1);
                        System.out.println("\tVal : " + val);
                    }
                    found = false;
                    Iterator it = ts2.iterator();
                    while (it.hasNext()) {
                        String val2 = (String)it.next();
                        if (!val2.equalsIgnoreCase(val)) continue;
                        found = true;
                        it.remove();
                        tsi.remove();
                        break;
                    }
                    if (this.debug) {
                        System.out.println("\tContains : " + found);
                    }
                    if (found) continue;
                    System.out.println("FAILED : " + dn);
                    match = false;
                }
                if (this.debug) {
                    System.out.println("ts2.size() : " + ts2.size());
                    System.out.println("ts1.size() : " + ts1.size());
                }
                if (ts2.size() == 0) continue;
                System.out.println("FAILED : " + dn);
                match = false;
            }
            if (this.debug) {
                System.out.println("attribs2.size() : " + (attribs2 != null ? Integer.toString(attribs2.size()) : "null"));
            }
            if (attribs2 == null || attribs2.size() != 0) {
                System.out.println("FAILED : " + dn);
                match = false;
            }
            if (match) continue;
            System.out.println("FAILED : " + dn);
            equals = false;
            diff.add(ent);
        }
        if (this.debug) {
            System.out.println("ldif2.size() : " + ldif2.size());
        }
        if (ldif2.size() != 0) {
            for (Entry ent22 : ldif2) {
                System.out.println("FAILED : " + (dn != null ? dn : ""));
                diff.add(ent22);
            }
            equals = false;
        }
        if (!equals) {
            diffLdif.ldif = diff;
        }
        return equals;
    }

    public String toString() {
        StringBuffer ldif = new StringBuffer();
        for (Entry ent : this.ldif) {
            String dn = ent.getDn();
            ldif.append("dn: ").append(dn).append('\n');
            HashMap entry = ent.getAtts();
            for (String attrib : entry.keySet()) {
                LinkedList ts = (LinkedList)entry.get(attrib);
                Iterator vals = ts.iterator();
                while (vals.hasNext()) {
                    ldif.append(attrib).append(SEP).append(vals.next()).append('\n');
                }
            }
            ldif.append('\n');
        }
        return ldif.toString();
    }
}

