/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.sql.statements;

import com.octetstring.jdbcLdap.backend.DirectoryUpdateEntry;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSql;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSqlAbs;
import com.octetstring.jdbcLdap.util.Pair;
import com.octetstring.jdbcLdap.util.TableDef;
import com.octetstring.jdbcLdap.util.UpdateSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class JdbcLdapUpdateEntry
extends JdbcLdapSqlAbs
implements JdbcLdapSql {
    public static final String UPDATE_ENTRY = "update entry";
    public static final String DELETE = "delete";
    public static final String ADD = "add";
    public static final String REPLACE = "replace";
    public static final String WHERE = " where ";
    public static final String DO = " do ";
    public static final String SET = " set ";
    public static final String QMARK = "?";
    public static final String SEMI_COLON = ";";
    String cmd;
    LinkedList cmds;
    int numArgs;
    String[] argVals;
    SqlStore sqlStore;
    ArrayList offset;
    LinkedList attribs;
    private DirectoryUpdateEntry ue;

    public void init(JndiLdapConnection con, String SQL) throws SQLException {
        this.ue = (DirectoryUpdateEntry)con.getImplClasses().get("UpdateEntry");
        boolean paramcount = false;
        this.cmds = new LinkedList();
        boolean hasWhere = true;
        String lsql = SQL.toLowerCase();
        int begin = lsql.indexOf(UPDATE_ENTRY) + UPDATE_ENTRY.length();
        int end = lsql.indexOf(DO);
        String dn = SQL.substring(begin, end).trim();
        if (con.getTableDefs().containsKey(dn)) {
            dn = ((TableDef)con.getTableDefs().get(dn)).getScopeBase();
        }
        this.where = null;
        int semi = dn.indexOf(SEMI_COLON);
        if (semi != -1) {
            String sscope = dn.substring(0, semi);
            dn = dn.substring(semi + 1);
            Integer iscope = (Integer)this.scopes.get(sscope);
            if (iscope != null) {
                this.scope = iscope;
            } else {
                iscope = (Integer)this.scopes.get(con.getScope());
                if (iscope == null) {
                    throw new SQLException("Invalid search scope : " + con.getScope());
                }
                this.scope = iscope;
            }
        } else {
            Integer iscope = (Integer)this.scopes.get(con.getScope());
            if (iscope == null) {
                throw new SQLException("Invalid search scope : " + con.getScope());
            }
            this.scope = iscope;
        }
        begin = end;
        end = lsql.indexOf(WHERE);
        if (end == -1) {
            hasWhere = false;
            end = lsql.length();
        }
        int whereIndex = end;
        String cmdSQL = SQL.substring(begin, end);
        String lCmdSql = cmdSQL.toLowerCase();
        boolean ok = true;
        begin = 0;
        this.offset = new ArrayList();
        int params = 0;
        while (ok) {
            String attribValue;
            String attribName;
            begin = lCmdSql.indexOf(DO, begin) + DO.length();
            end = lCmdSql.indexOf(SET, begin);
            String cmd = cmdSQL.substring(begin, end).trim();
            begin = lCmdSql.indexOf(SET, end) + SET.length();
            if ((end = lCmdSql.indexOf(DO, begin)) == -1) {
                ok = false;
                end = lCmdSql.length();
            }
            String attribs = cmdSQL.substring(begin, end);
            if (ok) {
                begin = end;
            }
            ArrayList<Object> attribList = new ArrayList<Object>(5);
            this.cmds.add(new UpdateSet(cmd, attribList));
            if (cmd.equalsIgnoreCase(ADD) || cmd.equalsIgnoreCase(REPLACE)) {
                LinkedList attribsExploded = this.explodeDN(attribs);
                for (String attr : attribsExploded) {
                    attribName = attr.substring(0, attr.indexOf("="));
                    attribValue = attr.substring(attr.indexOf("=") + 1);
                    if (attribValue.charAt(0) == '\"' || attribValue.charAt(0) == '\'') {
                        attribValue = attribValue.substring(1, attribValue.length() - 1);
                    }
                    if (attribValue.trim().equals(QMARK)) {
                        this.offset.add(new Integer(params++));
                    }
                    attribList.add(new Pair(attribName.trim(), attribValue));
                }
                continue;
            }
            StringTokenizer toker = new StringTokenizer(attribs, ",", false);
            while (toker.hasMoreTokens()) {
                String attr;
                attr = toker.nextToken();
                if (attr.indexOf(61) != -1) {
                    attribName = attr.substring(0, attr.indexOf("="));
                    attribValue = attr.substring(attr.indexOf("=") + 1);
                    attribList.add(new Pair(attribName.trim(), attribValue.trim()));
                    continue;
                }
                attribList.add(attr.trim());
            }
        }
        if (hasWhere) {
            begin = whereIndex + WHERE.length();
            this.where = con.nativeSQL(this.sqlArgsToLdap(SQL.substring(begin).trim()));
        }
        this.sqlStore = new SqlStore(SQL);
        this.sqlStore.setDistinguishedName(dn);
        this.numArgs = this.offset.size();
        this.argVals = new String[this.numArgs];
        this.from = dn;
        this.sqlStore.setScope(this.scope);
        this.sqlStore.setCommand(this.cmd);
        this.sqlStore.setArgs(this.numArgs);
        this.sqlStore.setAttribs(this.attribs);
        this.sqlStore.setCmds(this.cmds);
        this.sqlStore.setOffsetList(this.offset);
        if (this.where == null || this.where.trim().length() == 0) {
            this.where = "(objectClass=*)";
        }
        this.sqlStore.setWhere(this.where);
        this.con = con;
    }

    public void init(JndiLdapConnection con, String SQL, SqlStore sqlStore) throws SQLException {
        this.ue = (DirectoryUpdateEntry)con.getImplClasses().get("UpdateEntry");
        this.con = con;
        this.sqlStore = sqlStore;
        this.numArgs = sqlStore.getArgs();
        this.attribs = sqlStore.getAttribs();
        this.cmd = sqlStore.getCommand();
        this.cmds = sqlStore.getCmds();
        this.argVals = new String[this.numArgs];
        this.offset = sqlStore.getOffsetList();
        this.argVals = new String[this.offset.size()];
        this.where = sqlStore.getWhere();
        this.scope = sqlStore.getScope();
    }

    public Object executeQuery() throws SQLException {
        return null;
    }

    public Object executeUpdate() throws SQLException {
        return new Integer(this.ue.doUpdateEntryJldap(this));
    }

    public void setValue(int pos, String value) throws SQLException {
        if (pos < this.argVals.length) {
            this.argVals[pos] = value;
        } else {
            this.args[pos - this.argVals.length] = value;
        }
    }

    public SqlStore getSqlStore() {
        return this.sqlStore;
    }

    public boolean getRetrieveDN() {
        return false;
    }

    public boolean isUpdate() {
        return true;
    }

    public String[] getArgVals() {
        return this.argVals;
    }

    public LinkedList getAttribs() {
        return this.attribs;
    }

    public String getCmd() {
        return this.cmd;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    public LinkedList getCmds() {
        return this.cmds;
    }

    public void setCmds(LinkedList list) {
        this.cmds = list;
    }
}

