/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.sql.statements;

import com.octetstring.jdbcLdap.backend.DirectoryUpdate;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSql;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSqlAbs;
import com.octetstring.jdbcLdap.util.TableDef;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;

public class JdbcLdapUpdate
extends JdbcLdapSqlAbs
implements JdbcLdapSql {
    static final char QUOTE = '\"';
    static final String DEFAULT_SEARCH_FILTER = "(objectClass=*)";
    DirectoryUpdate update;
    static final String QMARK = "?";
    static final String EQUALS = "=";
    static final String UPDATE = "update";
    static final String SET = " set ";
    static final String WHERE = " where ";
    static final String COMMA = ",";
    SqlStore store;
    String[] fields;
    String[] vals;
    int[] offset;
    int border;

    public Object executeQuery() throws SQLException {
        throw new SQLException("UPDATE can not execute a query");
    }

    public Object executeUpdate() throws SQLException {
        return new Integer(this.update.doUpdateJldap(this));
    }

    public boolean getRetrieveDN() {
        return false;
    }

    public SqlStore getSqlStore() {
        return this.store;
    }

    public void init(JndiLdapConnection con, String SQL) throws SQLException {
        Integer iscope;
        this.update = (DirectoryUpdate)con.getImplClasses().get("UPDATE");
        this.con = con;
        String tmpSQL = SQL.toLowerCase();
        int begin = tmpSQL.indexOf(UPDATE) + UPDATE.length();
        int end = tmpSQL.indexOf(SET);
        this.from = SQL.substring(begin, end).trim();
        if (con.getTableDefs().containsKey(this.from)) {
            this.from = ((TableDef)con.getTableDefs().get(this.from)).getScopeBase();
        }
        if (this.from.indexOf(";") != -1) {
            String sscope = this.from.substring(0, this.from.indexOf(";")).trim();
            iscope = (Integer)this.scopes.get(sscope);
            this.from = this.from.substring(this.from.indexOf(";") + 1);
        } else {
            iscope = (Integer)this.scopes.get(con.getSearchScope());
        }
        if (iscope == null) {
            throw new SQLException("Unrecognized Search Scope");
        }
        this.scope = iscope;
        begin = tmpSQL.indexOf(SET) + SET.length();
        end = tmpSQL.indexOf(WHERE);
        if (end == -1) {
            end = tmpSQL.length();
        }
        String set = SQL.substring(begin, end);
        LinkedList itok = this.explodeDN(set);
        this.fields = new String[itok.size()];
        this.vals = new String[itok.size()];
        this.offset = new int[itok.size()];
        Iterator it = itok.iterator();
        int i = 0;
        int j = 0;
        while (it.hasNext()) {
            String token = ((String)it.next()).trim();
            this.fields[i] = token.substring(0, token.indexOf(EQUALS));
            this.vals[i] = token.substring(token.indexOf(EQUALS) + 1);
            if (this.vals[i].charAt(0) == '\"' || this.vals[i].charAt(0) == '\'') {
                this.vals[i] = this.vals[i].substring(1, this.vals[i].length() - 1);
            }
            if (this.vals[i].equals(QMARK)) {
                this.offset[j++] = i;
            } else if (this.vals[i].charAt(0) == '\"') {
                this.vals[i] = this.vals[i].substring(1, this.vals[i].lastIndexOf(34));
            }
            ++i;
        }
        this.border = j;
        if (end == tmpSQL.length()) {
            this.where = DEFAULT_SEARCH_FILTER;
            this.border = -1;
        } else {
            begin = end + WHERE.length();
            this.where = con.nativeSQL(this.sqlArgsToLdap(SQL.substring(begin).trim()));
        }
        this.store = new SqlStore(SQL);
        this.store.setFields(this.fields);
        this.store.setDistinguishedName(this.from);
        this.store.setArgs(this.args != null ? this.args.length : 0);
        this.store.setInsertFields(this.vals);
        this.store.setFieldOffset(this.offset);
        this.store.setWhere(this.where);
        this.store.setBorder(this.border);
        this.store.setScope(this.scope);
    }

    public void init(JndiLdapConnection con, String SQL, SqlStore sqlStore) throws SQLException {
        this.update = (DirectoryUpdate)con.getImplClasses().get("UPDATE");
        this.con = con;
        this.store = sqlStore;
        this.fields = this.store.getFields();
        this.from = this.store.getDistinguishedName();
        this.offset = this.store.getFieldOffset();
        this.where = this.store.getWhere();
        this.border = this.store.getBorder();
        this.args = new Object[this.store.getArgs()];
        this.vals = new String[this.fields.length];
        this.scope = this.store.getScope();
        System.arraycopy(sqlStore.getInsertFields(), 0, this.vals, 0, this.vals.length);
    }

    public void setValue(int pos, String value) throws SQLException {
        if (pos < this.border || this.border == -1) {
            if (pos < 0) {
                throw new SQLException(Integer.toString(pos) + " out of bounds");
            }
            this.vals[this.offset[pos]] = value;
        } else {
            this.args[pos - this.border] = value;
        }
    }

    public String[] getVals() {
        return this.vals;
    }

    public JndiLdapConnection getCon() {
        return this.con;
    }

    public boolean isUpdate() {
        return true;
    }
}

