/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.sql.statements;

import com.novell.ldap.LDAPConnection;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSql;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.naming.directory.DirContext;

public abstract class JdbcLdapSqlAbs
implements JdbcLdapSql {
    static final int OBJECT_SCOPE = 0;
    static final int ONELEVEL_SCOPE = 1;
    static final int SUBTREE_SCOPE = 2;
    HashMap scopes = new HashMap();
    String where;
    Object[] args;
    JndiLdapConnection con;
    String from;
    int queryTimeOut;
    int scope;

    public abstract void init(JndiLdapConnection var1, String var2) throws SQLException;

    public abstract void init(JndiLdapConnection var1, String var2, SqlStore var3) throws SQLException;

    public abstract Object executeQuery() throws SQLException;

    public abstract Object executeUpdate() throws SQLException;

    public abstract void setValue(int var1, String var2) throws SQLException;

    public abstract SqlStore getSqlStore();

    public abstract boolean getRetrieveDN();

    public JdbcLdapSqlAbs() {
        this.scopes.put("objectScope", new Integer(0));
        this.scopes.put("oneLevelScope", new Integer(1));
        this.scopes.put("subTreeScope", new Integer(2));
    }

    String sqlArgsToLdap(String where) {
        StringBuffer buff = new StringBuffer(where);
        StringBuffer arg = new StringBuffer();
        int num = 0;
        int curr = where.indexOf("?");
        if (curr == -1) {
            this.args = new Object[0];
            return where;
        }
        while (curr != -1) {
            if (buff.charAt(curr - 1) != '\\') {
                arg.setLength(0);
                buff.replace(curr, curr + 1, arg.append("{").append(num).append("}").toString());
                ++num;
            } else {
                buff.deleteCharAt(curr - 1);
                ++curr;
            }
            curr = buff.toString().indexOf(63, curr + 1);
        }
        this.args = new Object[num];
        return buff.toString();
    }

    public String getFilterWithParams() {
        if (this.where == null) {
            return null;
        }
        if (this.args == null) {
            this.args = new Object[0];
        }
        int m = this.args.length;
        StringBuffer buf = new StringBuffer(this.where);
        StringBuffer search = new StringBuffer();
        for (int i = 0; i < m; ++i) {
            search.setLength(0);
            search.append("{").append(i).append("}");
            int begin = buf.toString().indexOf(search.toString());
            if (begin == -1) continue;
            int end = begin + search.length();
            buf.replace(begin, end, this.args[i].toString());
        }
        return buf.toString();
    }

    public DirContext getContext() {
        return this.con.getContext();
    }

    public LDAPConnection getConnection() {
        return this.con.getConnection();
    }

    public String getBaseContext() {
        return this.from;
    }

    public void setTimeOut(int time) {
        this.queryTimeOut = time;
    }

    public int getTimeOut() {
        return this.queryTimeOut;
    }

    public int getSearchScope() {
        return this.scope;
    }

    protected LinkedList explodeDN(String dn) {
        String currdn;
        LinkedList<String> rdnComponents = new LinkedList<String>();
        String dnstr = dn.toString();
        boolean inquotes = false;
        boolean escaped = false;
        int currentStart = 0;
        char current = '\u0000';
        for (int i = 0; i < dnstr.length(); ++i) {
            current = dnstr.charAt(i);
            if (current == '\\') {
                escaped = !escaped;
                continue;
            }
            if (!(current != '\"' && current != '\'' || escaped)) {
                inquotes = !inquotes;
                continue;
            }
            if (!(current != ',' && current != ';' || escaped || inquotes)) {
                String currdn2 = dnstr.substring(currentStart, i).trim();
                if (currdn2.endsWith("\\") && dnstr.charAt(i - 1) == ' ') {
                    currdn2 = currdn2 + " ";
                }
                if (currdn2.length() > 0) {
                    rdnComponents.add(currdn2);
                }
                currentStart = i + 1;
                continue;
            }
            escaped = false;
        }
        if (dnstr.length() > currentStart && (currdn = dnstr.substring(currentStart, dnstr.length()).trim()).length() > 0) {
            rdnComponents.add(currdn);
        }
        return rdnComponents;
    }

    public String getConnectionBase() {
        return this.con.getBaseContext();
    }

    public JndiLdapConnection getJDBCConnection() {
        return this.con;
    }
}

