/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.sql.statements;

import com.octetstring.jdbcLdap.backend.DirectoryRetrieveResults;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSql;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSqlAbs;
import com.octetstring.jdbcLdap.util.TableDef;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.StringTokenizer;

public class JdbcLdapSelect
extends JdbcLdapSqlAbs
implements JdbcLdapSql {
    static final String DEFAULT_SEARCH_FILTER = "(objectClass=*)";
    public static final String FROM_SCOPE = ";";
    static final String SELECT = "select";
    static final int SELECT_SIZE = 6;
    static final String FROM = "from";
    static final int FROM_SIZE = 4;
    static final String WHERE = "where";
    static final int WHERE_SIZE = 5;
    static final String WILDCARD = "*";
    static final String DN_FIELD = "DN";
    DirectoryRetrieveResults search;
    String sql;
    String[] fields;
    int maxRows = -1;
    SqlStore sqlStore;
    boolean retreiveDN;
    String[] sortBy;
    private HashMap fieldMap;
    private HashMap revFieldMap;

    public JdbcLdapSelect() {
        this.queryTimeOut = -1;
    }

    public Object executeQuery() throws SQLException {
        return this.search.searchJldap(this);
    }

    public void init(JndiLdapConnection con, String SQL, SqlStore sqlStore) throws SQLException {
        this.search = (DirectoryRetrieveResults)con.getImplClasses().get("RETRIEVE_RESULTS");
        this.con = con;
        this.sql = this.sql;
        this.sqlStore = sqlStore;
        this.where = sqlStore.getWhere();
        this.from = sqlStore.getFrom();
        this.fields = sqlStore.getFields();
        this.retreiveDN = sqlStore.getDN();
        this.args = new Object[sqlStore.getArgs()];
        this.scope = sqlStore.getScope();
        this.sortBy = sqlStore.getOrderby();
        this.fieldMap = sqlStore.getFieldMap();
        this.revFieldMap = sqlStore.getRevFieldMap();
    }

    public void init(JndiLdapConnection con, String SQL) throws SQLException {
        Integer scope;
        this.search = (DirectoryRetrieveResults)con.getImplClasses().get("RETRIEVE_RESULTS");
        this.con = con;
        this.retreiveDN = false;
        SQL = SQL.trim();
        String sql = SQL.toLowerCase();
        boolean whereFound = false;
        int begin = sql.indexOf(SELECT) + 6;
        int end = sql.indexOf(FROM);
        String fields = SQL.substring(begin, end);
        if (!(fields = fields.trim()).equalsIgnoreCase(WILDCARD)) {
            StringTokenizer toker = new StringTokenizer(fields, ",");
            this.fields = new String[toker.countTokens()];
            int i = 0;
            while (toker.hasMoreTokens()) {
                this.fields[i] = toker.nextToken().trim();
                String fieldLcase = this.fields[i].toLowerCase();
                int beginas = fieldLcase.indexOf(" as ");
                if (beginas != -1) {
                    String fieldName = this.fields[i].substring(0, beginas).trim();
                    String asName = this.fields[i].substring(beginas + 4).trim();
                    this.fields[i] = fieldName;
                    if (this.fieldMap == null) {
                        this.fieldMap = new HashMap();
                        this.revFieldMap = new HashMap();
                    }
                    this.fieldMap.put(asName, fieldName);
                    this.revFieldMap.put(fieldName, asName);
                }
                if (this.fields[i].equalsIgnoreCase(DN_FIELD)) {
                    this.retreiveDN = true;
                }
                ++i;
            }
        } else {
            this.fields = new String[0];
            this.retreiveDN = true;
        }
        if ((end = sql.indexOf(WHERE, begin = sql.indexOf(FROM, end) + 4)) != -1) {
            this.from = SQL.substring(begin, end).trim();
            whereFound = true;
        } else {
            end = sql.indexOf(" order by ", begin);
            if (end != -1) {
                this.from = SQL.substring(begin, end).trim();
                this.procOrderBy(SQL, end);
            } else {
                this.from = SQL.substring(begin).trim();
            }
        }
        if (con.getTableDefs().containsKey(this.from.trim())) {
            TableDef table = (TableDef)con.getTableDefs().get(this.from.trim());
            this.from = table.getScopeBase();
        }
        if ((end = this.from.indexOf(FROM_SCOPE)) == -1) {
            scope = (Integer)this.scopes.get(con.getSearchScope());
        } else {
            scope = (Integer)this.scopes.get(this.from.substring(0, end).trim());
            this.from = this.from.substring(end + 1).trim();
        }
        if (scope == null) {
            throw new SQLException("Scope not recognized");
        }
        this.scope = scope;
        if (whereFound) {
            begin = sql.indexOf(WHERE, end) + 5;
            if ((end = sql.indexOf(" order by ", begin)) != -1) {
                this.where = con.nativeSQL(this.sqlArgsToLdap(SQL.substring(begin, end).trim()), this.fieldMap);
                this.procOrderBy(SQL, end);
            } else {
                this.where = con.nativeSQL(this.sqlArgsToLdap(SQL.substring(begin).trim()), this.fieldMap);
            }
        } else {
            this.where = DEFAULT_SEARCH_FILTER;
        }
        System.out.println("Sort by : " + this.sortBy);
        this.sqlStore = new SqlStore(SQL);
        this.sqlStore.setOrderby(this.sortBy);
        this.sqlStore.setWhere(this.where);
        this.sqlStore.setFrom(this.from);
        this.sqlStore.setFields(this.fields);
        this.sqlStore.setDN(this.retreiveDN);
        this.sqlStore.setScope(this.scope);
        this.sqlStore.setFieldMap(this.fieldMap);
        this.sqlStore.setRevFieldMap(this.revFieldMap);
        this.sqlStore.setArgs(this.args != null ? this.args.length : 0);
    }

    private void procOrderBy(String SQL, int end) {
        String order = SQL.substring(end + 10).trim();
        StringTokenizer toker = new StringTokenizer(order, ",");
        this.sortBy = new String[toker.countTokens()];
        int m = this.sortBy.length;
        for (int i = 0; i < m; ++i) {
            this.sortBy[i] = toker.nextToken();
        }
    }

    public String getSearchString() {
        return this.where;
    }

    public String[] getSearchAttributes() {
        return this.fields;
    }

    public void setMaxRecords(int rec) {
        this.maxRows = rec;
    }

    public int getMaxRecords() {
        return this.maxRows;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Object executeUpdate() throws SQLException {
        return null;
    }

    public void setValue(int pos, String value) throws SQLException {
        if (pos < 0 || pos > this.args.length) {
            throw new SQLException(Integer.toString(pos) + " out of bounds");
        }
        this.args[pos] = value;
    }

    public SqlStore getSqlStore() {
        return this.sqlStore;
    }

    public boolean getRetrieveDN() {
        return this.retreiveDN;
    }

    public boolean isUpdate() {
        return false;
    }
}

