/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.sql.statements;

import com.novell.ldap.LDAPDN;
import com.octetstring.jdbcLdap.backend.DirectoryInsert;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSql;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSqlAbs;
import com.octetstring.jdbcLdap.util.AddPattern;
import com.octetstring.jdbcLdap.util.Pair;
import com.octetstring.jdbcLdap.util.TableDef;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.directory.DirContext;

public class JdbcLdapInsert
extends JdbcLdapSqlAbs
implements JdbcLdapSql {
    static final String INSERT_INTO = "insert into";
    static final char LPAR = '(';
    static final char RPAR = ')';
    static final String QMARK = "?";
    static final String COMMA = ",";
    static final String EQUALS = "=";
    static final char QUOTE = '\"';
    String dn;
    String[] fields;
    String[] dnFields;
    LinkedList fieldsMap;
    String sql;
    SqlStore store;
    String[] vals;
    int[] offset;
    DirectoryInsert insert;
    private Set dontAdd;
    private String defOC;

    public void init(JndiLdapConnection con, String SQL) throws SQLException {
        LinkedList ltoks;
        this.con = con;
        this.insert = (DirectoryInsert)con.getImplClasses().get("INSERT");
        String tmpSQL = SQL.toLowerCase();
        this.con = con;
        int begin = tmpSQL.indexOf(INSERT_INTO);
        int end = tmpSQL.indexOf(40);
        String tmp = SQL.substring(begin += INSERT_INTO.length(), end);
        this.dn = tmp.trim();
        TableDef def = null;
        if (con != null) {
            def = (TableDef)con.getTableDefs().get(this.dn);
        }
        if (def == null) {
            ltoks = this.explodeDN(this.dn);
            this.parseCtx(ltoks);
        }
        this.fieldsMap = new LinkedList();
        begin = end + 1;
        end = tmpSQL.indexOf(41, begin);
        tmp = SQL.substring(begin, end);
        StringTokenizer tok = new StringTokenizer(tmp, COMMA, false);
        this.fields = new String[tok.countTokens()];
        HashMap addPattern = null;
        if (def != null) {
            addPattern = def.getAddPatterns();
        }
        int i = 0;
        while (tok.hasMoreTokens()) {
            Object o;
            this.fields[i] = tok.nextToken();
            if (addPattern != null && (o = addPattern.get(this.fields[i])) != null) {
                if (o instanceof HashMap) {
                    addPattern = (HashMap)o;
                } else {
                    AddPattern pat = (AddPattern)o;
                    this.dn = pat.getAddPattern() + COMMA + def.getBase();
                    this.dontAdd = pat.getNotToAdd();
                    this.defOC = pat.getDefaultOC();
                }
            }
            ++i;
        }
        if (def != null) {
            ltoks = this.explodeDN(this.dn);
            this.parseCtx(ltoks);
        }
        begin = end + 1;
        begin = tmpSQL.indexOf(40, begin) + 1;
        end = tmpSQL.indexOf(41, begin);
        tmp = SQL.substring(begin, end);
        ltoks = this.explodeDN(tmp);
        this.vals = new String[ltoks.size()];
        this.offset = new int[ltoks.size()];
        Iterator it = ltoks.iterator();
        i = 0;
        int j = 0;
        while (it.hasNext()) {
            this.vals[i] = (String)it.next();
            if (this.vals[i].charAt(0) == '\"' || this.vals[i].charAt(0) == '\'') {
                this.vals[i] = this.vals[i].substring(1, this.vals[i].length() - 1);
            }
            if (this.vals[i].equals(QMARK)) {
                this.offset[j++] = i;
            } else if (this.vals[i].charAt(0) == '\"' || this.vals[i].charAt(0) == '\'') {
                this.vals[i] = this.vals[i].substring(1, this.vals[i].length() - 2);
            }
            this.fieldsMap.add(new Pair(this.fields[i], this.vals[i]));
            ++i;
        }
        this.store = new SqlStore(SQL);
        this.store.setFields(this.fields);
        this.store.setDistinguishedName(this.dn);
        this.store.setArgs(this.vals.length);
        this.store.setInsertFields(this.vals);
        this.store.setFieldOffset(this.offset);
        this.store.setDnFields(this.dnFields);
        this.store.setFieldsMap(this.fieldsMap);
        this.store.setDontAdd(this.dontAdd);
        this.store.setDefaultOC(this.defOC);
    }

    private void parseCtx(LinkedList ltoks) {
        this.dnFields = new String[ltoks.size()];
        Iterator it = ltoks.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.dnFields[i] = (String)it.next();
            ++i;
        }
    }

    public void init(JndiLdapConnection con, String SQL, SqlStore sqlStore) throws SQLException {
        this.insert = (DirectoryInsert)con.getImplClasses().get("INSERT");
        this.con = con;
        this.sql = SQL;
        this.store = sqlStore;
        this.fields = sqlStore.getFields();
        this.dn = this.store.getDistinguishedName();
        this.vals = new String[sqlStore.getArgs()];
        System.arraycopy(sqlStore.getInsertFields(), 0, this.vals, 0, this.vals.length);
        this.offset = sqlStore.getFieldOffset();
        this.dnFields = sqlStore.getDnFields();
        this.fieldsMap = new LinkedList();
        this.fieldsMap.addAll(this.store.getFieldsMap());
        this.dontAdd = this.store.getDontAdd();
        this.defOC = this.store.getDefOC();
    }

    public Object executeQuery() throws SQLException {
        return null;
    }

    public Object executeUpdate() throws SQLException {
        this.insert.doInsertJldap(this);
        return new Integer(1);
    }

    public void setValue(int pos, String value) throws SQLException {
        ((Pair)this.fieldsMap.get(this.offset[pos])).setValue(value);
    }

    public SqlStore getSqlStore() {
        return this.store;
    }

    public boolean getRetrieveDN() {
        return false;
    }

    public DirContext getContext() {
        return this.con.getContext();
    }

    public String[] getVals() {
        return this.vals;
    }

    public boolean isUpdate() {
        return true;
    }

    public String getDistinguishedName() {
        StringBuffer fdn = new StringBuffer();
        HashMap<String, Integer> track = new HashMap<String, Integer>();
        Object[] fields = this.fieldsMap.toArray();
        for (int i = 0; i < this.dnFields.length; ++i) {
            if (this.dnFields[i].indexOf(61) != -1) {
                fdn.append(this.dnFields[i]).append(COMMA);
                continue;
            }
            String val = "";
            int start = track.containsKey(this.dnFields[i]) ? (Integer)track.get(this.dnFields[i]) + 1 : 0;
            int m = fields.length;
            for (int j = start; j < m; ++j) {
                if (!((Pair)fields[j]).getName().equalsIgnoreCase(this.dnFields[i])) continue;
                track.put(this.dnFields[i], new Integer(j));
                val = ((Pair)fields[j]).getValue();
                break;
            }
            String tmpv = LDAPDN.escapeRDN((String)(this.dnFields[i] + EQUALS + val));
            fdn.append(tmpv).append(COMMA);
        }
        String finalDN = fdn.toString();
        return finalDN.toString().substring(0, finalDN.length() - 1);
    }
}

