/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.sql;

import com.octetstring.jdbcLdap.sql.Node;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class SqlToLdap {
    public static final String SQL_AND = "AND";
    public static final String SQL_OR = "OR";
    public static final String SQL_NOT = "NOT";
    public static final String SQL_NULL = "NULL";
    public static final String SQL_IS = "IS";
    public static final char LEFT_PAR = '(';
    public static final char RIGHT_PAR = ')';
    static final String SL_PAR = "(";
    static final String SR_PAR = ")";
    HashMap order = new HashMap();

    public SqlToLdap() {
        this.order.put(SQL_NOT, new Integer(5));
        this.order.put(SQL_AND, new Integer(4));
        this.order.put(SQL_OR, new Integer(3));
        this.order.put(SR_PAR, new Integer(1));
    }

    boolean lastNodeGreater(Stack opps, String curr) {
        if (opps.isEmpty()) {
            return false;
        }
        Node node = (Node)opps.peek();
        return node.type > (Integer)this.order.get(curr);
    }

    boolean isCmd(String curr) {
        return curr.equalsIgnoreCase(SR_PAR) || curr.equalsIgnoreCase(SQL_AND) || curr.equalsIgnoreCase(SQL_OR) || curr.equalsIgnoreCase(SQL_NOT);
    }

    void procStack(Stack opps, Stack elements, int curr) {
        Node opp;
        if (opps.isEmpty()) {
            return;
        }
        do {
            opp = (Node)opps.pop();
            Node r = (Node)elements.pop();
            Node l = opp.type != 5 && opp.type != 0 ? (Node)elements.pop() : null;
            opp.l = l;
            opp.r = r;
            if (opp.type == 0) {
                elements.push(opp.r);
                continue;
            }
            elements.push(opp);
        } while (opp.type > curr && !opps.isEmpty());
    }

    public String convertToLdap(String expr, HashMap fieldMap) throws SQLException {
        Node tree;
        LinkedList list = this.inOrder(expr, fieldMap);
        Stack<Node> elements = new Stack<Node>();
        Stack<Node> opps = new Stack<Node>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String curr = (String)it.next();
            while (curr.trim().length() == 0 && it.hasNext()) {
                curr = (String)it.next();
            }
            String currUCase = curr.toUpperCase();
            if (curr.equalsIgnoreCase(SL_PAR)) {
                tree = new Node();
                tree.type = 0;
                tree.l = null;
                tree.r = null;
                opps.push(tree);
                continue;
            }
            if (this.isCmd(currUCase)) {
                if (curr.equalsIgnoreCase(SR_PAR)) {
                    this.procStack(opps, elements, (Integer)this.order.get(SR_PAR));
                    continue;
                }
                if (this.lastNodeGreater(opps, currUCase)) {
                    this.procStack(opps, elements, (Integer)this.order.get(currUCase));
                    tree = new Node();
                    tree.l = null;
                    tree.r = null;
                    tree.type = (Integer)this.order.get(currUCase);
                    opps.push(tree);
                    continue;
                }
                tree = new Node();
                tree.l = null;
                tree.r = null;
                tree.type = (Integer)this.order.get(currUCase);
                opps.push(tree);
                continue;
            }
            if (currUCase.equals(SQL_IS)) {
                String next = (String)it.next();
                if (next.equalsIgnoreCase(SQL_NULL)) {
                    String fieldName;
                    String newField;
                    tree = (Node)elements.peek();
                    if (fieldMap != null && (newField = (String)fieldMap.get(fieldName = tree.val)) != null) {
                        tree.val = newField;
                    }
                    tree.val = "!(" + tree.val + "=*)";
                    continue;
                }
                if (next.equalsIgnoreCase(SQL_NOT)) {
                    String fieldName;
                    String newField;
                    String next2 = (String)it.next();
                    if (!next2.equalsIgnoreCase(SQL_NULL)) {
                        throw new SQLException("Unexpected token near IS");
                    }
                    tree = (Node)elements.peek();
                    if (fieldMap != null && (newField = (String)fieldMap.get(fieldName = tree.val)) != null) {
                        tree.val = newField;
                    }
                    tree.val = tree.val + "=*";
                    continue;
                }
                throw new SQLException("Unexpected token near IS");
            }
            tree = new Node();
            tree.l = null;
            tree.r = null;
            tree.val = curr;
            tree.type = 6;
            elements.push(tree);
        }
        this.procStack(opps, elements, -1);
        tree = (Node)elements.pop();
        StringBuffer finalExpr = new StringBuffer();
        tree.traverse(finalExpr);
        return finalExpr.toString();
    }

    public LinkedList inOrder(String expr, HashMap fieldMap) {
        LinkedList<String> list = new LinkedList<String>();
        StringBuffer buf = new StringBuffer();
        char[] tmp = new char[1];
        for (int i = 0; i < expr.length(); ++i) {
            char curr = expr.charAt(i);
            if (curr == '(' || curr == ')') {
                if (buf.length() != 0 && !this.addToList(list, buf, fieldMap)) {
                    list.add(this.transformToFilter(new StringBuffer(buf.toString().trim()), fieldMap));
                    buf.setLength(0);
                }
                tmp[0] = curr;
                list.add(new String(tmp));
                continue;
            }
            if (curr == ' ') {
                if (this.addToList(list, buf, fieldMap)) continue;
                buf.append(curr);
                continue;
            }
            buf.append(curr);
        }
        if (buf.length() != 0) {
            String stmp = this.transformToFilter(buf, fieldMap);
            list.add(stmp);
        }
        return list;
    }

    private String transformToFilter(StringBuffer buf, HashMap fieldMap) {
        int wc;
        int equals;
        String stmp = buf.toString().trim();
        int like = stmp.toLowerCase().indexOf(" like ");
        if (like != -1) {
            buf.setLength(0);
            buf.append(stmp);
            System.out.println("Buff : " + like + ";" + buf.length());
            buf.delete(like, like + 6);
            buf.insert(like, '=');
            stmp = buf.toString();
        }
        if (stmp.charAt(0) == '\'') {
            stmp = stmp.substring(1);
        }
        if ((equals = stmp.indexOf(61)) != -1) {
            int quote = stmp.indexOf(39, equals);
            if (quote != -1 && stmp.charAt(quote - 1) != '\\') {
                buf.setLength(0);
                buf.append(stmp);
                buf.delete(equals + 1, quote + 1);
                stmp = buf.toString();
            }
            if (fieldMap != null) {
                equals = stmp.indexOf(61);
                String fieldName = stmp.substring(0, equals).trim();
                System.out.println("filedName " + fieldName);
                String newField = (String)fieldMap.get(fieldName);
                System.out.println("newfield " + newField);
                if (newField != null) {
                    buf.setLength(0);
                    buf.append(newField).append(stmp.substring(equals));
                    stmp = buf.toString();
                    System.out.println(stmp);
                }
            }
        }
        if ((wc = stmp.indexOf(37)) != -1) {
            buf.setLength(0);
            buf.append(stmp);
            if (buf.charAt(wc - 1) != '\\') {
                buf.setCharAt(wc, '*');
            } else {
                buf.deleteCharAt(wc - 1);
                --wc;
            }
            wc = buf.indexOf("%", wc + 1);
            while (wc != -1) {
                if (buf.charAt(wc - 1) != '\\') {
                    buf.setCharAt(wc, '*');
                } else {
                    buf.deleteCharAt(wc - 1);
                    --wc;
                }
                wc = buf.indexOf("%", wc + 1);
            }
            stmp = buf.toString();
        }
        if (stmp.charAt(stmp.length() - 1) == '\'' && stmp.charAt(stmp.length() - 2) != '\\') {
            stmp = stmp.substring(0, stmp.length() - 1);
        }
        return stmp;
    }

    boolean addToList(LinkedList list, StringBuffer buf, HashMap fieldMap) {
        int space = buf.toString().lastIndexOf(32);
        boolean added = false;
        if (buf.toString().trim().equalsIgnoreCase(SQL_NOT)) {
            list.add(this.transformToFilter(buf, fieldMap));
            buf.setLength(0);
        } else if (buf.substring(space + 1).equalsIgnoreCase(SQL_AND) || buf.substring(space + 1).equalsIgnoreCase(SQL_OR) || buf.substring(space + 1).equalsIgnoreCase(SQL_NOT) || buf.substring(space + 1).equalsIgnoreCase(SQL_IS) || buf.substring(space + 1).equalsIgnoreCase(SQL_IS)) {
            String add = buf.substring(0, space).trim();
            if (add.length() != 0) {
                String tmp = buf.substring(0, space).trim();
                list.add(this.transformToFilter(new StringBuffer(tmp), fieldMap));
            }
            list.add(buf.substring(space + 1).trim());
            buf.setLength(0);
            added = true;
        }
        return added;
    }
}

