/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.sql;

import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.jndi.SQLNamingException;
import com.octetstring.jdbcLdap.jndi.UnpackResults;
import com.octetstring.jdbcLdap.sql.JdbcLdapMetaData;
import com.octetstring.jdbcLdap.sql.JdbcLdapStatement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class LdapResultSet
implements ResultSet {
    ArrayList fields;
    JndiLdapConnection con;
    HashMap row;
    int pos;
    String baseDN;
    JdbcLdapStatement statement;
    int[] types;
    boolean wasNull;
    UnpackResults unpack;

    boolean moveToPos() throws SQLNamingException {
        if (this.pos >= 0 && this.unpack.moveNext(this.pos)) {
            this.row = (HashMap)this.unpack.getRows().get(this.pos);
            return this.row != null;
        }
        this.row = null;
        return false;
    }

    public LdapResultSet(JndiLdapConnection con, JdbcLdapStatement statement, UnpackResults unpack, String baseDN) {
        this.unpack = unpack;
        this.con = con;
        this.baseDN = baseDN;
        this.statement = statement;
        this.pos = -1;
    }

    String getByName(String name) throws SQLException {
        if (this.row == null) {
            throw new SQLException("Invalid row position");
        }
        String val = (String)this.row.get(name);
        if (val == null) {
            this.wasNull = true;
            return "";
        }
        this.wasNull = false;
        return val;
    }

    String getByNum(int id) throws SQLException {
        if (this.row == null) {
            throw new SQLException("Invalid row position");
        }
        String field = (String)this.unpack.getFieldNames().get(id - 1);
        if (field == null) {
            throw new SQLException("Field " + Integer.toString(id) + " Does not Exist");
        }
        String val = (String)this.row.get(field);
        if (val == null) {
            this.wasNull = true;
            return "";
        }
        this.wasNull = false;
        return val;
    }

    public boolean absolute(int param) throws SQLException {
        this.pos = param;
        return this.moveToPos();
    }

    public void afterLast() throws SQLException {
        this.pos = this.unpack.getRows().size();
        this.moveToPos();
    }

    public void beforeFirst() throws SQLException {
        this.pos = -1;
        this.moveToPos();
    }

    public void cancelRowUpdates() throws SQLException {
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int findColumn(String str) throws SQLException {
        return this.unpack.getFieldNames().indexOf(str);
    }

    public boolean first() throws SQLException {
        this.pos = 0;
        return this.moveToPos();
    }

    public Array getArray(int param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Array getArray(String str) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public InputStream getAsciiStream(int param) throws SQLException {
        return new StringBufferInputStream(this.getByNum(param));
    }

    public InputStream getAsciiStream(String str) throws SQLException {
        return new StringBufferInputStream(this.getByName(str));
    }

    public BigDecimal getBigDecimal(int param) throws SQLException {
        return new BigDecimal(this.getByNum(param));
    }

    public BigDecimal getBigDecimal(String str) throws SQLException {
        return new BigDecimal(this.getByName(str));
    }

    public BigDecimal getBigDecimal(int param, int param1) throws SQLException {
        return new BigDecimal(this.getByNum(param));
    }

    public BigDecimal getBigDecimal(String str, int param) throws SQLException {
        return new BigDecimal(this.getByName(str));
    }

    public InputStream getBinaryStream(int param) throws SQLException {
        return new ByteArrayInputStream(this.getByNum(param).getBytes());
    }

    public InputStream getBinaryStream(String str) throws SQLException {
        return new ByteArrayInputStream(this.getByName(str).getBytes());
    }

    public Blob getBlob(int param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Blob getBlob(String str) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean getBoolean(int param) throws SQLException {
        return Boolean.getBoolean(this.getByNum(param));
    }

    public boolean getBoolean(String str) throws SQLException {
        return Boolean.getBoolean(this.getByName(str));
    }

    public byte getByte(int param) throws SQLException {
        return Byte.parseByte(this.getByNum(param));
    }

    public byte getByte(String str) throws SQLException {
        return Byte.parseByte(this.getByName(str));
    }

    public byte[] getBytes(int param) throws SQLException {
        return this.getByNum(param).getBytes();
    }

    public byte[] getBytes(String str) throws SQLException {
        return this.getByName(str).getBytes();
    }

    public Reader getCharacterStream(int param) throws SQLException {
        return new StringReader(this.getByNum(param));
    }

    public Reader getCharacterStream(String str) throws SQLException {
        return new StringReader(this.getByName(str));
    }

    public Clob getClob(int param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Clob getClob(String str) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getConcurrency() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public Date getDate(int param) throws SQLException {
        return Date.valueOf(this.getByNum(param));
    }

    public Date getDate(String str) throws SQLException {
        return Date.valueOf(this.getByName(str));
    }

    public Date getDate(int param, Calendar calendar) throws SQLException {
        return this.getDate(param);
    }

    public Date getDate(String str, Calendar calendar) throws SQLException {
        return this.getDate(str);
    }

    public double getDouble(int param) throws SQLException {
        return Double.parseDouble(this.getByNum(param));
    }

    public double getDouble(String str) throws SQLException {
        return Double.parseDouble(this.getByName(str));
    }

    public int getFetchDirection() throws SQLException {
        return 1;
    }

    public int getFetchSize() throws SQLException {
        return 1;
    }

    public float getFloat(int param) throws SQLException {
        return Float.parseFloat(this.getByNum(param));
    }

    public float getFloat(String str) throws SQLException {
        return Float.parseFloat(this.getByName(str));
    }

    public int getInt(int param) throws SQLException {
        return Integer.parseInt(this.getByNum(param));
    }

    public int getInt(String str) throws SQLException {
        return Integer.parseInt(this.getByName(str));
    }

    public long getLong(int param) throws SQLException {
        return Long.parseLong(this.getByNum(param));
    }

    public long getLong(String str) throws SQLException {
        return Long.parseLong(this.getByName(str));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new JdbcLdapMetaData(this.unpack, this.baseDN);
    }

    public Object getObject(int param) throws SQLException {
        return this.getByNum(param);
    }

    public Object getObject(String str) throws SQLException {
        return this.getByName(str);
    }

    public Object getObject(int param, Map map) throws SQLException {
        return this.getByNum(param);
    }

    public Object getObject(String str, Map map) throws SQLException {
        return this.getByName(str);
    }

    public Ref getRef(int param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Ref getRef(String str) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getRow() throws SQLException {
        return this.pos;
    }

    public short getShort(int param) throws SQLException {
        return Short.parseShort(this.getByNum(param));
    }

    public short getShort(String str) throws SQLException {
        return Short.parseShort(this.getByName(str));
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public String getString(int param) throws SQLException {
        return this.getByNum(param);
    }

    public String getString(String str) throws SQLException {
        return this.getByName(str);
    }

    public Time getTime(int param) throws SQLException {
        return Time.valueOf(this.getByNum(param));
    }

    public Time getTime(String str) throws SQLException {
        return Time.valueOf(this.getByName(str));
    }

    public Time getTime(int param, Calendar calendar) throws SQLException {
        return this.getTime(param);
    }

    public Time getTime(String str, Calendar calendar) throws SQLException {
        return this.getTime(str);
    }

    public Timestamp getTimestamp(int param) throws SQLException {
        return Timestamp.valueOf(this.getByNum(param));
    }

    public Timestamp getTimestamp(String str) throws SQLException {
        return Timestamp.valueOf(this.getByName(str));
    }

    public Timestamp getTimestamp(int param, Calendar calendar) throws SQLException {
        return this.getTimestamp(param);
    }

    public Timestamp getTimestamp(String str, Calendar calendar) throws SQLException {
        return this.getTimestamp(str);
    }

    public int getType() throws SQLException {
        return 0;
    }

    public URL getURL(int param) throws SQLException {
        try {
            return new URL(this.getByNum(param));
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    public URL getURL(String str) throws SQLException {
        try {
            return new URL(this.getByName(str));
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    public InputStream getUnicodeStream(int param) throws SQLException {
        return new StringBufferInputStream(this.getByNum(param));
    }

    public InputStream getUnicodeStream(String str) throws SQLException {
        return new StringBufferInputStream(this.getByName(str));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void insertRow() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean isAfterLast() throws SQLException {
        return this.pos > this.unpack.getRows().size() - 1;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.pos == -1;
    }

    public boolean isFirst() throws SQLException {
        return this.pos == 0;
    }

    public boolean isLast() throws SQLException {
        return this.pos == this.unpack.getRows().size() - 1;
    }

    public boolean last() throws SQLException {
        this.pos = this.unpack.getRows().size() - 1;
        return true;
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public boolean next() throws SQLException {
        ++this.pos;
        return this.moveToPos();
    }

    public boolean previous() throws SQLException {
        --this.pos;
        return this.moveToPos();
    }

    public void refreshRow() throws SQLException {
    }

    public boolean relative(int param) throws SQLException {
        this.pos += param;
        return this.moveToPos();
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setFetchDirection(int param) throws SQLException {
    }

    public void setFetchSize(int param) throws SQLException {
    }

    public void updateArray(int param, Array array) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateArray(String str, Array array) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateAsciiStream(int param, InputStream inputStream, int param2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateAsciiStream(String str, InputStream inputStream, int param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBigDecimal(int param, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBigDecimal(String str, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBinaryStream(int param, InputStream inputStream, int param2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBinaryStream(String str, InputStream inputStream, int param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBlob(int param, Blob blob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBlob(String str, Blob blob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBoolean(int param, boolean param1) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBoolean(String str, boolean param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateByte(int param, byte param1) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateByte(String str, byte param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBytes(int param, byte[] values) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateBytes(String str, byte[] values) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateCharacterStream(int param, Reader reader, int param2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateCharacterStream(String str, Reader reader, int param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateClob(int param, Clob clob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateClob(String str, Clob clob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateDate(int param, Date date) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateDate(String str, Date date) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateDouble(int param, double param1) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateDouble(String str, double param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateFloat(int param, float param1) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateFloat(String str, float param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateInt(int param, int param1) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateInt(String str, int param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateLong(int param, long param1) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateLong(String str, long param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateNull(int param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateNull(String str) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateObject(int param, Object obj) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateObject(String str, Object obj) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateObject(int param, Object obj, int param2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateObject(String str, Object obj, int param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateRef(int param, Ref ref) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateRef(String str, Ref ref) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateShort(int param, short param1) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateShort(String str, short param) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateString(int param, String str) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateString(String str, String str1) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateTime(int param, Time time) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateTime(String str, Time time) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateTimestamp(int param, Timestamp timestamp) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void updateTimestamp(String str, Timestamp timestamp) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }
}

