/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.sql;

import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPSearchResults;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.jndi.UnpackResults;
import com.octetstring.jdbcLdap.sql.LdapResultSet;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapDelete;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapInsert;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSelect;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSql;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapUpdate;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapUpdateEntry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;

public class JdbcLdapStatement
implements Statement {
    static final String SELECT = "select";
    static final int SELECT_LEN = 6;
    static final String INSERT = "insert";
    static final int INSERT_LEN = 6;
    static final String DELETE = "delete";
    static final int DELETE_LEN = 6;
    static final String UPDATE = "update";
    static final int UPDATE_LEN = 6;
    static final String UPDATE_ENTRY = "update entry";
    static final int UPDATE_ENTRY_LEN = 12;
    LinkedList statements;
    UnpackResults res;
    LdapResultSet rs;
    JdbcLdapSql stmt;
    JndiLdapConnection con;
    int maxResults;
    int timeOut;
    Object[] results;

    void loadSQL(String sql) throws SQLException {
        String sqll = sql.toLowerCase().trim();
        SqlStore sqlStore = this.con.getCache(sql);
        if (sqll.substring(0, 6).equals(SELECT)) {
            this.stmt = new JdbcLdapSelect();
        } else if (sqll.substring(0, 6).equals(INSERT)) {
            this.stmt = new JdbcLdapInsert();
        } else if (sqll.substring(0, 12).equals(UPDATE_ENTRY)) {
            this.stmt = new JdbcLdapUpdateEntry();
        } else if (sqll.substring(0, 6).equals(DELETE)) {
            this.stmt = new JdbcLdapDelete();
        } else if (sqll.substring(0, 6).equals(UPDATE)) {
            this.stmt = new JdbcLdapUpdate();
        } else {
            throw new SQLException("Opperation not suported");
        }
        if (sqlStore == null) {
            this.stmt.init(this.con, sql);
            if (this.con.cacheStatements()) {
                this.con.cacheStatement(sql, this.stmt.getSqlStore());
            }
        } else {
            this.stmt.init(this.con, sql, sqlStore);
        }
    }

    public JdbcLdapStatement(JndiLdapConnection con) {
        this.con = con;
        this.maxResults = -1;
        this.timeOut = -1;
        this.res = new UnpackResults(con);
        this.statements = new LinkedList();
    }

    public void addBatch(String str) throws SQLException {
        this.loadSQL(str);
        if (!this.stmt.isUpdate()) {
            throw new SQLException(str + " is not an update");
        }
        this.statements.add(this.stmt);
    }

    public void cancel() throws SQLException {
        throw new SQLException("not implemented");
    }

    public void clearBatch() throws SQLException {
        this.statements.clear();
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
    }

    public boolean execute(String str) throws SQLException {
        this.executeQuery(str);
        return true;
    }

    public boolean execute(String str, int param) throws SQLException {
        this.executeQuery(str);
        return true;
    }

    public boolean execute(String str, int[] values) throws SQLException {
        this.executeQuery(str);
        return true;
    }

    public boolean execute(String str, String[] str1) throws SQLException {
        this.executeQuery(str);
        return true;
    }

    public int[] executeBatch() throws SQLException {
        int[] batch = new int[this.statements.size()];
        Iterator it = this.statements.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.stmt = (JdbcLdapSql)it.next();
            batch[i] = (Integer)this.stmt.executeUpdate();
            ++i;
        }
        return batch;
    }

    public ResultSet executeQuery(String str) throws SQLException {
        this.loadSQL(str);
        if (this.con.isDSML() || this.con.isSPML() || this.con.isNoCon()) {
            this.res.unpackJldap((LDAPSearchResults)this.stmt.executeQuery(), this.stmt.getRetrieveDN(), this.stmt.getSqlStore().getFrom(), this.con.getBaseDN(), this.stmt.getSqlStore().getRevFieldMap());
        } else {
            this.res.unpackJldap((LDAPMessageQueue)this.stmt.executeQuery(), this.stmt.getRetrieveDN(), this.stmt.getSqlStore().getFrom(), this.con.getBaseDN(), this.stmt.getSqlStore().getRevFieldMap());
        }
        this.rs = new LdapResultSet(this.con, this, this.res, ((JdbcLdapSelect)this.stmt).getBaseContext());
        return this.rs;
    }

    public int executeUpdate(String str) throws SQLException {
        this.loadSQL(str);
        return (Integer)this.stmt.executeUpdate();
    }

    public int executeUpdate(String str, int param) throws SQLException {
        return this.executeUpdate(str);
    }

    public int executeUpdate(String str, int[] values) throws SQLException {
        return this.executeUpdate(str);
    }

    public int executeUpdate(String str, String[] str1) throws SQLException {
        return this.executeUpdate(str);
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public int getFetchDirection() throws SQLException {
        return -1;
    }

    public int getFetchSize() throws SQLException {
        return -1;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int getMaxFieldSize() throws SQLException {
        return -1;
    }

    public int getMaxRows() throws SQLException {
        return this.maxResults;
    }

    public boolean getMoreResults() throws SQLException {
        return true;
    }

    public boolean getMoreResults(int param) throws SQLException {
        return true;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeOut;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.rs;
    }

    public int getResultSetConcurrency() throws SQLException {
        return -1;
    }

    public int getResultSetHoldability() throws SQLException {
        return -1;
    }

    public int getResultSetType() throws SQLException {
        return -1;
    }

    public int getUpdateCount() throws SQLException {
        return -1;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void setCursorName(String str) throws SQLException {
    }

    public void setEscapeProcessing(boolean param) throws SQLException {
    }

    public void setFetchDirection(int param) throws SQLException {
    }

    public void setFetchSize(int param) throws SQLException {
        this.maxResults = param;
    }

    public void setMaxFieldSize(int param) throws SQLException {
    }

    public void setMaxRows(int param) throws SQLException {
        this.maxResults = param;
    }

    public void setQueryTimeout(int param) throws SQLException {
        this.timeOut = param;
    }
}

