/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.sql;

import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPSearchResults;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.JdbcLdapStatement;
import com.octetstring.jdbcLdap.sql.LdapResultSet;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSelect;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class JdbcLdapPreparedStatement
extends JdbcLdapStatement
implements PreparedStatement {
    public JdbcLdapPreparedStatement(String sql, JndiLdapConnection con) throws SQLException {
        super(con);
        this.loadSQL(sql);
    }

    void loadSQL(SqlStore store) throws SQLException {
        this.loadSQL(store.getSQL());
    }

    void setVal(int pos, String val) throws SQLException {
        this.stmt.setValue(pos - 1, val);
    }

    public void setUnicodeStream(int param, InputStream inputStream, int param2) throws SQLException {
        char[] c = new char[param2];
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            in.read(c, 0, param2);
            in.close();
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        this.setVal(param, String.valueOf(c));
    }

    public void setTime(int param, Time time) throws SQLException {
        this.setVal(param, time.toString());
    }

    public void setBigDecimal(int param, BigDecimal bigDecimal) throws SQLException {
        this.setVal(param, bigDecimal.toString());
    }

    public boolean execute() throws SQLException {
        if (this.stmt.isUpdate()) {
            this.executeUpdate();
            return false;
        }
        this.executeQuery();
        return true;
    }

    public void setURL(int param, URL uRL) throws SQLException {
        this.setVal(param, uRL.toString());
    }

    public void setAsciiStream(int param, InputStream inputStream, int param2) throws SQLException {
        char[] c = new char[param2];
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            in.read(c, 0, param2);
            in.close();
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        this.setVal(param, String.valueOf(c));
    }

    public void setByte(int param, byte param1) throws SQLException {
        this.setVal(param, Byte.toString(param1));
    }

    public void setDouble(int param, double param1) throws SQLException {
        this.setVal(param, Double.toString(param1));
    }

    public void setLong(int param, long param1) throws SQLException {
        this.setVal(param, Long.toString(param1));
    }

    public void setDate(int param, Date date) throws SQLException {
        this.setVal(param, date.toString());
    }

    public void setBinaryStream(int param, InputStream inputStream, int param2) throws SQLException {
        char[] c = new char[param2];
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            in.read(c, 0, param2);
            in.close();
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        this.setVal(param, String.valueOf(c));
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    public void setTime(int param, Time time, Calendar calendar) throws SQLException {
        this.setVal(param, time.toString());
    }

    public void setBlob(int param, Blob blob) throws SQLException {
    }

    public ResultSet executeQuery() throws SQLException {
        System.out.println("Is No Con : " + this.con.isNoCon());
        if (this.con.isDSML() || this.con.isSPML() || this.con.isNoCon()) {
            this.res.unpackJldap((LDAPSearchResults)this.stmt.executeQuery(), this.stmt.getRetrieveDN(), this.stmt.getSqlStore().getFrom(), this.con.getBaseDN(), this.stmt.getSqlStore().getRevFieldMap());
        } else {
            this.res.unpackJldap((LDAPMessageQueue)this.stmt.executeQuery(), this.stmt.getRetrieveDN(), this.stmt.getSqlStore().getFrom(), this.con.getBaseDN(), this.stmt.getSqlStore().getRevFieldMap());
        }
        this.rs = new LdapResultSet(this.con, this, this.res, ((JdbcLdapSelect)this.stmt).getBaseContext());
        return this.rs;
    }

    public void setCharacterStream(int param, Reader reader, int param2) throws SQLException {
        char[] c = new char[param2];
        try {
            BufferedReader in = new BufferedReader(reader);
            in.read(c, 0, param2);
            in.close();
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        this.setVal(param, String.valueOf(c));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs.getMetaData();
    }

    public void setTimestamp(int param, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setVal(param, timestamp.toString());
    }

    public void setObject(int param, Object obj, int param2, int param3) throws SQLException {
        this.setVal(param, obj.toString());
    }

    public void setObject(int param, Object obj, int param2) throws SQLException {
        this.setVal(param, obj.toString());
    }

    public void setObject(int param, Object obj) throws SQLException {
        this.setVal(param, obj.toString());
    }

    public void setRef(int param, Ref ref) throws SQLException {
    }

    public void setArray(int param, Array array) throws SQLException {
    }

    public void setTimestamp(int param, Timestamp timestamp) throws SQLException {
        this.setVal(param, timestamp.toString());
    }

    public void setInt(int param, int param1) throws SQLException {
        this.setVal(param, Integer.toString(param1));
    }

    public void setBytes(int param, byte[] values) throws SQLException {
        this.setCharacterStream(param, (Reader)new InputStreamReader(new ByteArrayInputStream(values)), values.length);
    }

    public void setShort(int param, short param1) throws SQLException {
        this.setVal(param, Short.toString(param1));
    }

    public void setFloat(int param, float param1) throws SQLException {
        this.setVal(param, Float.toString(param1));
    }

    public void setBoolean(int param, boolean param1) throws SQLException {
        this.setVal(param, Boolean.toString(param1));
    }

    public void setDate(int param, Date date, Calendar calendar) throws SQLException {
        this.setVal(param, date.toString());
    }

    public int executeUpdate() throws SQLException {
        return (Integer)this.stmt.executeUpdate();
    }

    public void setString(int param, String str) throws SQLException {
        this.setVal(param, str);
    }

    public void setClob(int param, Clob clob) throws SQLException {
    }

    public void addBatch() throws SQLException {
        this.statements.add(this.stmt);
        this.loadSQL(this.stmt.getSqlStore());
    }

    public void clearParameters() throws SQLException {
    }

    public void setNull(int param, int param1) throws SQLException {
        this.setVal(param, null);
    }

    public void setNull(int param, int param1, String str) throws SQLException {
        this.setVal(param, null);
    }
}

