/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.sql;

import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class JdbcLdapDriver
implements Driver {
    public static final String URL_ID = "jdbc:ldap";
    public static final String DSML_URL_ID = "jdbc:dsml";
    public static final String SPML_URL_ID = "jdbc:spml";
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 99;
    public static final boolean JDBC_IV = false;
    public static final String PARAM_DELIM = ":=";

    public JdbcLdapDriver() throws SQLException {
        DriverManager.registerDriver(this);
    }

    public boolean acceptsURL(String str) throws SQLException {
        return str.substring(0, 9).equalsIgnoreCase(URL_ID) || str.substring(0, 9).equalsIgnoreCase(DSML_URL_ID) || str.substring(0, 9).equalsIgnoreCase(SPML_URL_ID);
    }

    public Connection connect(String str, Properties properties) throws SQLException {
        if (!this.acceptsURL(str)) {
            return null;
        }
        int seperator = str.indexOf("?");
        if (seperator != -1) {
            String props = str.substring(seperator + 1);
            StringTokenizer toker = new StringTokenizer(props, "&", false);
            while (toker.hasMoreTokens()) {
                String token = toker.nextToken();
                String prop = token.substring(0, token.indexOf(PARAM_DELIM));
                String val = token.substring(token.indexOf(PARAM_DELIM) + PARAM_DELIM.length());
                properties.setProperty(prop, val);
            }
            return new JndiLdapConnection(str.substring(0, seperator), properties);
        }
        return new JndiLdapConnection(str, properties);
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 99;
    }

    public DriverPropertyInfo[] getPropertyInfo(String str, Properties properties) throws SQLException {
        DriverPropertyInfo[] props = new DriverPropertyInfo[]{new DriverPropertyInfo("user", "Security Principal"), new DriverPropertyInfo("password", "Security Credentials"), new DriverPropertyInfo("java.naming.security.authentication", "Authentication type - simple, none or SASL type"), new DriverPropertyInfo("SEARCH_SCOPE", "The Search scope"), new DriverPropertyInfo("CACHE_STATEMENT", "true or false, wether or not statements should be cached")};
        return props;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new JdbcLdapDriver());
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
        }
    }
}

