/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.novell.ldap.LDAPException;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.util.LDIF;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.TestCase;

public class TestUpdateEntry
extends TestCase {
    JndiLdapConnection con;
    boolean doInsert;
    boolean doDelete;
    boolean doDeleteMulti;

    public TestUpdateEntry(String name) {
        super(name);
    }

    public void tearDown() throws Exception {
        if (this.doDelete) {
            try {
                this.con.getConnection().delete("cn=\"Marc Boorshtein, OctetString\",ou=Product Development," + this.con.getBaseContext());
            }
            catch (LDAPException e) {
                // empty catch block
            }
            try {
                this.con.getConnection().delete("cn=Marc Boorshtein\\, OctetString,ou=Product Development," + this.con.getBaseContext());
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            this.con.getConnection().delete("cn=Marc Boorsh,ou=Product Development,dc=idrs,dc=com");
            this.con.getConnection().delete("cn=Steve Boorsh,ou=Product Development,dc=idrs,dc=com");
            this.con.getConnection().delete("cn=Sherry Boorsh,ou=Product Development,dc=idrs,dc=com");
        }
        this.con.close();
    }

    public void setUp() throws Exception {
        Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        this.con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?SEARCH_SCOPE:=subTreeScope", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate("INSERT INTO cn=\"Marc Boorshtein, OctetString\",ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorshtein,\"Marc Boorshtein, OctetString\",test-single)");
        stmt.executeUpdate("INSERT INTO cn=Marc Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Marc Boorsh,test1-multi)");
        stmt.executeUpdate("INSERT INTO cn=Steve Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Steve Boorsh,test2-multi)");
        stmt.executeUpdate("INSERT INTO cn=Sherry Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Sherry Boorsh,test3-multi)");
    }

    public void testUpdateEntry() throws Exception {
        this.doDelete = true;
        this.doDeleteMulti = true;
        this.doInsert = true;
        PreparedStatement ps = this.con.prepareStatement("UPDATE ENTRY cn=Marc Boorsh,ou=Product Development DO DELETE SET title DO ADD SET l=Schaumburg,title=Engineer");
        int result = ps.executeUpdate();
        if (result != 1) {
            TestUpdateEntry.fail((String)("Results Are Wrong : " + result));
        }
        ps = this.con.prepareStatement("SELECT DN,l,title FROM cn=Marc Boorsh,ou=Product Development");
        ResultSet rs = ps.executeQuery();
        rs.next();
        TestUpdateEntry.assertTrue((String)("l wrong " + rs.getString("l")), (boolean)"Schaumburg".equals(rs.getString("l")));
        TestUpdateEntry.assertTrue((String)("title wrong " + rs.getString("title")), (boolean)"Engineer".equals(rs.getString("title")));
    }

    public void testUpdateEntryMulti() throws Exception {
        LDIF dif;
        this.doDelete = true;
        this.doDeleteMulti = true;
        this.doInsert = true;
        PreparedStatement ps = this.con.prepareStatement("UPDATE ENTRY ou=Product Development DO DELETE SET title DO ADD SET l=Schaumburg,title=Engineer WHERE sn=Boorsh");
        int result = ps.executeUpdate();
        if (result != 3) {
            TestUpdateEntry.fail((String)("Results Are Wrong : " + result));
        }
        ps = this.con.prepareStatement("SELECT DN,l,title FROM ou=Product Development WHERE sn=Boorsh");
        ResultSet rs = ps.executeQuery();
        String ldif = "";
        ldif = ldif + "dn: cn=Marc Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        ldif = ldif + "title: Engineer\n\n";
        ldif = ldif + "dn: cn=Steve Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        ldif = ldif + "title: Engineer\n\n";
        ldif = ldif + "dn: cn=Sherry Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        LDIF found = new LDIF(rs, "DN", false);
        LDIF expLdif = new LDIF(ldif = ldif + "title: Engineer", true);
        if (!found.compareLdif(expLdif, dif = new LDIF())) {
            TestUpdateEntry.fail((String)("Results Don't Match : \nexpected:\n" + ldif + "\nfound:\n" + found.toString()));
        }
    }

    public void testUpdateEntryMultiParamVal() throws Exception {
        LDIF dif;
        this.doDelete = true;
        this.doDeleteMulti = true;
        this.doInsert = true;
        PreparedStatement ps = this.con.prepareStatement("UPDATE ENTRY ou=Product Development DO DELETE SET title DO ADD SET l=?,title=Engineer WHERE sn=Boorsh");
        ps.setString(1, "Schaumburg");
        int result = ps.executeUpdate();
        if (result != 3) {
            TestUpdateEntry.fail((String)("Results Are Wrong : " + result));
        }
        ps = this.con.prepareStatement("SELECT DN,l,title FROM ou=Product Development WHERE sn=Boorsh");
        ResultSet rs = ps.executeQuery();
        String ldif = "";
        ldif = ldif + "dn: cn=Marc Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        ldif = ldif + "title: Engineer\n\n";
        ldif = ldif + "dn: cn=Steve Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        ldif = ldif + "title: Engineer\n\n";
        ldif = ldif + "dn: cn=Sherry Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        LDIF found = new LDIF(rs, "DN", false);
        LDIF expLdif = new LDIF(ldif = ldif + "title: Engineer", true);
        if (!found.compareLdif(expLdif, dif = new LDIF())) {
            TestUpdateEntry.fail((String)("Results Don't Match : \nexpected:\n" + ldif + "\nfound:\n" + found.toString()));
        }
    }

    public void testUpdateEntryMultiParamArg() throws Exception {
        LDIF dif;
        this.doDelete = true;
        this.doDeleteMulti = true;
        this.doInsert = true;
        PreparedStatement ps = this.con.prepareStatement("UPDATE ENTRY ou=Product Development DO DELETE SET title DO ADD SET l=Schaumburg,title=Engineer WHERE sn=?");
        ps.setString(1, "Boorsh");
        int result = ps.executeUpdate();
        if (result != 3) {
            TestUpdateEntry.fail((String)("Results Are Wrong : " + result));
        }
        ps = this.con.prepareStatement("SELECT DN,l,title,description FROM ou=Product Development WHERE sn=Boorsh");
        ResultSet rs = ps.executeQuery();
        String ldif = "";
        ldif = ldif + "dn: cn=Marc Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        ldif = ldif + "title: Engineer\n\n";
        ldif = ldif + "dn: cn=Steve Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        ldif = ldif + "title: Engineer\n\n";
        ldif = ldif + "dn: cn=Sherry Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        LDIF found = new LDIF(rs, "DN", false);
        LDIF expLdif = new LDIF(ldif = ldif + "title: Engineer", true);
        if (!found.compareLdif(expLdif, dif = new LDIF())) {
            TestUpdateEntry.fail((String)("Results Don't Match : \nexpected:\n" + ldif + "\nfound:\n" + found.toString()));
        }
    }

    public void testUpdateEntryMultiParamCmplx() throws Exception {
        this.doDelete = true;
        this.doDeleteMulti = true;
        this.doInsert = true;
        PreparedStatement ps = this.con.prepareStatement("UPDATE ENTRY ou=Product Development DO DELETE SET title DO ADD SET l=?,title=Engineer DO ADD SET description=?  WHERE sn=?");
        ps.setString(1, "Schaumburg");
        ps.setString(2, "Boston");
        ps.setString(3, "Boorsh");
        int result = ps.executeUpdate();
        if (result != 3) {
            TestUpdateEntry.fail((String)("Results Are Wrong : " + result));
        }
        ps = this.con.prepareStatement("SELECT DN,l,description,title FROM ou=Product Development WHERE sn=Boorsh");
        ResultSet rs = ps.executeQuery();
        String ldif = "";
        ldif = ldif + "dn: cn=Marc Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        ldif = ldif + "description: Boston\n";
        ldif = ldif + "title: Engineer\n\n";
        ldif = ldif + "dn: cn=Steve Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        ldif = ldif + "description: Boston\n";
        ldif = ldif + "title: Engineer\n\n";
        ldif = ldif + "dn: cn=Sherry Boorsh,ou=Product Development,dc=idrs,dc=com\n";
        ldif = ldif + "l: Schaumburg\n";
        ldif = ldif + "description: Boston\n";
        ldif = ldif + "title: Engineer";
        LDIF expLdif = new LDIF(ldif, true);
        LDIF found = new LDIF(rs, "DN", false);
        LDIF dif = new LDIF();
        String fndLdif = found.toString();
        if (!found.compareLdif(expLdif, dif)) {
            TestUpdateEntry.fail((String)("Results Don't Match : \nexpected:\n" + ldif + "\nfound:\n" + fndLdif));
        }
    }
}

