/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.novell.ldap.LDAPException;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapUpdate;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.TestCase;

public class TestUpdate
extends TestCase {
    JndiLdapConnection con;
    boolean doInsert;
    boolean doDelete;
    boolean doDeleteMulti;

    public TestUpdate(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        if (this.doDelete) {
            try {
                this.con.getConnection().delete("cn=\"Marc Boorshtein, OctetString\",ou=Product Development," + this.con.getBaseContext());
            }
            catch (LDAPException e) {
                // empty catch block
            }
            try {
                this.con.getConnection().delete("cn=Marc Boorshtein\\, OctetString,ou=Product Development," + this.con.getBaseContext());
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            this.con.getConnection().delete("cn=Marc Boorsh,ou=Product Development,dc=idrs,dc=com");
            this.con.getConnection().delete("cn=Steve Boorsh,ou=Product Development,dc=idrs,dc=com");
            this.con.getConnection().delete("cn=Sherry Boorsh,ou=Product Development,dc=idrs,dc=com");
        }
        this.con.close();
    }

    protected void setUp() throws Exception {
        Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        this.con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?SEARCH_SCOPE:=subTreeScope", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate("INSERT INTO cn=\"Marc Boorshtein, OctetString\",ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorshtein,\"Marc Boorshtein, OctetString\",test-single)");
        stmt.executeUpdate("INSERT INTO cn=Marc Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Marc Boorsh,test1-multi)");
        stmt.executeUpdate("INSERT INTO cn=Steve Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Steve Boorsh,test2-multi)");
        stmt.executeUpdate("INSERT INTO cn=Sherry Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Sherry Boorsh,test3-multi)");
    }

    public void testParse() throws Exception {
        this.doDelete = true;
        this.doDeleteMulti = true;
        String sql = "UPDATE ou=Product Development SET title=Title set!, sn=?";
        JdbcLdapUpdate update = new JdbcLdapUpdate();
        update.init(this.con, sql);
        SqlStore store = update.getSqlStore();
        if (!store.getDistinguishedName().equals("ou=Product Development")) {
            TestUpdate.fail((String)("FROM not correct : " + store.getDistinguishedName()));
            return;
        }
        String[] look = store.getFields();
        if (!look[0].equals("title") || !look[1].equals("sn")) {
            TestUpdate.fail((String)("improper fields : " + look[0] + " " + look[1]));
            return;
        }
        look = store.getInsertFields();
        if (!look[0].equals("Title set!") || !look[1].equals("?")) {
            TestUpdate.fail((String)("improper insert fields : " + look[0] + " " + look[1]));
            return;
        }
        if (!store.getWhere().equals("(objectClass=*)")) {
            TestUpdate.fail((String)("improper where statement : " + store.getWhere()));
            return;
        }
        TestUpdate.assertTrue((boolean)true);
    }

    public void testParseMulti() throws Exception {
        this.doDelete = true;
        String sql = "UPDATE ou=Product Development SET title=Title set!, sn=? WHERE cn=?";
        JdbcLdapUpdate update = new JdbcLdapUpdate();
        update.init(this.con, sql);
        SqlStore store = update.getSqlStore();
        if (!store.getDistinguishedName().equals("ou=Product Development")) {
            TestUpdate.fail((String)("FROM not correct : " + store.getDistinguishedName()));
            return;
        }
        String[] look = store.getFields();
        if (!look[0].equals("title") || !look[1].equals("sn")) {
            TestUpdate.fail((String)("improper fields : " + look[0] + " " + look[1]));
            return;
        }
        look = store.getInsertFields();
        if (!look[0].equals("Title set!") || !look[1].equals("?")) {
            TestUpdate.fail((String)("improper insert fields : " + look[0] + " " + look[1]));
            return;
        }
        if (!store.getWhere().equals("(cn={0})")) {
            TestUpdate.fail((String)("invalid where : " + store.getWhere()));
        }
        update.setValue(0, "Boorshtein");
        update.setValue(1, "Marc Boorshtein, OctetString");
        String filter = update.getFilterWithParams();
        if (!filter.equals("(cn=Marc Boorshtein, OctetString)")) {
            TestUpdate.fail((String)("invalid complete filter : " + filter));
        }
        TestUpdate.assertTrue((boolean)true);
    }

    public void testUpdate() throws Exception {
        this.doDelete = true;
        this.doDeleteMulti = true;
        String SQL = "UPDATE ou=Product Development SET sn=Boorshtein WHERE sn=Boorsh";
        String search = "SELECT sn FROM ou=Product Development WHERE cn=*Boorsh";
        Statement stmt = this.con.createStatement();
        JdbcLdapUpdate update = new JdbcLdapUpdate();
        update.init(this.con, SQL);
        int count = (Integer)update.executeUpdate();
        if (count < 3) {
            TestUpdate.fail((String)("Error:, count is : " + count));
            return;
        }
        ResultSet rs = stmt.executeQuery(search);
        count = 0;
        while (rs.next()) {
            if (!rs.getString("sn").equals("Boorshtein")) {
                TestUpdate.fail((String)("sn is wrong : " + rs.getString("sn")));
                return;
            }
            ++count;
        }
        if (count < 3) {
            TestUpdate.fail((String)("wrong count! : " + count));
            return;
        }
        TestUpdate.assertTrue((boolean)true);
    }

    public void testUpdateParams() throws Exception {
        this.doDelete = true;
        this.doDeleteMulti = true;
        String SQL = "UPDATE ou=Product Development SET sn=? WHERE sn=?";
        String search = "SELECT sn FROM ou=Product Development WHERE cn=*Boorsh";
        Statement stmt = this.con.createStatement();
        JdbcLdapUpdate update = new JdbcLdapUpdate();
        update.init(this.con, SQL);
        update.setValue(0, "Boorshtein");
        update.setValue(1, "Boorsh");
        int count = (Integer)update.executeUpdate();
        if (count < 3) {
            TestUpdate.fail((String)("Error:, count is : " + count));
            return;
        }
        ResultSet rs = stmt.executeQuery(search);
        count = 0;
        while (rs.next()) {
            if (!rs.getString("sn").equals("Boorshtein")) {
                TestUpdate.fail((String)("sn is wrong : " + rs.getString("sn")));
                return;
            }
            ++count;
        }
        if (count < 3) {
            TestUpdate.fail((String)("wrong count! : " + count));
            return;
        }
        TestUpdate.assertTrue((boolean)true);
    }

    public void testUpdateStatement() throws Exception {
        this.doDelete = true;
        this.doDeleteMulti = true;
        String SQL = "UPDATE ou=Product Development SET sn=Boorshtein WHERE sn=Boorsh";
        String search = "SELECT sn FROM ou=Product Development WHERE cn=*Boorsh";
        Statement stmt = this.con.createStatement();
        int count = stmt.executeUpdate(SQL);
        if (count < 3) {
            TestUpdate.fail((String)("Error:, count is : " + count));
            return;
        }
        ResultSet rs = stmt.executeQuery(search);
        count = 0;
        while (rs.next()) {
            if (!rs.getString("sn").equals("Boorshtein")) {
                TestUpdate.fail((String)("sn is wrong : " + rs.getString("sn")));
                return;
            }
            ++count;
        }
        if (count < 3) {
            TestUpdate.fail((String)("wrong count! : " + count));
            return;
        }
        TestUpdate.assertTrue((boolean)true);
    }

    public void testUpdatePreparedStatement() throws Exception {
        this.doDelete = true;
        this.doDeleteMulti = true;
        String SQL = "UPDATE ou=Product Development SET sn=? WHERE sn=?";
        String search = "SELECT sn FROM ou=Product Development WHERE cn=*Boorsh";
        PreparedStatement ps = this.con.prepareStatement(SQL);
        Statement stmt = this.con.createStatement();
        ps.setString(1, "Boorshtein");
        ps.setString(2, "Boorsh");
        int count = ps.executeUpdate();
        if (count < 3) {
            TestUpdate.fail((String)("Error:, count is : " + count));
            return;
        }
        ResultSet rs = stmt.executeQuery(search);
        count = 0;
        while (rs.next()) {
            if (!rs.getString("sn").equals("Boorshtein")) {
                TestUpdate.fail((String)("sn is wrong : " + rs.getString("sn")));
                return;
            }
            ++count;
        }
        if (count < 3) {
            TestUpdate.fail((String)("wrong count! : " + count));
            return;
        }
        TestUpdate.assertTrue((boolean)true);
    }

    public void testUpdateQuotePreparedStatement() throws Exception {
        this.doDelete = true;
        this.doDeleteMulti = true;
        String SQL = "UPDATE ou=Product Development SET sn=\"Boorshtein, Marc\" WHERE sn=?";
        String search = "SELECT sn FROM ou=Product Development WHERE cn=*Boorsh";
        PreparedStatement ps = this.con.prepareStatement(SQL);
        Statement stmt = this.con.createStatement();
        ps.setString(1, "Boorsh");
        int count = ps.executeUpdate();
        if (count < 3) {
            TestUpdate.fail((String)("Error:, count is : " + count));
            return;
        }
        ResultSet rs = stmt.executeQuery(search);
        count = 0;
        while (rs.next()) {
            if (!rs.getString("sn").equals("Boorshtein, Marc")) {
                TestUpdate.fail((String)("sn is wrong : " + rs.getString("sn")));
                return;
            }
            ++count;
        }
        if (count < 3) {
            TestUpdate.fail((String)("wrong count! : " + count));
            return;
        }
        TestUpdate.assertTrue((boolean)true);
    }
}

