/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.novell.ldap.LDAPMessageQueue;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.jndi.UnpackResults;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSelect;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;

public class TestUnpack
extends TestCase {
    JndiLdapConnection con;

    public TestUnpack(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.con.close();
    }

    protected void setUp() throws Exception {
        Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        this.con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?SEARCH_SCOPE:=subTreeScope", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
    }

    public void testUnpackingResults() throws Exception {
        String sql = "SELECT sn,ou,seeAlso FROM  WHERE ou=Peons AND cn=A*";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        LDAPMessageQueue enumer = (LDAPMessageQueue)sel.executeQuery();
        UnpackResults pack = new UnpackResults(this.con);
        pack.unpackJldap(enumer, sel.getRetrieveDN(), sel.getSqlStore().getFrom(), this.con.getBaseDN(), null);
        ArrayList<String> fieldsExp = new ArrayList<String>();
        fieldsExp.add("sn");
        fieldsExp.add("ou");
        fieldsExp.add("seeAlso");
        ArrayList fields = pack.getFieldNames();
        for (String field : fields) {
            if (fieldsExp.contains(field)) continue;
            TestUnpack.fail((String)("Incorrect fields returned : " + field));
        }
        String cmpLdif = "dn: cn=Audi Hsiang,ou=Peons,dc=idrs,dc=com\n";
        cmpLdif = cmpLdif + "sn: Hsiang\n";
        cmpLdif = cmpLdif + "ou: Peons\n";
        cmpLdif = cmpLdif + "seeAlso: cn=Audi\n\n";
        cmpLdif = "dn: cn=Agnella Security,ou=Peons,dc=idrs,dc=com\n";
        cmpLdif = cmpLdif + "sn: Security\n";
        cmpLdif = cmpLdif + "ou: Peons\n";
        cmpLdif = cmpLdif + "seeAlso: cn=Agnella\n\n";
        cmpLdif = "dn: cn=Aggy Zimmermann,ou=Peons,dc=idrs,dc=com\n";
        cmpLdif = cmpLdif + "sn: Zimmermann\n";
        cmpLdif = cmpLdif + "ou: Peons\n";
        cmpLdif = cmpLdif + "seeAlso: cn=Aggy\n\n";
        cmpLdif = "dn: cn=Ailina Dept,ou=Peons,dc=idrs,dc=com\n";
        cmpLdif = cmpLdif + "sn: Dept\n";
        cmpLdif = cmpLdif + "ou: Peons\n";
        cmpLdif = cmpLdif + "seeAlso: cn=Ailina\n\n";
        cmpLdif = "dn: cn=Amir Poorman,ou=Peons,dc=idrs,dc=com\n";
        cmpLdif = cmpLdif + "sn: Poorman\n";
        cmpLdif = cmpLdif + "ou: Peons\n";
        cmpLdif = cmpLdif + "seeAlso: cn=Amir";
        ArrayList rowsExp = new ArrayList();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("sn", "Dept");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Ailina");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Poorman");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Amir");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Security");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Agnella");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Hsiang");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Audi");
        rowsExp.add(row);
        ArrayList rows = pack.getRows();
        TestUnpack.assertTrue((String)("Tables Don't Match\n\n" + this.formTable(rowsExp) + "\n\n" + this.formTable(rows)), (boolean)this.compareTables(fieldsExp, rowsExp, rows));
    }

    public void testUnpackResultsMultiValExpRows() throws Exception {
        this.con.setConcatAtts(false);
        this.con.setExpandRow(true);
        String sql = "SELECT objectClass,sn,ou,seeAlso FROM  WHERE ou=Peons AND sn=Zimmermann";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        LDAPMessageQueue enumer = (LDAPMessageQueue)sel.executeQuery();
        System.out.println(enumer);
        UnpackResults pack = new UnpackResults(this.con);
        pack.unpackJldap(enumer, sel.getRetrieveDN(), sel.getSqlStore().getFrom(), this.con.getBaseDN(), null);
        ArrayList<String> fieldsExp = new ArrayList<String>();
        fieldsExp.add("objectClass");
        fieldsExp.add("sn");
        fieldsExp.add("ou");
        fieldsExp.add("seeAlso");
        ArrayList fields = pack.getFieldNames();
        for (String field : fields) {
            if (fieldsExp.contains(field)) continue;
            TestUnpack.fail((String)("Incorrect fields returned : " + field));
        }
        ArrayList rowsExp = new ArrayList();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("objectClass", "top");
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        row = new HashMap();
        row.put("objectClass", "person");
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        row = new HashMap();
        row.put("objectClass", "organizationalPerson");
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        ArrayList rows = pack.getRows();
        TestUnpack.assertTrue((String)("Tables Don't Match\n\n" + this.formTable(rowsExp) + "\n\n" + this.formTable(rows)), (boolean)this.compareTables(fieldsExp, rowsExp, rows));
    }

    public void testUnpackingResultsMultIValueConcat() throws Exception {
        this.con.setConcatAtts(true);
        String sql = "SELECT objectClass,sn,ou,seeAlso FROM  WHERE ou=Peons AND cn=A*";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        LDAPMessageQueue enumer = (LDAPMessageQueue)sel.executeQuery();
        UnpackResults pack = new UnpackResults(this.con);
        pack.unpackJldap(enumer, sel.getRetrieveDN(), sel.getSqlStore().getFrom(), this.con.getBaseDN(), null);
        ArrayList<String> fieldsExp = new ArrayList<String>();
        fieldsExp.add("objectClass");
        fieldsExp.add("sn");
        fieldsExp.add("ou");
        fieldsExp.add("seeAlso");
        ArrayList fields = pack.getFieldNames();
        for (String field : fields) {
            if (fieldsExp.contains(field)) continue;
            TestUnpack.fail((String)("Incorrect fields returned : " + field));
        }
        ArrayList rowsExp = new ArrayList();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("objectClass", "[top][person][organizationalPerson]");
        row.put("sn", "Dept");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Ailina");
        rowsExp.add(row);
        row = new HashMap();
        row.put("objectClass", "[top][person][organizationalPerson]");
        row.put("sn", "Poorman");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Amir");
        rowsExp.add(row);
        row = new HashMap();
        row.put("objectClass", "[top][person][organizationalPerson]");
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        row = new HashMap();
        row.put("objectClass", "[top][person][organizationalPerson]");
        row.put("sn", "Security");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Agnella");
        rowsExp.add(row);
        row = new HashMap();
        row.put("objectClass", "[top][person][inetOrgPerson]");
        row.put("sn", "Hsiang");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Audi");
        rowsExp.add(row);
        ArrayList rows = pack.getRows();
        TestUnpack.assertTrue((String)("Tables Don't Match\n\n" + this.formTable(rowsExp) + "\n\n" + this.formTable(rows)), (boolean)this.compareTables(fieldsExp, rowsExp, rows));
    }

    public void testUnpackingResultsMultIValueNoConcat() throws Exception {
        this.con.setConcatAtts(false);
        String sql = "SELECT objectClass,sn,ou,seeAlso FROM  WHERE ou=Peons AND cn=A*";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        LDAPMessageQueue enumer = (LDAPMessageQueue)sel.executeQuery();
        UnpackResults pack = new UnpackResults(this.con);
        pack.unpackJldap(enumer, sel.getRetrieveDN(), sel.getSqlStore().getFrom(), this.con.getBaseDN(), null);
        ArrayList<String> fieldsExp = new ArrayList<String>();
        fieldsExp.add("objectClass_0");
        fieldsExp.add("objectClass_1");
        fieldsExp.add("objectClass_2");
        fieldsExp.add("sn");
        fieldsExp.add("ou");
        fieldsExp.add("seeAlso");
        ArrayList fields = pack.getFieldNames();
        for (String field : fields) {
            if (fieldsExp.contains(field)) continue;
            TestUnpack.fail((String)("Incorrect fields returned : " + field + "; " + fields));
        }
        ArrayList rowsExp = new ArrayList();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("objectClass_0", "top");
        row.put("objectClass_1", "person");
        row.put("objectClass_2", "organizationalPerson");
        row.put("sn", "Dept");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Ailina");
        rowsExp.add(row);
        row = new HashMap();
        row.put("objectClass_0", "top");
        row.put("objectClass_1", "person");
        row.put("objectClass_2", "organizationalPerson");
        row.put("sn", "Poorman");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Amir");
        rowsExp.add(row);
        row = new HashMap();
        row.put("objectClass_0", "top");
        row.put("objectClass_1", "person");
        row.put("objectClass_2", "organizationalPerson");
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        row = new HashMap();
        row.put("objectClass_0", "top");
        row.put("objectClass_1", "person");
        row.put("objectClass_2", "organizationalPerson");
        row.put("sn", "Security");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Agnella");
        rowsExp.add(row);
        row = new HashMap();
        row = new HashMap();
        row.put("objectClass_0", "top");
        row.put("objectClass_1", "person");
        row.put("objectClass_2", "inetOrgPerson");
        row.put("sn", "Hsiang");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Audi");
        rowsExp.add(row);
        ArrayList rows = pack.getRows();
        TestUnpack.assertTrue((String)("Tables Don't Match\n\n" + this.formTable(rowsExp) + "\n\n" + this.formTable(rows)), (boolean)this.compareTables(fieldsExp, rowsExp, rows));
    }

    public void testUnpackingResultsParams() throws Exception {
        String sql = "SELECT sn,ou,seeAlso FROM  WHERE ou=? AND cn=?";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        sel.getArgs()[0] = "Peons";
        sel.getArgs()[1] = "A*";
        LDAPMessageQueue enumer = (LDAPMessageQueue)sel.executeQuery();
        UnpackResults pack = new UnpackResults(this.con);
        pack.unpackJldap(enumer, sel.getRetrieveDN(), sel.getSqlStore().getFrom(), this.con.getBaseDN(), null);
        ArrayList<String> fieldsExp = new ArrayList<String>();
        fieldsExp.add("sn");
        fieldsExp.add("ou");
        fieldsExp.add("seeAlso");
        ArrayList fields = pack.getFieldNames();
        for (String field : fields) {
            if (fieldsExp.contains(field)) continue;
            TestUnpack.fail((String)("Incorrect fields returned : " + field));
        }
        ArrayList rowsExp = new ArrayList();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("sn", "Dept");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Ailina");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Poorman");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Amir");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Security");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Agnella");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Hsiang");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Audi");
        rowsExp.add(row);
        ArrayList rows = pack.getRows();
        TestUnpack.assertTrue((String)("Tables Don't Match\n\n" + this.formTable(rowsExp) + "\n\n" + this.formTable(rows)), (boolean)this.compareTables(fieldsExp, rowsExp, rows));
    }

    boolean compareTables(ArrayList f1, ArrayList t1, ArrayList t2) {
        for (int i = 0; i < t1.size(); ++i) {
            HashMap r1 = (HashMap)t1.get(i);
            HashMap r2 = (HashMap)t2.get(i);
            for (String fs : f1) {
                String field = fs;
                if (r1.get(field).equals(r2.get(field))) continue;
                System.out.println(i);
                System.out.println(r1.get(field) + " != " + r2.get(field));
                return false;
            }
        }
        return true;
    }

    String formTable(ArrayList t) {
        Iterator it;
        StringBuffer buff = new StringBuffer();
        try {
            it = ((HashMap)t.get(0)).keySet().iterator();
        }
        catch (Exception e) {
            return "";
        }
        while (it.hasNext()) {
            buff.append(it.next().toString()).append("\t");
        }
        buff.append('\n');
        for (int i = 0; i < t.size(); ++i) {
            HashMap r1 = (HashMap)t.get(i);
            for (String field : r1.keySet()) {
                buff.append(r1.get(field).toString()).append("\t");
            }
            buff.append('\n');
        }
        return buff.toString();
    }
}

