/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.util.AddPattern;
import com.octetstring.jdbcLdap.util.LDIF;
import com.octetstring.jdbcLdap.util.ObjRS;
import com.octetstring.jdbcLdap.util.TableDef;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestTableDef
extends TestCase {
    private JndiLdapConnection con;

    public TestTableDef(String arg0) {
        super(arg0);
    }

    protected void tearDown() throws Exception {
        this.con.close();
    }

    protected void setUp() throws Exception {
        Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        this.con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?CONCAT_ATTS:=true&SEARCH_SCOPE:=subTreeScope", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
    }

    public void testLoadProps() throws Exception {
        HashMap addPattern;
        JndiLdapConnection con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?CONCAT_ATTS:=true&SEARCH_SCOPE:=subTreeScope&TABLE_DEF:=C:\\table.prop", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        DatabaseMetaData md = con.getMetaData();
        boolean ok = false;
        ResultSet rs = md.getColumns(null, null, "users", "cn");
        if (!rs.next() || !rs.getString("COLUMN_NAME").equals("cn")) {
            TestTableDef.fail((String)"Did not load cn attribute");
            return;
        }
        rs = md.getColumns(null, null, "users", "%");
        while (rs.next()) {
            if (!rs.getString("COLUMN_NAME").equals("cn")) continue;
            ok = true;
        }
        rs = md.getColumns(null, null, "use%", "c%");
        boolean atleastonce = false;
        while (rs.next()) {
            atleastonce = true;
            if (!rs.getString("COLUMN_NAME").equals("cn")) continue;
            ok = true;
            break;
        }
        if (!atleastonce) {
            TestTableDef.fail((String)"no results");
        }
        rs = md.getColumns(null, null, "use%", "t%");
        atleastonce = false;
        while (rs.next()) {
            atleastonce = true;
            if (!rs.getString("COLUMN_NAME").equals("cn")) continue;
            TestTableDef.fail((String)"Contained cn");
            return;
        }
        if (!atleastonce) {
            TestTableDef.fail((String)"no results");
        }
        if (!ok) {
            TestTableDef.fail((String)"did not load attributes");
        }
        if (!((AddPattern)(addPattern = ((TableDef)con.getTableDefs().get("users")).getAddPatterns()).get("ou")).getAddPattern().equals("ou")) {
            TestTableDef.fail((String)"ou pattern doesn't exist");
        }
        if (!((AddPattern)((HashMap)addPattern.get("cn")).get("ou")).getAddPattern().equals("cn,ou")) {
            TestTableDef.fail((String)"cn,ou pattern doesn't exist");
        }
        con.close();
    }

    public void testCreateTableDef() throws Exception {
        TableDef tbl = new TableDef("users", "dc=idrs,dc=com", "subTreeScope", new String[]{"organizationalUnit", "inetOrgPerson", "domain"}, this.con.getConnection(), new HashMap());
        System.out.println(tbl.getTable());
        ObjRS rs = new ObjRS(tbl.getTable());
        boolean isOK = true;
        while (rs.next()) {
            String name = rs.getString("COLUMN_NAME");
            if (name != null && name.equals("cn") && !rs.getString("TYPE_NAME").equals("VARCHAR")) {
                TestTableDef.fail((String)"Improper cn type");
                return;
            }
            if (name == null || !name.equals("userPassword") || rs.getString("TYPE_NAME").equals("BINARY")) continue;
            TestTableDef.fail((String)"Improper userPassword type");
            return;
        }
    }

    public void testSelect() throws Exception {
        String ldif;
        LDIF exp;
        String url = System.getProperty("ldapConnString");
        url = url.substring(0, url.lastIndexOf(47) + 1);
        JndiLdapConnection con = (JndiLdapConnection)DriverManager.getConnection(url + "?CONCAT_ATTS:=true&SEARCH_SCOPE:=subTreeScope&TABLE_DEF:=C:\\table.prop", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        ResultSet rs = con.createStatement().executeQuery("SELECT DN FROM users WHERE cn='Marc Boorshtein' AND seeAlso='cn=Marc'");
        LDIF fromServer = new LDIF(rs, "DN", false);
        if (!fromServer.compareLdif(exp = new LDIF(ldif = "dn: cn=Marc Boorshtein,ou=Peons,dc=idrs,dc=com", false), new LDIF())) {
            TestTableDef.fail((String)("Un expected ldif: \n" + fromServer.toString()));
        }
        con.close();
    }

    public void testUpdate() throws Exception {
        String url = System.getProperty("ldapConnString");
        url = url.substring(0, url.lastIndexOf(47) + 1);
        JndiLdapConnection con = (JndiLdapConnection)DriverManager.getConnection(url + "?CONCAT_ATTS:=true&SEARCH_SCOPE:=subTreeScope&TABLE_DEF:=C:\\table.prop", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        con.createStatement().executeUpdate("UPDATE users SET sn='Boorsht' WHERE cn='Marc Boorshtein' AND seeAlso='cn=Marc'");
        ResultSet rs = con.createStatement().executeQuery("SELECT DN,sn FROM users WHERE cn='Marc Boorshtein' AND seeAlso='cn=Marc'");
        String ldif = "dn: cn=Marc Boorshtein,ou=Peons,dc=idrs,dc=com\nsn: Boorsht";
        LDIF fromServer = new LDIF(rs, "DN", false);
        LDIF exp = new LDIF(ldif, false);
        if (!fromServer.compareLdif(exp, new LDIF())) {
            TestTableDef.fail((String)("Un expected ldif: \n" + fromServer.toString()));
        }
        con.createStatement().executeUpdate("UPDATE users SET sn='Boorshtein' WHERE cn='Marc Boorshtein' AND seeAlso='cn=Marc'");
        con.close();
    }

    public void testUpdateEntry() throws Exception {
        String url = System.getProperty("ldapConnString");
        url = url.substring(0, url.lastIndexOf(47) + 1);
        JndiLdapConnection con = (JndiLdapConnection)DriverManager.getConnection(url + "?CONCAT_ATTS:=true&SEARCH_SCOPE:=subTreeScope&TABLE_DEF:=C:\\table.prop", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        con.createStatement().executeUpdate("UPDATE ENTRY users DO ADD SET sn='Boorsht' WHERE cn='Marc Boorshtein' AND seeAlso='cn=Marc'");
        ResultSet rs = con.createStatement().executeQuery("SELECT DN,sn FROM users WHERE cn='Marc Boorshtein' AND seeAlso='cn=Marc'");
        String ldif = "dn: cn=Marc Boorshtein,ou=Peons,dc=idrs,dc=com\nsn: Boorshtein\nsn: Boorsht";
        LDIF fromServer = new LDIF(rs, "DN", false);
        LDIF exp = new LDIF(ldif, false);
        if (!fromServer.compareLdif(exp, new LDIF())) {
            TestTableDef.fail((String)("Un expected ldif: \n" + fromServer.toString()));
        }
        con.createStatement().executeUpdate("UPDATE users SET sn='Boorshtein' WHERE cn='Marc Boorshtein' AND seeAlso='cn=Marc'");
        con.close();
    }

    public void testInsert() throws Exception {
        String url = System.getProperty("ldapConnString");
        url = url.substring(0, url.lastIndexOf(47) + 1);
        JndiLdapConnection con = (JndiLdapConnection)DriverManager.getConnection(url + "?CONCAT_ATTS:=true&SEARCH_SCOPE:=subTreeScope&TABLE_DEF:=C:\\table.prop", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        con.createStatement().executeUpdate("INSERT INTO users (objectClass,cn,sn,ou) VALUES (inetOrgPerson,Test User,User,Peons)");
        ResultSet rs = con.createStatement().executeQuery("SELECT DN,sn FROM users WHERE cn='Test User' AND ou='Peons'");
        String ldif = "dn: cn=Test User,ou=Peons,dc=idrs,dc=com\nsn: User";
        LDIF fromServer = new LDIF(rs, "DN", false);
        LDIF exp = new LDIF(ldif, false);
        if (!fromServer.compareLdif(exp, new LDIF())) {
            TestTableDef.fail((String)("Un expected ldif: \n" + fromServer.toString()));
        }
        con.createStatement().executeUpdate("DELETE FROM cn=Test User,ou=Peons,dc=idrs,dc=com");
        con.createStatement().executeUpdate("INSERT INTO users2 (cn,sn,ou) VALUES (Test User,User,Peons)");
        rs = con.createStatement().executeQuery("SELECT DN,sn,ou FROM users WHERE cn='Test User' AND sn='User'");
        ldif = "dn: cn=Test User,ou=Peons,dc=idrs,dc=com\nsn: User";
        fromServer = new LDIF(rs, "DN", false);
        exp = new LDIF(ldif, false);
        if (!fromServer.compareLdif(exp, new LDIF())) {
            TestTableDef.fail((String)("Un expected ldif: \n" + fromServer.toString()));
        }
        con.createStatement().executeUpdate("DELETE FROM cn=Test User,ou=Peons,dc=idrs,dc=com");
        con.close();
    }
}

