/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.JdbcLdapStatement;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.TestCase;

public class TestStatement
extends TestCase {
    JndiLdapConnection con;

    protected void tearDown() throws Exception {
        this.con.close();
    }

    protected void setUp() throws Exception {
        Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        this.con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?SEARCH_SCOPE:=subTreeScope", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
    }

    public void testGetResultSetFromStatement() throws Exception {
        String sql = "SELECT sn,ou,seeAlso FROM  WHERE ou=Peons AND cn=A*";
        JdbcLdapStatement stmt = new JdbcLdapStatement(this.con);
        ResultSet rs = stmt.executeQuery(sql);
        LinkedList<String> fieldsExp = new LinkedList<String>();
        fieldsExp.add("sn");
        fieldsExp.add("ou");
        fieldsExp.add("seeAlso");
        LinkedList rowsExp = new LinkedList();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("sn", "Dept");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Ailina");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Poorman");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Amir");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Security");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Agnella");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Hsiang");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Audi");
        rowsExp.add(row);
        if (!this.tstResultByMetaData(rowsExp, rs)) {
            TestStatement.fail((String)"Compare by Metadata Failed");
        }
        TestStatement.assertTrue((boolean)true);
    }

    public void testGetResultSetFromCreateStatement() throws Exception {
        String sql = "SELECT sn,ou,seeAlso FROM  WHERE ou=Peons AND cn=A*";
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        LinkedList<String> fieldsExp = new LinkedList<String>();
        fieldsExp.add("sn");
        fieldsExp.add("ou");
        fieldsExp.add("seeAlso");
        LinkedList rowsExp = new LinkedList();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("sn", "Dept");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Ailina");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Poorman");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Amir");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Security");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Agnella");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Hsiang");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Audi");
        rowsExp.add(row);
        if (!this.tstResultByMetaData(rowsExp, rs)) {
            TestStatement.fail((String)"Compare by Metadata Failed");
        }
        TestStatement.assertTrue((boolean)true);
    }

    public void testType() throws Exception {
        String sql = "SELECT * FROM ou=Peons WHERE cn=Marc Boorshtein, OctetString";
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        ResultSetMetaData md = rs.getMetaData();
        HashMap<String, String> ft = new HashMap<String, String>();
        ft.put("telephoneNumber", "INTEGER");
        ft.put("description", "VARCHAR");
        ft.put("l", "DATE");
        ft.put("seeAlso", "DOUBLE");
        ft.put("postalAddress", "TIMESTAMP");
        int m = md.getColumnCount();
        for (int i = 1; i <= m; ++i) {
            if (ft.get(md.getColumnLabel(i)) == null || ft.get(md.getColumnLabel(i)).equals(md.getColumnTypeName(i))) continue;
            TestStatement.fail((String)("Incorrect type for " + md.getColumnLabel(i) + " " + ft.get(md.getColumnLabel(i)) + " != " + md.getColumnTypeName(i)));
        }
    }

    public void testPreparedStatement() throws Exception {
        String sql = "SELECT sn,ou,seeAlso FROM  WHERE ou=? AND cn=?";
        PreparedStatement ps = this.con.prepareStatement(sql);
        if (ps == null) {
            System.out.println("ps is null");
        }
        ps.setString(1, "Peons");
        ps.setString(2, "A*");
        ResultSet rs = ps.executeQuery();
        LinkedList<String> fieldsExp = new LinkedList<String>();
        fieldsExp.add("sn");
        fieldsExp.add("ou");
        fieldsExp.add("seeAlso");
        LinkedList rowsExp = new LinkedList();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("sn", "Dept");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Ailina");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Poorman");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Amir");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Security");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Agnella");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Hsiang");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Audi");
        rowsExp.add(row);
        TestStatement.assertTrue((String)"table don't match", (boolean)this.tstResultByMetaData(rowsExp, rs));
    }

    public void testTryNonSQL() {
        try {
            JdbcLdapStatement stmt = new JdbcLdapStatement(this.con);
            stmt.executeQuery("DUBU dc=idrs,dc=com (cn,dn) VALUES (Marc,Marc Boorshtein, OctetString)");
        }
        catch (SQLException e) {
            TestStatement.assertTrue((boolean)true);
            return;
        }
        TestStatement.fail((String)"Didn't fail on INSERT");
    }

    public TestStatement(String name) {
        super(name);
    }

    boolean tstResultByMetaData(LinkedList test, ResultSet rs) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        Iterator itRows = test.iterator();
        while (rs.next()) {
            HashMap row = (HashMap)itRows.next();
            Object[] vals = row.values().toArray();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                if (row.get(rsmd.getColumnName(i)).equals(rs.getString(rsmd.getColumnName(i)))) continue;
                return false;
            }
        }
        return true;
    }

    public void testBatchStatement() throws Exception {
        Statement stmt = this.con.createStatement();
        stmt.addBatch("INSERT INTO cn=Marc Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Marc Boorsh,test1-multi)");
        stmt.addBatch("INSERT INTO cn=Steve Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Steve Boorsh,test1-multi)");
        stmt.addBatch("INSERT INTO cn=Sherry Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Sherry Boorsh,test1-multi)");
        stmt.addBatch("DELETE FROM ou=Product Development WHERE sn=Boorsh");
        int[] res = stmt.executeBatch();
        if (res[0] != 1) {
            TestStatement.fail((String)("Incorrect result 0 " + res[0]));
        }
        if (res[1] != 1) {
            TestStatement.fail((String)("Incorrect result 1 " + res[1]));
        }
        if (res[2] != 1) {
            TestStatement.fail((String)("Incorrect result 2 " + res[2]));
        }
        if (res[3] != 3) {
            TestStatement.fail((String)("Incorrect result 3 " + res[3]));
        }
    }

    public void testBatchPreparedStatement() throws Exception {
        Statement stmt = this.con.createStatement();
        stmt.addBatch("INSERT INTO cn=Marc Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Marc Boorsh,test1-multi)");
        stmt.addBatch("INSERT INTO cn=Steve Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Steve Boorsh,test1-multi)");
        stmt.addBatch("INSERT INTO cn=Sherry Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,title) VALUES (top,person,organizationalPerson,Boorsh,Sherry Boorsh,test1-multi)");
        stmt.executeBatch();
        PreparedStatement ps = this.con.prepareStatement("UPDATE ou=Product Development SET sn=? WHERE cn=?");
        ps.setString(1, "Boorsh1");
        ps.setString(2, "Marc Boorsh");
        ps.addBatch();
        ps.setString(1, "Boorsh2");
        ps.setString(2, "Steve Boorsh");
        ps.addBatch();
        ps.setString(1, "Boorsh3");
        ps.setString(2, "Sherry Boorsh");
        ps.addBatch();
        ps.executeBatch();
        ResultSet rs = stmt.executeQuery("SELECT sn FROM ou=Product Development WHERE cn=Marc Boorsh");
        rs.next();
        if (!rs.getString("sn").equals("Boorsh1")) {
            TestStatement.fail((String)("invalid sn : " + rs.getString("sn")));
            return;
        }
        rs = stmt.executeQuery("SELECT sn FROM ou=Product Development WHERE cn=Steve Boorsh");
        rs.next();
        if (!rs.getString("sn").equals("Boorsh2")) {
            TestStatement.fail((String)("invalid sn : " + rs.getString("sn")));
            return;
        }
        rs = stmt.executeQuery("SELECT sn FROM ou=Product Development WHERE cn=Sherry Boorsh");
        rs.next();
        if (!rs.getString("sn").equals("Boorsh3")) {
            TestStatement.fail((String)("invalid sn : " + rs.getString("sn")));
            return;
        }
        stmt.executeUpdate("DELETE FROM ou=Product Development WHERE sn=Boorsh*");
    }
}

