/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.octetstring.jdbcLdap.sql.SqlToLdap;
import java.sql.SQLException;
import java.util.LinkedList;
import junit.framework.TestCase;

public class TestSqlToLdap
extends TestCase {
    String testName;

    public TestSqlToLdap(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testParseLong() {
        int i;
        String expr = "F1=1 AND F2=2 OR (f3=3 OR f4=4) AND NOT f5=5";
        LinkedList<String> list = new LinkedList<String>();
        list.add("F1=1");
        list.add("AND");
        list.add("F2=2");
        list.add("OR");
        list.add("(");
        list.add("f3=3");
        list.add("OR");
        list.add("f4=4");
        list.add(")");
        list.add("AND");
        list.add("NOT");
        list.add("f5=5");
        SqlToLdap trans = new SqlToLdap();
        LinkedList comp = trans.inOrder(expr, null);
        boolean match = true;
        for (i = 0; i < list.size() && (match = list.get(i).equals(comp.get(i))); ++i) {
        }
        String result = "";
        for (i = 0; i < list.size(); ++i) {
            result = result + list.get(i).toString() + " --- " + comp.get(i).toString() + "\n";
        }
        if (!match) {
            TestSqlToLdap.fail((String)("Parseing Failed : \n" + result));
        } else {
            TestSqlToLdap.assertTrue((String)("PArsing Succeeded : \n" + result), (boolean)true);
        }
    }

    public void testParseAND() {
        int i;
        String expr = "F1=1 AND F2=2";
        LinkedList<String> list = new LinkedList<String>();
        list.add("F1=1");
        list.add("AND");
        list.add("F2=2");
        SqlToLdap trans = new SqlToLdap();
        LinkedList comp = trans.inOrder(expr, null);
        boolean match = true;
        for (i = 0; i < list.size() && (match = list.get(i).equals(comp.get(i))); ++i) {
        }
        String result = "";
        for (i = 0; i < list.size(); ++i) {
            result = result + list.get(i).toString() + " --- " + comp.get(i).toString() + "\n";
        }
        if (!match) {
            TestSqlToLdap.fail((String)("Parseing Failed : \n" + result));
        } else {
            TestSqlToLdap.assertTrue((String)("Parsing Succeeded : \n" + result), (boolean)true);
        }
    }

    public void testParseOR() {
        int i;
        String expr = "F2=2 OR f3=3";
        LinkedList<String> list = new LinkedList<String>();
        list.add("F2=2");
        list.add("OR");
        list.add("f3=3");
        SqlToLdap trans = new SqlToLdap();
        LinkedList comp = trans.inOrder(expr, null);
        boolean match = true;
        for (i = 0; i < list.size() && (match = list.get(i).equals(comp.get(i))); ++i) {
        }
        String result = "";
        for (i = 0; i < list.size(); ++i) {
            result = result + list.get(i).toString() + " --- " + comp.get(i).toString() + "\n";
        }
        if (!match) {
            TestSqlToLdap.fail((String)("Parseing Failed : \n" + result));
        } else {
            TestSqlToLdap.assertTrue((String)("Parsing Succeeded : \n" + result), (boolean)true);
        }
    }

    public void testParseNOT() {
        int i;
        String expr = "NOT f5=5";
        LinkedList<String> list = new LinkedList<String>();
        list.add("NOT");
        list.add("f5=5");
        SqlToLdap trans = new SqlToLdap();
        LinkedList comp = trans.inOrder(expr, null);
        boolean match = true;
        for (i = 0; i < list.size() && (match = list.get(i).equals(comp.get(i))); ++i) {
        }
        String result = "";
        for (i = 0; i < list.size(); ++i) {
            result = result + list.get(i).toString() + " --- " + comp.get(i).toString() + "\n";
        }
        if (!match) {
            TestSqlToLdap.fail((String)("Parseing Failed : \n" + result));
        } else {
            TestSqlToLdap.assertTrue((String)("PArsing Succeeded : \n" + result), (boolean)true);
        }
    }

    public void testParsePars() {
        int i;
        String expr = "(((((F1=1)))))";
        LinkedList<String> list = new LinkedList<String>();
        list.add("(");
        list.add("(");
        list.add("(");
        list.add("(");
        list.add("(");
        list.add("F1=1");
        list.add(")");
        list.add(")");
        list.add(")");
        list.add(")");
        list.add(")");
        SqlToLdap trans = new SqlToLdap();
        LinkedList comp = trans.inOrder(expr, null);
        boolean match = true;
        for (i = 0; i < list.size() && (match = list.get(i).equals(comp.get(i))); ++i) {
        }
        String result = "";
        for (i = 0; i < list.size(); ++i) {
            result = result + list.get(i).toString() + " --- " + comp.get(i).toString() + "\n";
        }
        if (!match) {
            TestSqlToLdap.fail((String)("Parseing Failed : \n" + result));
        } else {
            TestSqlToLdap.assertTrue((String)("Parsing Succeeded : \n" + result), (boolean)true);
        }
    }

    public void testSQLtoLDAP() throws SQLException {
        String sql = "NOT ou=Peons AND (ou=Accounting OR (ou=Payroll AND NOT ou=Planning))";
        String ldapExp = "(&(!(ou=Peons))(|(ou=Accounting)(&(ou=Payroll)(!(ou=Planning)))))";
        SqlToLdap trans = new SqlToLdap();
        String ldap = trans.convertToLdap(sql, null);
        TestSqlToLdap.assertTrue((String)"Statements are equal", (boolean)ldap.equalsIgnoreCase(ldapExp));
    }
}

