/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchResult;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSelect;
import java.sql.DriverManager;
import java.util.LinkedList;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import junit.framework.TestCase;

public class TestSelectRetrieve
extends TestCase {
    JndiLdapConnection con;

    public TestSelectRetrieve(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.con.close();
    }

    protected void setUp() throws Exception {
        Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        this.con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?SEARCH_SCOPE:=subTreeScope", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
    }

    public void testSelectRetrieve() throws Exception {
        String sql = "SELECT cn,sn,ou FROM  WHERE ou=Payroll OR ou=Peons";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        LDAPMessageQueue res = (LDAPMessageQueue)sel.executeQuery();
        LDAPConnection ldap = this.con.getConnection();
        String[] atts = new String[]{"cn", "sn", "ou"};
        String filter = "(|(ou=Payroll)(ou=Peons))";
        String base = this.con.getBaseContext();
        LDAPSearchQueue ctrl = ldap.search(base, 2, filter, atts, false, null, null);
        LinkedList l2 = this.load((LDAPMessageQueue)ctrl);
        LinkedList l1 = this.load(res);
        if (l1.size() != l2.size()) {
            TestSelectRetrieve.fail((String)"Same results not gotten");
        }
        TestSelectRetrieve.assertTrue((String)"Results don't match", (boolean)this.compareLists(l1, l2));
    }

    public void testSelectRetrieveArgs() throws Exception {
        String sql = "SELECT cn,sn,ou FROM  WHERE ou=? OR ou=?";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        sel.getArgs()[0] = "Payroll";
        sel.getArgs()[1] = "Peons";
        LDAPMessageQueue res = (LDAPMessageQueue)sel.executeQuery();
        LDAPConnection ldap = this.con.getConnection();
        String[] atts = new String[]{"cn", "sn", "ou"};
        String filter = "(|(ou=Payroll)(ou=Peons))";
        String base = this.con.getBaseContext();
        LDAPSearchQueue ctrl = ldap.search(base, 2, filter, atts, false, null, null);
        LinkedList l2 = this.load((LDAPMessageQueue)ctrl);
        LinkedList l1 = this.load(res);
        if (l1.size() != l2.size()) {
            TestSelectRetrieve.fail((String)"Same results not gotten");
        }
        TestSelectRetrieve.assertTrue((String)"Results don't match", (boolean)this.compareLists(l1, l2));
    }

    public void testSelectRetrieveNoWhere() throws Exception {
        String sql = "SELECT cn,sn,ou FROM ou=Peons";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        LDAPMessageQueue res = (LDAPMessageQueue)sel.executeQuery();
        LDAPConnection ldap = this.con.getConnection();
        String[] atts = new String[]{"cn", "sn", "ou"};
        String filter = "(objectClass=*)";
        String base = "ou=Peons," + this.con.getBaseContext();
        LDAPSearchQueue ctrl = ldap.search(base, 2, filter, atts, false, null, null);
        LinkedList l2 = this.load((LDAPMessageQueue)ctrl);
        LinkedList l1 = this.load(res);
        if (l1.size() != l2.size()) {
            TestSelectRetrieve.fail((String)"Same results not gotten");
        }
        TestSelectRetrieve.assertTrue((String)"Results don't match", (boolean)this.compareLists(l1, l2));
        TestSelectRetrieve.assertTrue((boolean)true);
    }

    LinkedList load(LDAPMessageQueue res) throws Exception {
        LinkedList list = new LinkedList();
        LDAPEntry entry = null;
        boolean hasMore = true;
        while (hasMore) {
            LinkedList<String> row = new LinkedList<String>();
            LDAPMessage message = res.getResponse();
            if (!(message instanceof LDAPSearchResult)) {
                LDAPResponse resp = (LDAPResponse)message;
                if (resp.getResultCode() == 0) {
                    hasMore = false;
                    break;
                }
                throw new LDAPException(resp.getErrorMessage(), resp.getResultCode(), resp.getErrorMessage(), resp.getMatchedDN());
            }
            entry = ((LDAPSearchResult)message).getEntry();
            LDAPAttributeSet attribs = entry.getAttributeSet();
            for (LDAPAttribute attrib : attribs) {
                String attrid = attrib.getName();
                String val = "";
                for (String obj : attrib.getStringValueArray()) {
                    val = val + obj.toString();
                }
                row.add(attrid + val);
            }
            list.add(row);
        }
        return list;
    }

    LinkedList load(NamingEnumeration enumer) throws Exception {
        LinkedList list = new LinkedList();
        while (enumer.hasMore()) {
            LinkedList<String> row = new LinkedList<String>();
            SearchResult res = (SearchResult)enumer.next();
            Attributes atts = res.getAttributes();
            NamingEnumeration<? extends Attribute> enum2 = atts.getAll();
            while (enum2.hasMore()) {
                Attribute att = enum2.next();
                String attrid = att.getID();
                String val = "";
                NamingEnumeration<?> vals = att.getAll();
                while (vals.hasMoreElements()) {
                    Object obj = vals.nextElement();
                    val = val + obj.toString();
                }
                row.add(attrid + val);
            }
            list.add(row);
        }
        return list;
    }

    boolean compareLists(LinkedList l1, LinkedList l2) {
        for (int i = 0; i < l1.size(); ++i) {
            LinkedList ll1 = (LinkedList)l1.get(i);
            LinkedList ll2 = (LinkedList)l2.get(i);
            if (ll1.size() != ll2.size()) {
                return false;
            }
            for (int j = 0; j < ll1.size(); ++j) {
                if (ll1.get(j).toString().equalsIgnoreCase(ll2.get(j).toString())) continue;
                return false;
            }
        }
        return true;
    }

    String printTable(LinkedList l) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < l.size(); ++i) {
            LinkedList row = (LinkedList)l.get(i);
            for (int j = 0; j < row.size(); ++j) {
                buf.append(row.get(j)).append("\t\t");
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

