/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSelect;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.TestCase;

public class TestSelect
extends TestCase {
    String name;
    JndiLdapConnection con;

    public TestSelect(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.con.close();
    }

    protected void setUp() throws Exception {
        Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        this.con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?SEARCH_SCOPE:=subTreeScope", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
    }

    public void testSQLSimple() throws SQLException {
        String sql = "SELECT cn,sn,ou FROM dc=idrs,dc=com WHERE ou=Payroll OR ou=Peons";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (!fields[0].equalsIgnoreCase("cn")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!fields[1].equalsIgnoreCase("sn")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!fields[2].equalsIgnoreCase("ou")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(|(ou=Payroll)(ou=Peons))")) {
            TestSelect.fail((String)("WHERE not correct\n(|(ou=Payroll)(ou=Peons)) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLWithArgs() throws SQLException {
        String sql = "SELECT cn,sn,ou FROM dc=idrs,dc=com WHERE ou=? OR ou=?";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (!fields[0].equalsIgnoreCase("cn")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!fields[1].equalsIgnoreCase("sn")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!fields[2].equalsIgnoreCase("ou")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(|(ou={0})(ou={1}))")) {
            TestSelect.fail((String)("WHERE not correct\n(|(ou={0})(ou={1})) !=" + sel.getSearchString()));
            return;
        }
        sel.getArgs()[0] = "Peons";
        sel.getArgs()[1] = "Payroll";
        if (!sel.getFilterWithParams().equalsIgnoreCase("(|(ou=Peons)(ou=Payroll))")) {
            TestSelect.fail((String)("WHERE not correct\n(|(ou=Peons)(ou=Payroll)) !=" + sel.getFilterWithParams()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLWithArgsEscape() throws SQLException {
        String sql = "SELECT cn,sn,ou FROM dc=idrs,dc=com WHERE ou=\\? OR ou=?";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (!fields[0].equalsIgnoreCase("cn")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!fields[1].equalsIgnoreCase("sn")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!fields[2].equalsIgnoreCase("ou")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(|(ou=?)(ou={0}))")) {
            TestSelect.fail((String)("WHERE not correct\n(|(ou=?)(ou={0})) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLAllAtts() throws SQLException {
        String sql = "SELECT * FROM dc=idrs,dc=com WHERE ou=Payroll OR ou=Peons";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (fields.length != 0) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(|(ou=Payroll)(ou=Peons))")) {
            TestSelect.fail((String)("WHERE not correct\n(|(ou=Payroll)(ou=Peons)) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLSetScope() throws SQLException {
        String sql = "SELECT cn,sn,ou FROM objectScope;dc=idrs,dc=com WHERE ou=Payroll OR ou=Peons";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (!fields[0].equalsIgnoreCase("cn")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!fields[1].equalsIgnoreCase("sn")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!fields[2].equalsIgnoreCase("ou")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(|(ou=Payroll)(ou=Peons))")) {
            TestSelect.fail((String)("WHERE not correct\n(|(ou=Payroll)(ou=Peons)) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 0) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLNoWhere() throws SQLException {
        String sql = "SELECT cn,sn,ou FROM objectScope;dc=idrs,dc=com";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (!fields[0].equalsIgnoreCase("cn")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!fields[1].equalsIgnoreCase("sn")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!fields[2].equalsIgnoreCase("ou")) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equals("(objectClass=*)")) {
            TestSelect.fail((String)("WHERE not correct\n" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 0) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLBadScope() throws SQLException {
        String sql = "SELECT cn,sn,ou FROM objectScop;dc=idrs,dc=com";
        try {
            JdbcLdapSelect sel = new JdbcLdapSelect();
            sel.init(this.con, sql);
        }
        catch (SQLException e) {
            TestSelect.assertTrue((boolean)true);
            return;
        }
        TestSelect.fail((String)"Bad scope not recognized");
    }

    public void testSQLWhereSpace() throws SQLException {
        String sql = "SELECT * FROM dc=idrs,dc=com WHERE cn=Marge Chima";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (fields.length != 0) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(cn=Marge Chima)")) {
            TestSelect.fail((String)("WHERE not correct\n(cn=Marge Chima) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLWhereSpaceQuotes() throws SQLException {
        String sql = "SELECT * FROM dc=idrs,dc=com WHERE cn='Marge Chima'";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (fields.length != 0) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(cn=Marge Chima)")) {
            TestSelect.fail((String)("WHERE not correct\n(cn=Marge Chima) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLWhereSpaceQuotesWhiteSpace() throws SQLException {
        String sql = "SELECT * FROM dc=idrs,dc=com WHERE cn = 'Marge Chima'";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (fields.length != 0) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(cn =Marge Chima)")) {
            TestSelect.fail((String)("WHERE not correct\n(cn =Marge Chima) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLWhereLIKE() throws SQLException {
        String sql = "SELECT * FROM dc=idrs,dc=com WHERE cn LIKE '\\%Ma%\\%'";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (fields.length != 0) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(cn=%Ma*%)")) {
            TestSelect.fail((String)("WHERE not correct\n(cn=%Ma*%) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLWhereLIKEOC() throws SQLException {
        System.err.println("---------------------------");
        String sql = "SELECT * FROM dc=idrs,dc=com WHERE cn LIKE '\\%Ma%\\%' AND objectClass='*'";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (fields.length != 0) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(&(cn=%Ma*%)(objectClass=*))")) {
            TestSelect.fail((String)("WHERE not correct\n(&(cn=%Ma*%)(objectClass=*)) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLWhereLIKEPresence() throws SQLException {
        System.err.println("---------------------------");
        String sql = "SELECT * FROM dc=idrs,dc=com WHERE objectClass IS NOT NULL AND cn LIKE '\\%Ma%\\%'";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (fields.length != 0) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(&(objectClass=*)(cn=%Ma*%))")) {
            TestSelect.fail((String)("WHERE not correct\n(&(objectClass=*)(cn=%Ma*%)) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLWhereLIKENOTPresence() throws SQLException {
        System.err.println("---------------------------");
        String sql = "SELECT * FROM dc=idrs,dc=com WHERE objectClass IS NULL AND cn LIKE '\\%Ma%\\%'";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (fields.length != 0) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(&(!(objectClass=*))(cn=%Ma*%))")) {
            TestSelect.fail((String)("WHERE not correct\n(&(!(objectClass=*))(cn=%Ma*%)) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }

    public void testSQLWhereLIKEPresenceMixed() throws SQLException {
        System.err.println("---------------------------");
        String sql = "SELECT * FROM dc=idrs,dc=com WHERE  (cn LIKE 'Clayton*' AND cn LIKE '*Donley') AND (objectClass IS NOT NULL AND cn IS NOt NULL)";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        String[] fields = sel.getSearchAttributes();
        if (fields.length != 0) {
            TestSelect.fail((String)"Fields don't match");
            return;
        }
        if (!sel.getBaseContext().equalsIgnoreCase("dc=idrs,dc=com")) {
            TestSelect.fail((String)"FROM not correct");
            return;
        }
        if (!sel.getSearchString().equalsIgnoreCase("(&(&(cn=Clayton*)(cn=*Donley))(&(objectClass=*)(cn=*)))")) {
            TestSelect.fail((String)("WHERE not correct\n(&(&(cn=Clayton*)(cn=*Donley))(&(objectClass=*)(cn=*))) !=" + sel.getSearchString()));
            return;
        }
        if (sel.getSearchScope() != 2) {
            TestSelect.fail((String)"Scope's not equal");
            return;
        }
        TestSelect.assertTrue((boolean)true);
    }
}

