/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.novell.ldap.LDAPMessageQueue;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.jndi.UnpackResults;
import com.octetstring.jdbcLdap.sql.LdapResultSet;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSelect;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.TestCase;

public class TestResultSet
extends TestCase {
    JndiLdapConnection con;

    public TestResultSet(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.con.close();
    }

    protected void setUp() throws Exception {
        Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        this.con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?SEARCH_SCOPE:=subTreeScope", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
    }

    public void testGetResultSet() throws Exception {
        String sql = "SELECT sn,ou,seeAlso FROM  WHERE ou=Peons AND cn=A*";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        LDAPMessageQueue enumer = (LDAPMessageQueue)sel.executeQuery();
        UnpackResults pack = new UnpackResults(this.con);
        pack.unpackJldap(enumer, sel.getRetrieveDN(), sel.getSqlStore().getFrom(), this.con.getBaseDN(), sel.getSqlStore().getRevFieldMap());
        LdapResultSet rs = new LdapResultSet(this.con, null, pack, sel.getBaseContext());
        LinkedList<String> fieldsExp = new LinkedList<String>();
        fieldsExp.add("sn");
        fieldsExp.add("ou");
        fieldsExp.add("seeAlso");
        LinkedList rowsExp = new LinkedList();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("sn", "Dept");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Ailina");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Poorman");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Amir");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Zimmermann");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Aggy");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Security");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Agnella");
        rowsExp.add(row);
        row = new HashMap();
        row.put("sn", "Hsiang");
        row.put("ou", "Peons");
        row.put("seeAlso", "cn=Audi");
        rowsExp.add(row);
        if (!this.tstResultSetByName(fieldsExp, rowsExp, rs)) {
            TestResultSet.fail((String)"Compare by Name Failed");
        }
        rs.beforeFirst();
        if (!this.tstResultByMetaData(rowsExp, rs)) {
            TestResultSet.fail((String)"Compare by Metadata Failed");
        }
        TestResultSet.assertTrue((boolean)true);
    }

    public void testGetMethods() throws Exception {
        BufferedReader in;
        String sql = "SELECT sn,ou,seeAlso,l,description,title FROM  WHERE ou=Peons AND cn=Aggy Zimmermann";
        JdbcLdapSelect sel = new JdbcLdapSelect();
        sel.init(this.con, sql);
        StringBuffer buf = new StringBuffer();
        LDAPMessageQueue enumer = (LDAPMessageQueue)sel.executeQuery();
        UnpackResults pack = new UnpackResults(this.con);
        pack.unpackJldap(enumer, sel.getRetrieveDN(), sel.getSqlStore().getFrom(), this.con.getBaseDN(), sel.getSqlStore().getRevFieldMap());
        LdapResultSet rs = new LdapResultSet(this.con, null, pack, sel.getBaseContext());
        LinkedList fieldsExp = new LinkedList();
        String ssn = "Zimmermann";
        String sou = "Peons";
        String sseeAlso = "cn=Aggy";
        String sl = "100";
        String sdescription = "true";
        String stitle_0 = "1981-3-20";
        String stitle_1 = "05:05:00";
        String stitle_2 = "1981-3-20 05:05:00";
        TestResultSet.assertTrue((String)"No results", (boolean)rs.next());
        try {
            TestResultSet.assertTrue((String)"String Values Don't Match", (boolean)rs.getString("sn").equals(ssn));
        }
        catch (Exception e) {
            TestResultSet.fail((String)("String : " + e.toString()));
            return;
        }
        try {
            TestResultSet.assertTrue((String)"Int Values Don't Match", (rs.getInt("l") == Integer.parseInt(sl) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestResultSet.fail((String)("Int : " + e.toString()));
            return;
        }
        try {
            TestResultSet.assertTrue((String)"Long Values Don't Match", (rs.getLong("l") == Long.parseLong(sl) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestResultSet.fail((String)("Long : " + e.toString()));
            return;
        }
        try {
            TestResultSet.assertTrue((String)"Doubel Values Don't Match", (rs.getDouble("l") == Double.parseDouble(sl) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestResultSet.fail((String)("Double : " + e.toString()));
            return;
        }
        try {
            TestResultSet.assertTrue((String)"Float Values Don't Match", (rs.getFloat("l") == Float.parseFloat(sl) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestResultSet.fail((String)("Float : " + e.toString()));
            return;
        }
        try {
            TestResultSet.assertTrue((String)"Boolean Values Don't Match", (rs.getBoolean(sdescription) == Boolean.getBoolean(sdescription) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestResultSet.fail((String)("Boolean : " + e.toString()));
            return;
        }
        try {
            TestResultSet.assertTrue((String)"Short Values Don't Match", (rs.getShort("l") == Short.parseShort(sl) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestResultSet.fail((String)("Short : " + e.toString()));
            return;
        }
        try {
            System.out.println("Title : " + rs.getString("title_0"));
            TestResultSet.assertTrue((String)"Date Values Don't Match", (boolean)rs.getDate("title_0").equals(Date.valueOf(stitle_0)));
        }
        catch (Exception e) {
            TestResultSet.fail((String)("Title_0 : " + e.toString() + "\n\n" + rs.getString("title_0")));
            return;
        }
        try {
            TestResultSet.assertTrue((String)"Time Values Don't Match", (boolean)rs.getTime("title_1").equals(Time.valueOf(stitle_1)));
        }
        catch (Exception e) {
            TestResultSet.fail((String)("Title_1 : " + e.toString() + "\n\n" + rs.getString("title_1")));
            return;
        }
        try {
            TestResultSet.assertTrue((String)"Timestamp Values Don't Match", (boolean)rs.getTimestamp("title_2").equals(Timestamp.valueOf(stitle_2)));
        }
        catch (Exception e) {
            TestResultSet.fail((String)("Title_2 : " + e.toString() + "\n\n" + rs.getString("title_2")));
            return;
        }
        try {
            buf.setLength(0);
            in = new BufferedReader(new InputStreamReader(rs.getAsciiStream("ou")));
            TestResultSet.assertTrue((String)"Asscii Stream Values Don't Match", (boolean)in.readLine().equals(sou));
        }
        catch (Exception e) {
            TestResultSet.fail((String)("AscciStream : " + e.toString() + "\n\n" + rs.getString("ou")));
            return;
        }
        try {
            buf.setLength(0);
            in = new BufferedReader(rs.getCharacterStream("ou"));
            TestResultSet.assertTrue((String)"Character Stream Values Don't Match", (boolean)in.readLine().equals(sou));
        }
        catch (Exception e) {
            TestResultSet.fail((String)("CharacterStream : " + e.toString() + "\n\n" + rs.getString("ou")));
            return;
        }
        TestResultSet.assertTrue((boolean)true);
    }

    boolean tstResultSetByName(LinkedList fields, LinkedList test, LdapResultSet rs) throws Exception {
        Iterator itRows = test.iterator();
        while (rs.next()) {
            HashMap row = (HashMap)itRows.next();
            for (String field : fields) {
                System.out.println("field : " + field);
                System.out.println("equal? " + row.get(field) + "==" + rs.getString(field));
                if (row.get(field).equals(rs.getString(field))) continue;
                return false;
            }
        }
        return true;
    }

    boolean tstResultByMetaData(LinkedList test, LdapResultSet rs) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        Iterator itRows = test.iterator();
        while (rs.next()) {
            HashMap row = (HashMap)itRows.next();
            Object[] vals = row.values().toArray();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                if (row.get(rsmd.getColumnName(i)).equals(rs.getString(rsmd.getColumnName(i)))) continue;
                System.out.println("TEST FAILED : " + vals[i - 1] + "; " + rsmd.getColumnName(i) + "; " + rs.getString(rsmd.getColumnName(i)));
                return false;
            }
        }
        return true;
    }
}

