/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.novell.ldap.LDAPException;
import com.novell.ldap.util.DN;
import com.octetstring.jdbcLdap.jndi.Insert;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapInsert;
import com.octetstring.jdbcLdap.util.LDIF;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.TestCase;

public class TestInsert
extends TestCase {
    JndiLdapConnection con;
    boolean doDelete;
    boolean care;

    public TestInsert(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        block6: {
            if (this.doDelete) {
                block5: {
                    System.out.println("deleting...");
                    try {
                        this.con.getConnection().delete("cn=\"Marc Boorshtein, OctetString\",ou=Product Development," + this.con.getBaseContext());
                    }
                    catch (LDAPException e) {
                        if (!this.care) break block5;
                        throw e;
                    }
                }
                try {
                    this.con.getConnection().delete("cn=Marc Boorshtein\\, OctetString,ou=Product Development," + this.con.getBaseContext());
                }
                catch (LDAPException e) {
                    if (!this.care) break block6;
                    throw e;
                }
            }
        }
        this.con.close();
    }

    protected void setUp() throws Exception {
        Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        this.con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?CONCAT_ATTS:=true&SEARCH_SCOPE:=subTreeScope", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
    }

    public void testParseStatement() throws Exception {
        int i;
        this.doDelete = true;
        this.care = false;
        String stmt = "INSERT INTO uid=9999,cn=Marc,sn=Boorshtein,ou=Software,dc=idrs,dc=com (objectClass,objectClass,uid,cn,sn) VALUES(organizationalPerson,Person,?,?,?)";
        String[] fields = new String[]{"objectClass", "objectClass", "uid", "cn", "sn"};
        String[] vals = new String[]{"organizationalPerson", "Person", "?", "?", "?"};
        int[] offset = new int[]{2, 3, 4, 0, 0};
        JdbcLdapInsert ins = new JdbcLdapInsert();
        ins.init(null, stmt);
        SqlStore store = ins.getSqlStore();
        if (!store.getDistinguishedName().equals("uid=9999,cn=Marc,sn=Boorshtein,ou=Software,dc=idrs,dc=com")) {
            TestInsert.fail((String)("-" + store.getDistinguishedName() + "-not correct"));
            return;
        }
        if (store.getFields().length != fields.length) {
            TestInsert.fail((String)"No Fields");
        }
        if ((i = 0) < store.getFields().length) {
            if (!store.getFields()[i].equals(fields[i])) {
                TestInsert.fail((String)(store.getFields()[i] + " not " + fields[i]));
            }
            return;
        }
        if (store.getInsertFields().length != vals.length) {
            TestInsert.fail((String)"No vals");
        }
        if ((i = 0) < store.getInsertFields().length) {
            if (!store.getInsertFields()[i].equals(vals[i])) {
                TestInsert.fail((String)(store.getInsertFields()[i] + " not " + vals[i]));
            }
            return;
        }
        if (store.getFieldOffset().length != offset.length) {
            TestInsert.fail((String)"No Offset");
        }
        if ((i = 0) < store.getFieldOffset().length) {
            if (store.getFieldOffset()[i] != offset[i]) {
                TestInsert.fail((String)(Integer.toString(store.getFieldOffset()[i]) + " not " + Integer.toString(offset[i])));
            }
            return;
        }
        TestInsert.assertTrue((boolean)true);
    }

    public void testInsertDirect() throws Exception {
        this.doDelete = true;
        String SQL = "INSERT INTO cn=\"Marc Boorshtein, OctetString\",ou=Product Development (objectClass,objectClass,objectClass,sn,cn) VALUES (top,person,organizationalPerson,?,?)";
        System.out.println("SQL : " + SQL);
        JdbcLdapInsert ins = new JdbcLdapInsert();
        System.out.println("con : " + this.con);
        ins.init(this.con, SQL);
        System.out.println("con now : " + ins.getConnection());
        ins.setValue(1, "Marc Boorshtein, OctetString");
        ins.setValue(0, "Marc");
        Insert jndiIns = new Insert();
        jndiIns.doInsertJldap(ins);
        PreparedStatement ps = this.con.prepareStatement("SELECT DN,sn,cn FROM ou=Product Development WHERE cn=Marc Boorshtein, OctetString");
        ResultSet rs = ps.executeQuery();
        rs.next();
        if (!rs.getString("cn").equals("Marc Boorshtein, OctetString")) {
            TestInsert.fail((String)("bad cn : " + rs.getString("cn")));
        }
        if (!new DN(rs.getString("DN")).equals(new DN("cn=Marc Boorshtein\\\\\\, OctetString,ou=Product Development,dc=idrs,dc=com")) && !new DN(rs.getString("DN")).equals(new DN("cn=Marc Boorshtein\\, OctetString,ou=Product Development,dc=idrs,dc=com"))) {
            TestInsert.fail((String)("bad dn : " + new DN(rs.getString("DN"))));
        }
    }

    public void testInsertStatement() throws Exception {
        System.out.println("entering testInsert");
        this.doDelete = true;
        String SQL = "INSERT INTO cn=\"Marc Boorshtein, OctetString\", ou=Product Development (objectClass,objectClass,objectClass,sn,cn) VALUES (top,person,organizationalPerson,Boorshtein,\"Marc Boorshtein, OctetString\")";
        Statement stmt = this.con.createStatement();
        int res = stmt.executeUpdate(SQL);
        if (res < 1) {
            TestInsert.fail((String)"no rows updated");
        }
        PreparedStatement ps = this.con.prepareStatement("SELECT DN,sn,cn FROM ou=Product Development WHERE cn=Marc Boorshtein, OctetString");
        ResultSet rs = ps.executeQuery();
        rs.next();
        if (!rs.getString("cn").equals("Marc Boorshtein, OctetString")) {
            TestInsert.fail((String)("bad cn : " + rs.getString("cn")));
        }
        System.out.println("DN : " + rs.getString("DN"));
        if (!new DN(rs.getString("DN")).equals(new DN("cn=Marc Boorshtein\\\\\\, OctetString,ou=Product Development,dc=idrs,dc=com")) && !new DN(rs.getString("DN")).equals(new DN("cn=Marc Boorshtein\\, OctetString,ou=Product Development,dc=idrs,dc=com"))) {
            TestInsert.fail((String)("bad dn : " + rs.getString("DN")));
        }
        System.out.println("leasving testInsert");
    }

    public void testInsertPreparedStatement() throws Exception {
        this.doDelete = true;
        String SQL = "INSERT INTO cn=Marc Boorshtein\\, OctetString,ou=Product Development (objectClass,objectClass,objectClass,sn,cn) VALUES (top,person,organizationalPerson,?,?)";
        PreparedStatement stmt = this.con.prepareStatement(SQL);
        stmt.setString(1, "Marc");
        stmt.setString(2, "Marc Boorshtein, OctetString");
        int res = stmt.executeUpdate();
        if (res < 1) {
            TestInsert.fail((String)"no rows updated");
        }
        PreparedStatement ps = this.con.prepareStatement("SELECT DN,sn,cn FROM ou=Product Development WHERE cn=Marc Boorshtein, OctetString");
        ResultSet rs = ps.executeQuery();
        rs.next();
        if (!rs.getString("cn").equals("Marc Boorshtein, OctetString")) {
            TestInsert.fail((String)("bad cn : " + rs.getString("cn")));
        }
        System.out.println("DN : " + rs.getString("DN"));
        if (!new DN(rs.getString("DN")).equals(new DN("cn=Marc Boorshtein\\\\\\, OctetString,ou=Product Development,dc=idrs,dc=com")) && !new DN(rs.getString("DN")).equals(new DN("cn=Marc Boorshtein\\, OctetString,ou=Product Development,dc=idrs,dc=com"))) {
            TestInsert.fail((String)("bad dn : " + rs.getString("DN")));
        }
    }

    public void testInsertPreparedStatementParamInInto() throws Exception {
        this.doDelete = true;
        String SQL = "INSERT INTO cn,ou=Product Development (objectClass,objectClass,objectClass,sn,cn) VALUES (top,person,organizationalPerson,?,?)";
        PreparedStatement stmt = this.con.prepareStatement(SQL);
        stmt.setString(1, "Marc");
        stmt.setString(2, "Marc Boorshtein, OctetString");
        int res = stmt.executeUpdate();
        if (res < 1) {
            TestInsert.fail((String)"no rows updated");
        }
        PreparedStatement ps = this.con.prepareStatement("SELECT DN,sn,cn FROM ou=Product Development WHERE cn=Marc Boorshtein, OctetString");
        ResultSet rs = ps.executeQuery();
        rs.next();
        if (!rs.getString("cn").equals("Marc Boorshtein, OctetString")) {
            TestInsert.fail((String)("bad cn : " + rs.getString("cn")));
        }
        System.out.println("DN : " + rs.getString("DN"));
        if (!new DN(rs.getString("DN")).equals(new DN("cn=Marc Boorshtein\\\\\\, OctetString,ou=Product Development,dc=idrs,dc=com")) && !new DN(rs.getString("DN")).equals(new DN("cn=Marc Boorshtein\\, OctetString,ou=Product Development,dc=idrs,dc=com"))) {
            TestInsert.fail((String)("bad dn : " + rs.getString("DN")));
        }
    }

    public void testInsertMultiValued() throws Exception {
        this.doDelete = true;
        String SQL = "INSERT INTO cn,ou=Product Development (objectClass,objectClass,objectClass,sn,cn,sn) VALUES (top,person,organizationalPerson,?,?,?)";
        PreparedStatement stmt = this.con.prepareStatement(SQL);
        stmt.setString(1, "Marc");
        stmt.setString(2, "Marc Boorshtein, OctetString");
        stmt.setString(3, "Lance");
        int res = stmt.executeUpdate();
        if (res < 1) {
            TestInsert.fail((String)"no rows updated");
        }
        PreparedStatement ps = this.con.prepareStatement("SELECT DN,sn,cn FROM ou=Product Development WHERE cn=Marc Boorshtein, OctetString");
        ResultSet rs = ps.executeQuery();
        String expected = "dn: cn=Marc Boorshtein\\, OctetString,ou=Product Development,dc=idrs,dc=com";
        expected = expected + "\ncn: Marc Boorshtein, OctetString";
        expected = expected + "\nsn: Marc";
        expected = expected + "\nsn: Lance";
        LDIF expLdif = new LDIF(expected, true);
        String expectedNew = "dn: cn=Marc Boorshtein\\\\\\, OctetString,ou=Product Development,dc=idrs,dc=com";
        expectedNew = expectedNew + "\ncn: Marc Boorshtein, OctetString";
        expectedNew = expectedNew + "\nsn: Marc";
        expectedNew = expectedNew + "\nsn: Lance";
        LDIF expLdifNew = new LDIF(expectedNew, true);
        LDIF found = new LDIF(rs, "DN", true);
        LDIF dif = new LDIF();
        if (!found.compareLdif(expLdif, dif) && !found.compareLdif(expLdifNew, dif)) {
            TestInsert.fail((String)("Results Don't Match : \nexpected:\n" + expLdifNew + "\nfound:\n" + found.toString()));
        }
    }
}

