/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.TestCase;

public class TestDriver
extends TestCase {
    public TestDriver(String name) {
        super(name);
    }

    public void testLoadDriver() {
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
        }
        catch (Exception eee) {
            eee.printStackTrace(System.out);
            TestDriver.fail((String)("error" + eee));
        }
        TestDriver.assertTrue((boolean)true);
    }

    public void testGenerateConnection() {
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            Connection con = DriverManager.getConnection(System.getProperty("ldapConnString"), System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        }
        catch (ClassNotFoundException ee) {
            ee.printStackTrace(System.out);
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            TestDriver.fail((String)"Driver not detected by url");
        }
        catch (Exception eee) {
            eee.printStackTrace(System.out);
            TestDriver.fail((String)("error" + eee));
        }
        TestDriver.assertTrue((boolean)true);
    }

    public void testSetSizeLimit() {
        Connection con = null;
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            String url = System.getProperty("ldapConnString");
            url = url.indexOf("?") == -1 ? url + "?SIZE_LIMIT:=1" : url + "&SIZE_LIMIT:=1";
            System.out.println("URL : " + url);
            con = DriverManager.getConnection(url, System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        }
        catch (ClassNotFoundException ee) {
            ee.printStackTrace(System.out);
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            TestDriver.fail((String)"Driver not detected by url");
        }
        catch (Exception eee) {
            eee.printStackTrace(System.out);
            TestDriver.fail((String)("error" + eee));
        }
        try {
            ResultSet rs = con.createStatement().executeQuery("SELECT DN FROM oneLevelScope;");
            while (rs.next()) {
                System.out.println(rs.getString("DN"));
            }
        }
        catch (SQLException e1) {
            TestDriver.assertTrue((boolean)true);
            return;
        }
        TestDriver.assertTrue((boolean)false);
    }

    public void testSetTimeLimit() {
        Connection con = null;
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            String url = System.getProperty("ldapConnString");
            url = url.indexOf("?") == -1 ? url + "?TIME_LIMIT:=1" : url + "&TIME_LIMIT:=1";
            System.out.println("URL : " + url);
            con = DriverManager.getConnection(url, System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        }
        catch (ClassNotFoundException ee) {
            ee.printStackTrace(System.out);
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            System.out.println("error code : " + e.getErrorCode());
            if (e.getErrorCode() == 85) {
                TestDriver.assertTrue((boolean)true);
                return;
            }
            e.printStackTrace(System.out);
            TestDriver.fail((String)"Driver not detected by url");
        }
        catch (Exception eee) {
            eee.printStackTrace(System.out);
            TestDriver.fail((String)("error" + eee));
        }
        try {
            ResultSet rs = con.createStatement().executeQuery("SELECT DN FROM oneLevelScope;");
            while (rs.next()) {
                System.out.println(rs.getString("DN"));
            }
        }
        catch (SQLException e1) {
            TestDriver.assertTrue((boolean)true);
            return;
        }
        TestDriver.assertTrue((boolean)false);
    }

    public void testGenerateTLSConnection() {
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            Connection con = DriverManager.getConnection(System.getProperty("ldapConnStringTLS"), System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        }
        catch (ClassNotFoundException ee) {
            ee.printStackTrace(System.out);
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            TestDriver.fail((String)"Driver not detected by url");
        }
        catch (Exception eee) {
            eee.printStackTrace(System.out);
            TestDriver.fail((String)("error" + eee));
        }
        TestDriver.assertTrue((boolean)true);
    }

    public void testGenerateConnectionUrlProps() {
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            Connection con = DriverManager.getConnection(System.getProperty("ldapConnString") + "?java.naming.authentication:=simple&user:=" + System.getProperty("ldapUser") + "&password:=" + System.getProperty("ldapPass"));
        }
        catch (ClassNotFoundException ee) {
            ee.printStackTrace(System.out);
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            TestDriver.fail((String)"Driver not detected by url");
        }
        catch (Exception eee) {
            eee.printStackTrace(System.out);
            TestDriver.fail((String)("error" + eee));
        }
        TestDriver.assertTrue((boolean)true);
    }

    public void testGenerateConnectionAnon() {
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            Connection con = DriverManager.getConnection(System.getProperty("ldapConnString") + "?java.naming.authentication:=none");
        }
        catch (ClassNotFoundException ee) {
            ee.printStackTrace(System.out);
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            TestDriver.fail((String)"Driver not detected by url");
        }
        catch (Exception eee) {
            eee.printStackTrace(System.out);
            TestDriver.fail((String)("error" + eee));
        }
        TestDriver.assertTrue((boolean)true);
    }

    public void testGenerateConnectionAnonNoTypeSpeced() {
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            Connection con = DriverManager.getConnection(System.getProperty("ldapConnString"));
        }
        catch (ClassNotFoundException ee) {
            ee.printStackTrace(System.out);
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            TestDriver.fail((String)"Driver not detected by url");
        }
        catch (Exception eee) {
            eee.printStackTrace(System.out);
            TestDriver.fail((String)("error" + eee));
        }
        TestDriver.assertTrue((boolean)true);
    }

    public void testGenerateConnectionBadUser() {
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            Connection con = DriverManager.getConnection(System.getProperty("ldapConnString") + "?user:=cn=Marc&password:=manager");
        }
        catch (ClassNotFoundException ee) {
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            TestDriver.assertTrue((boolean)true);
            return;
        }
        catch (Exception eee) {
            TestDriver.fail((String)("error" + eee));
        }
        TestDriver.fail((String)"Connection Succeeded");
    }

    public void testSetScope() throws Exception {
        Connection con = null;
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            con = DriverManager.getConnection(System.getProperty("ldapConnString") + "?user:=" + System.getProperty("ldapUser") + "&password:=" + System.getProperty("ldapPass") + "&SEARCH_SCOPE:=OBJECT_SCOPE");
        }
        catch (ClassNotFoundException ee) {
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            TestDriver.fail((String)"Not able to connect");
        }
        catch (Exception eee) {
            TestDriver.fail((String)("error" + eee));
        }
        TestDriver.assertEquals((Object)((JndiLdapConnection)con).getSearchScope(), (Object)"OBJECT_SCOPE");
    }

    public void testSetConcatAtts() throws Exception {
        Connection con = null;
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            con = DriverManager.getConnection(System.getProperty("ldapConnString") + "?user:=" + System.getProperty("ldapUser") + "&password:=" + System.getProperty("ldapPass") + "&CONCAT_ATTS:=true");
        }
        catch (ClassNotFoundException ee) {
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            TestDriver.fail((String)"Not able to connect");
        }
        catch (Exception eee) {
            TestDriver.fail((String)("error" + eee));
        }
        TestDriver.assertTrue((String)"Proprty not recognized", (boolean)((JndiLdapConnection)con).getConcatAtts());
    }

    public void testSetCache() throws Exception {
        Connection con = null;
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver").newInstance();
            con = DriverManager.getConnection(System.getProperty("ldapConnString") + "?user:=" + System.getProperty("ldapUser") + "&password:=" + System.getProperty("ldapPass") + "&CACHE_STATEMENTS:=true");
        }
        catch (ClassNotFoundException ee) {
            TestDriver.fail((String)"Not able to load driver");
        }
        catch (SQLException e) {
            TestDriver.fail((String)"Not able to connect");
        }
        catch (Exception eee) {
            TestDriver.fail((String)("error" + eee));
        }
        TestDriver.assertTrue((boolean)((JndiLdapConnection)con).cacheStatements());
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }
}

