/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.junit.sql;

import com.novell.ldap.LDAPException;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapDelete;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.TestCase;

public class TestDelete
extends TestCase {
    JndiLdapConnection con;
    boolean doInsert;
    boolean doDelete;
    boolean doDeleteMulti;

    public TestDelete(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        if (this.doDelete) {
            try {
                this.con.getConnection().delete("cn=\"Marc Boorshtein, OctetString\",ou=Product Development," + this.con.getBaseContext());
            }
            catch (LDAPException e) {
                // empty catch block
            }
            try {
                this.con.getConnection().delete("cn=Marc Boorshtein\\, OctetString,ou=Product Development," + this.con.getBaseContext());
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
        if (this.doDeleteMulti) {
            this.con.getConnection().delete("cn=Marc Boorsh,ou=Product Development,dc=idrs,dc=com");
            this.con.getConnection().delete("cn=Steve Boorsh,ou=Product Development,dc=idrs,dc=com");
            this.con.getConnection().delete("cn=Sherry Boorsh,ou=Product Development,dc=idrs,dc=com");
        }
        this.con.close();
    }

    protected void setUp() throws Exception {
        Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        this.con = (JndiLdapConnection)DriverManager.getConnection(System.getProperty("ldapConnString") + "?SEARCH_SCOPE:=subTreeScope", System.getProperty("ldapUser"), System.getProperty("ldapPass"));
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate("INSERT INTO cn=\"Marc Boorshtein, OctetString\",ou=Product Development (objectClass,objectClass,objectClass,sn,cn) VALUES (top,person,organizationalPerson,Boorshtein,\"Marc Boorshtein, OctetString\")");
        stmt.executeUpdate("INSERT INTO cn=Marc Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn) VALUES (top,person,organizationalPerson,Boorsh,Marc Boorsh)");
        stmt.executeUpdate("INSERT INTO cn=Steve Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn) VALUES (top,person,organizationalPerson,Boorsh,Steve Boorsh)");
        stmt.executeUpdate("INSERT INTO cn=Sherry Boorsh,ou=Product Development (objectClass,objectClass,objectClass,sn,cn) VALUES (top,person,organizationalPerson,Boorsh,Sherry Boorsh)");
    }

    public void testParse() throws Exception {
        this.doDelete = true;
        this.doDeleteMulti = true;
        String SQL = "DELETE FROM cn=\"Marc Boorshtein, OctetString\",ou=Product Development";
        JdbcLdapDelete del = new JdbcLdapDelete();
        del.init(this.con, SQL);
        SqlStore store = del.getSqlStore();
        if (!store.getFrom().equals("cn=\"Marc Boorshtein, OctetString\",ou=Product Development")) {
            TestDelete.fail((String)("from incorrect : " + store.getFrom()));
        }
        if (!store.getSimple()) {
            TestDelete.fail((String)"should be simple");
        }
        TestDelete.assertTrue((boolean)true);
    }

    public void testDeleteDirect() throws Exception {
        Statement stmt;
        ResultSet rs;
        this.doDelete = false;
        this.doDeleteMulti = true;
        String SQL = "DELETE FROM cn=\"Marc Boorshtein, OctetString\",ou=Product Development";
        JdbcLdapDelete del = new JdbcLdapDelete();
        del.init(this.con, SQL);
        int res = (Integer)del.executeUpdate();
        if (res < 1) {
            TestDelete.fail((String)"no result");
        }
        if ((rs = (stmt = this.con.createStatement()).executeQuery("SELECT DN FROM ou=Product Development WHERE cn=\"Marc Boorshtein, OctetString\"")).next()) {
            TestDelete.fail((String)"not deleted");
        }
        TestDelete.assertTrue((boolean)true);
    }

    public void testDeleteStatement() throws Exception {
        ResultSet rs;
        this.doDelete = false;
        this.doDeleteMulti = true;
        String SQL = "DELETE FROM cn=\"Marc Boorshtein, OctetString\",ou=Product Development";
        Statement stmt = this.con.createStatement();
        int res = stmt.executeUpdate(SQL);
        if (res < 1) {
            TestDelete.fail((String)"no result");
            this.doDelete = true;
        }
        if ((rs = stmt.executeQuery("SELECT DN FROM ou=Product Development WHERE cn=\"Marc Boorshtein, OctetString\"")).next()) {
            TestDelete.fail((String)"not deleted");
            this.doDelete = true;
        }
        TestDelete.assertTrue((boolean)true);
    }

    public void testDeletePreparedStatement() throws Exception {
        Statement stmt;
        ResultSet rs;
        this.doDelete = false;
        this.doDeleteMulti = true;
        String SQL = "DELETE FROM cn=\"Marc Boorshtein, OctetString\",ou=Product Development";
        PreparedStatement ps = this.con.prepareStatement(SQL);
        int res = ps.executeUpdate(SQL);
        if (res < 1) {
            TestDelete.fail((String)"no result");
            this.doDelete = true;
        }
        if ((rs = (stmt = this.con.createStatement()).executeQuery("SELECT DN FROM ou=Product Development WHERE cn=Marc Boorshtein, OctetString")).next()) {
            TestDelete.fail((String)"not deleted");
            this.doDelete = true;
        }
        TestDelete.assertTrue((boolean)true);
    }

    public void testDeleteMultiParse() throws Exception {
        this.doDelete = true;
        this.doDeleteMulti = true;
        String SQL = "DELETE FROM cn=\"Marc Boorshtein, OctetString\",ou=Product Development WHERE cn=Marc Boorshtein, OctetString AND sn=Boorshtein";
        JdbcLdapDelete del = new JdbcLdapDelete();
        del.init(this.con, SQL);
        SqlStore store = del.getSqlStore();
        if (!store.getFrom().equals("cn=\"Marc Boorshtein, OctetString\",ou=Product Development")) {
            TestDelete.fail((String)("from incorrect : " + store.getFrom()));
        }
        if (!del.getWhere().equals("(&(cn=Marc Boorshtein, OctetString)(sn=Boorshtein))")) {
            TestDelete.fail((String)("where incorrect : " + store.getWhere()));
        }
        if (store.getSimple()) {
            TestDelete.fail((String)"should not be simple");
        }
        TestDelete.assertTrue((boolean)true);
    }

    public void testDeleteDirectMulti() throws Exception {
        Statement stmt;
        ResultSet rs;
        this.doDelete = true;
        this.doDeleteMulti = false;
        String SQL = "DELETE FROM ou=Product Development WHERE sn=Boorsh";
        JdbcLdapDelete del = new JdbcLdapDelete();
        del.init(this.con, SQL);
        int res = (Integer)del.executeUpdate();
        if (res < 3) {
            TestDelete.fail((String)"not enough results");
        }
        if ((rs = (stmt = this.con.createStatement()).executeQuery("SELECT DN FROM ou=Product Development WHERE sn=Boorsh")).next()) {
            TestDelete.fail((String)"not deleted");
        }
        TestDelete.assertTrue((boolean)true);
    }

    public void testDeleteStatementMulti() throws Exception {
        ResultSet rs;
        this.doDelete = true;
        this.doDeleteMulti = false;
        String SQL = "DELETE FROM ou=Product Development WHERE sn=Boorsh";
        Statement stmt = this.con.createStatement();
        int res = stmt.executeUpdate(SQL);
        if (res < 3) {
            TestDelete.fail((String)"no result");
            this.doDelete = true;
        }
        if ((rs = stmt.executeQuery("SELECT DN FROM ou=Product Development WHERE sn=Boorsh")).next()) {
            TestDelete.fail((String)"not deleted");
            this.doDelete = true;
        }
        TestDelete.assertTrue((boolean)true);
    }

    public void testDeletePreparedStatementMulti() throws Exception {
        Statement stmt;
        ResultSet rs;
        this.doDelete = true;
        this.doDeleteMulti = false;
        String SQL = "DELETE FROM ou=Product Development WHERE sn=?";
        PreparedStatement ps = this.con.prepareStatement(SQL);
        ps.setString(1, "Boorsh");
        int res = ps.executeUpdate();
        if (res < 3) {
            TestDelete.fail((String)"no result");
            this.doDelete = true;
        }
        if ((rs = (stmt = this.con.createStatement()).executeQuery("SELECT DN FROM ou=Product Development WHERE sn=Boorsh")).next()) {
            TestDelete.fail((String)"not deleted");
            this.doDelete = true;
        }
        TestDelete.assertTrue((boolean)true);
    }
}

