/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.jndi;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPSearchResults;
import com.octetstring.jdbcLdap.backend.DirectoryRetrieveResults;
import com.octetstring.jdbcLdap.backend.DirectoryUpdateEntry;
import com.octetstring.jdbcLdap.jndi.SQLNamingException;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapUpdateEntry;
import com.octetstring.jdbcLdap.util.Pair;
import com.octetstring.jdbcLdap.util.UpdateSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class UpdateEntry
implements DirectoryUpdateEntry {
    public int doUpdateEntryJldap(JdbcLdapUpdateEntry stmt) throws SQLException {
        DirectoryRetrieveResults res = (DirectoryRetrieveResults)stmt.getJDBCConnection().getImplClasses().get("RETRIEVE_RESULTS");
        boolean argPos = false;
        StringBuffer dn = new StringBuffer();
        Iterator icmds = stmt.getCmds().iterator();
        LinkedList<LDAPModification> mods = new LinkedList<LDAPModification>();
        int paramnum = 0;
        while (icmds.hasNext()) {
            UpdateSet us = (UpdateSet)icmds.next();
            int modtype = us.getCmd().equalsIgnoreCase("add") ? 0 : (us.getCmd().equalsIgnoreCase("delete") ? 1 : 2);
            Iterator it = us.getAttribs().iterator();
            int i = 0;
            ArrayList al = new ArrayList();
            while (it.hasNext()) {
                String name;
                if (modtype == 0 || modtype == 2) {
                    String val;
                    Pair p = (Pair)it.next();
                    name = p.getName();
                    if (p.getValue().equals("?")) {
                        val = stmt.getArgVals()[paramnum];
                        ++paramnum;
                    } else {
                        val = p.getValue();
                    }
                    mods.add(new LDAPModification(modtype, new LDAPAttribute(name, val)));
                } else {
                    name = (String)it.next();
                    mods.add(new LDAPModification(modtype, new LDAPAttribute(name)));
                }
                ++i;
            }
        }
        Object[] toCopy = mods.toArray();
        LDAPModification[] doMods = new LDAPModification[toCopy.length];
        System.arraycopy(toCopy, 0, doMods, 0, doMods.length);
        StringBuffer buf = new StringBuffer();
        try {
            int count = 0;
            if (stmt.getSearchScope() != 0) {
                LDAPSearchResults enumer = res.searchUpInsJldap(stmt);
                while (enumer.hasMore()) {
                    LDAPEntry entry = enumer.next();
                    buf.setLength(0);
                    String name = entry.getDN();
                    stmt.getConnection().modify(name, doMods);
                    ++count;
                }
            } else {
                stmt.getConnection().modify(stmt.getBaseContext(), doMods);
                ++count;
            }
            return count;
        }
        catch (LDAPException ne) {
            throw new SQLNamingException(ne);
        }
    }
}

