/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.jndi;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPSearchResults;
import com.octetstring.jdbcLdap.backend.DirectoryRetrieveResults;
import com.octetstring.jdbcLdap.backend.DirectoryUpdate;
import com.octetstring.jdbcLdap.jndi.SQLNamingException;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapUpdate;
import java.sql.SQLException;

public class Update
implements DirectoryUpdate {
    public int doUpdateJldap(JdbcLdapUpdate update) throws SQLException {
        DirectoryRetrieveResults res = (DirectoryRetrieveResults)update.getCon().getImplClasses().get("RETRIEVE_RESULTS");
        LDAPConnection con = update.getConnection();
        StringBuffer buf = new StringBuffer();
        SqlStore store = update.getSqlStore();
        int count = 0;
        LDAPModification[] mods = new LDAPModification[store.getFields().length];
        String[] fields = store.getFields();
        String[] vals = update.getVals();
        int m = mods.length;
        for (int i = 0; i < m; ++i) {
            mods[i] = new LDAPModification(2, new LDAPAttribute(fields[i], vals[i]));
        }
        try {
            if (update.getSearchScope() != 0) {
                LDAPSearchResults enumer = res.searchUpInsJldap(update);
                while (enumer.hasMore()) {
                    LDAPEntry seres = enumer.next();
                    buf.setLength(0);
                    String name = seres.getDN();
                    con.modify(name, mods);
                    ++count;
                }
            } else {
                con.modify(update.getBaseContext(), mods);
                ++count;
            }
            return count;
        }
        catch (LDAPException ne) {
            throw new SQLNamingException(ne);
        }
    }
}

