/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.jndi;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPDN;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.util.Base64;
import com.octetstring.jdbcLdap.jndi.FieldStore;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.jndi.SQLNamingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class UnpackResults {
    static final String HEX_COMMA = "\\2C";
    static final String HEX_PLUS = "\\2B";
    static final String HEX_DBL_QUOTE = "\\22";
    static final String HEX_BACK_SLASH = "\\5C";
    static final String HEX_LESS = "\\3C";
    static final String HEX_MORE = "\\3E";
    static final String HEX_SEMI_COLON = "\\3B";
    static final HashMap HEX_TO_STRING = new HashMap();
    static final String DN_ATT = "DN";
    JndiLdapConnection con;
    HashMap names;
    ArrayList rows;
    LDAPMessageQueue queue;
    protected boolean dn;
    protected String fromContext;
    protected StringBuffer buff;
    protected LDAPEntry entry;
    ArrayList fieldNames;
    ArrayList fieldTypes;
    private boolean hasMoreEntries;
    private LDAPSearchResults searchResults;
    private HashMap revMap;

    public UnpackResults(JndiLdapConnection con) {
        this.con = con;
        this.names = new HashMap();
        this.rows = new ArrayList();
    }

    public ArrayList getFieldNames() {
        return this.fieldNames;
    }

    public ArrayList getFieldTypes() {
        return this.fieldTypes;
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public void unpackJldap(LDAPSearchResults res, boolean dn, String fromContext, String baseContext, HashMap revMap) throws SQLException {
        Object expRows = null;
        this.queue = null;
        this.searchResults = res;
        this.revMap = revMap;
        StringBuffer buff = new StringBuffer();
        this.names.clear();
        this.rows.clear();
        Object entry = null;
        buff.setLength(0);
        if (fromContext != null && fromContext.length() != 0) {
            buff.append(',').append(fromContext);
        }
        if (baseContext != null && baseContext.length() != 0) {
            buff.append(',').append(baseContext);
        }
        String base = buff.toString();
        this.dn = dn;
        this.fromContext = fromContext;
        this.buff = buff;
        this.entry = entry;
        this.fieldNames = new ArrayList();
        this.fieldTypes = new ArrayList();
        this.hasMoreEntries = true;
        if (this.con.isPreFetch()) {
            int i = 0;
            while (this.moveNext(i++)) {
            }
        }
    }

    public void unpackJldap(LDAPMessageQueue queue, boolean dn, String fromContext, String baseContext, HashMap revMap) throws SQLException {
        Object expRows = null;
        this.revMap = revMap;
        this.queue = queue;
        this.searchResults = null;
        StringBuffer buff = new StringBuffer();
        this.names.clear();
        this.rows.clear();
        Object entry = null;
        buff.setLength(0);
        if (fromContext != null && fromContext.length() != 0) {
            buff.append(',').append(fromContext);
        }
        if (baseContext != null && baseContext.length() != 0) {
            buff.append(',').append(baseContext);
        }
        String base = buff.toString();
        this.dn = dn;
        this.fromContext = fromContext;
        this.buff = buff;
        this.entry = entry;
        this.fieldNames = new ArrayList();
        this.fieldTypes = new ArrayList();
        this.hasMoreEntries = true;
        if (this.con.isPreFetch()) {
            int i = 0;
            while (this.moveNext(i++)) {
            }
        }
    }

    protected LDAPEntry extractEntry(boolean dn, String fromContext, StringBuffer buff, LDAPEntry entry) throws SQLNamingException {
        FieldStore field;
        ArrayList<HashMap> expRows = null;
        LDAPAttributeSet atts = entry.getAttributeSet();
        HashMap row2 = new HashMap();
        if (this.con.isExpandRow()) {
            expRows = new ArrayList<HashMap>();
            expRows.add(row2);
        }
        if (dn) {
            field = (FieldStore)this.names.get(DN_ATT);
            if (field == null) {
                field = new FieldStore();
                field.name = DN_ATT;
                this.names.put(field.name, field);
                this.fieldNames.add(DN_ATT);
                this.fieldTypes.add(new Integer(field.type));
            }
            buff.setLength(0);
            row2.put(DN_ATT, LDAPDN.normalize((String)entry.getDN()));
        }
        Object[] attribArray = atts.toArray();
        int n = attribArray.length;
        for (int j = 0; j < n; ++j) {
            String val2;
            String[] svals;
            byte[] bval;
            LDAPAttribute attrib = (LDAPAttribute)attribArray[j];
            field = (FieldStore)this.names.get(this.getFieldName(attrib.getName()));
            boolean existed = true;
            if (field == null) {
                field = new FieldStore();
                field.name = this.getFieldName(attrib.getName());
                this.names.put(field.name, field);
                existed = false;
            }
            if ((bval = attrib.getByteValue()) == null) {
                bval = new byte[]{};
            }
            if (Base64.isLDIFSafe((byte[])bval)) {
                svals = attrib.getStringValueArray();
            } else {
                byte[][] byteVals = attrib.getByteValueArray();
                svals = new String[byteVals.length];
                int m = byteVals.length;
                for (int i = 0; i < m; ++i) {
                    svals[i] = Base64.encode((byte[])byteVals[i]);
                }
            }
            if (svals.length <= 1) {
                if (this.con.isExpandRow()) {
                    val2 = svals.length != 0 ? svals[0] : "";
                    Iterator it = expRows.iterator();
                    while (it.hasNext()) {
                        field.determineType(val2);
                        row2 = (HashMap)it.next();
                        row2.put(field.name, val2);
                    }
                    if (existed) continue;
                    this.fieldNames.add(field.name);
                    this.fieldTypes.add(new Integer(field.type));
                    continue;
                }
                val2 = svals[0];
                field.determineType(val2);
                row2.put(field.name, val2);
                if (existed) continue;
                this.fieldNames.add(field.name);
                this.fieldTypes.add(new Integer(field.type));
                continue;
            }
            if (this.con.getConcatAtts()) {
                buff.setLength(0);
                field.numVals = 0;
                for (String val2 : svals) {
                    field.determineType(val2);
                    buff.append('[').append(val2).append(']');
                }
                row2.put(field.name, buff.toString());
                if (existed) continue;
                this.fieldNames.add(field.name);
                this.fieldTypes.add(new Integer(field.type));
                continue;
            }
            if (this.con.isExpandRow()) {
                ArrayList<HashMap> tmprows = new ArrayList<HashMap>();
                for (String val2 : svals) {
                    field.determineType(val2);
                    for (HashMap row2 : expRows) {
                        row2 = (HashMap)row2.clone();
                        row2.put(field.name, val2);
                        tmprows.add(row2);
                    }
                }
                if (!existed) {
                    this.fieldNames.add(field.name);
                    this.fieldTypes.add(new Integer(field.type));
                }
                expRows = tmprows;
                continue;
            }
            int currNumVals = 0;
            int low = field.numVals;
            int m = svals.length;
            for (int i = 0; i < m; ++i) {
                buff.setLength(0);
                val2 = svals[i];
                field.determineType(val2);
                row2.put(buff.append(field.name).append('_').append(currNumVals).toString(), val2);
                String fieldName = field.name + "_" + Integer.toString(++currNumVals - 1);
                if (currNumVals < low || this.fieldNames.contains(fieldName)) continue;
                this.fieldNames.add(fieldName);
                this.fieldTypes.add(new Integer(field.type));
            }
            field.numVals = currNumVals > field.numVals ? currNumVals : field.numVals;
        }
        if (this.con.isExpandRow()) {
            this.rows.addAll(expRows);
        } else {
            this.rows.add(row2);
        }
        return entry;
    }

    private LDAPEntry getEntry(LDAPSearchResults results, String fromContext, LDAPEntry entry) throws SQLNamingException {
        try {
            entry = results.next();
        }
        catch (LDAPReferralException ref) {
            String refName = "cn=Referral[" + ref.getReferrals()[0] + "]";
            if (entry == null) {
                if (this.con.baseDN != null && this.con.baseDN.trim().length() >= 0) {
                    refName = refName + "," + fromContext;
                }
            } else {
                String[] parts = LDAPDN.explodeDN((String)entry.getDN(), (boolean)false);
                int m = parts.length;
                for (int i = 1; i < m; ++i) {
                    refName = refName + "," + parts[i];
                }
            }
            LDAPAttribute attrib = new LDAPAttribute("ref");
            String[] refUrls = ref.getReferrals();
            int m = refUrls.length;
            for (int i = 0; i < m; ++i) {
                attrib.addValue(refUrls[i]);
            }
            LDAPAttributeSet attribs = new LDAPAttributeSet();
            attribs.add((Object)attrib);
            entry = new LDAPEntry(refName, attribs);
        }
        catch (LDAPException e) {
            throw new SQLNamingException(e);
        }
        return entry;
    }

    public String cleanDn(String dn) {
        StringBuffer buf = new StringBuffer(dn);
        int begin = buf.indexOf("\\");
        while (begin != -1) {
            String val = (String)HEX_TO_STRING.get(buf.substring(begin, begin + 3));
            if (val != null) {
                buf.replace(begin, begin + 3, val);
            }
            begin = buf.indexOf("\\", begin + 1);
        }
        return buf.toString();
    }

    public boolean moveNext(int index) throws SQLNamingException {
        if (index >= this.rows.size()) {
            if (this.hasMoreEntries) {
                this.getNextEntry();
                return this.hasMoreEntries;
            }
            return false;
        }
        return true;
    }

    protected void getNextEntry() throws SQLNamingException {
        if (this.queue != null) {
            this.getNextQueue();
        } else {
            this.getNextResults();
        }
    }

    private void getNextQueue() throws SQLNamingException {
        LDAPMessage message;
        try {
            message = this.queue.getResponse();
        }
        catch (LDAPException e) {
            throw new SQLNamingException(e);
        }
        if (message instanceof LDAPSearchResult) {
            this.entry = ((LDAPSearchResult)message).getEntry();
            this.extractEntry(this.dn, this.fromContext, this.buff, this.entry);
        } else if (message instanceof LDAPSearchResultReference) {
            LDAPSearchResultReference ref = (LDAPSearchResultReference)message;
            String refName = "cn=Referral[" + ref.getReferrals()[0] + "]";
            if (this.entry == null) {
                if (this.con.baseDN != null && this.con.baseDN.trim().length() >= 0) {
                    refName = refName + "," + this.fromContext;
                }
            } else {
                String[] parts = LDAPDN.explodeDN((String)this.entry.getDN(), (boolean)false);
                int m = parts.length;
                for (int i = 1; i < m; ++i) {
                    refName = refName + "," + parts[i];
                }
            }
            LDAPAttribute attrib = new LDAPAttribute("ref");
            String[] refUrls = ref.getReferrals();
            int m = refUrls.length;
            for (int i = 0; i < m; ++i) {
                attrib.addValue(refUrls[i]);
            }
            LDAPAttributeSet attribs = new LDAPAttributeSet();
            attribs.add((Object)attrib);
            this.entry = new LDAPEntry(refName, attribs);
            this.extractEntry(this.dn, this.fromContext, this.buff, this.entry);
        } else {
            LDAPResponse resp = (LDAPResponse)message;
            if (resp.getResultCode() == 0) {
                this.hasMoreEntries = false;
            } else {
                throw new SQLNamingException(new LDAPException(resp.getErrorMessage(), resp.getResultCode(), resp.getErrorMessage(), resp.getMatchedDN()));
            }
        }
    }

    private void getNextResults() throws SQLNamingException {
        if (!this.searchResults.hasMore()) {
            this.hasMoreEntries = false;
            return;
        }
        try {
            this.entry = this.searchResults.next();
            if (this.con.isSPML()) {
                String name = this.entry.getDN();
                this.entry = new LDAPEntry(name + ",ou=Users," + this.con.getBaseContext(), this.entry.getAttributeSet());
            }
            this.extractEntry(this.dn, this.fromContext, this.buff, this.entry);
        }
        catch (LDAPReferralException ref) {
            String refName = "cn=Referral[" + ref.getReferrals()[0] + "]";
            if (this.entry == null) {
                if (this.con.baseDN != null && this.con.baseDN.trim().length() >= 0) {
                    refName = refName + "," + this.fromContext;
                }
            } else {
                String[] parts = LDAPDN.explodeDN((String)this.entry.getDN(), (boolean)false);
                int m = parts.length;
                for (int i = 1; i < m; ++i) {
                    refName = refName + "," + parts[i];
                }
            }
            LDAPAttribute attrib = new LDAPAttribute("ref");
            String[] refUrls = ref.getReferrals();
            int m = refUrls.length;
            for (int i = 0; i < m; ++i) {
                attrib.addValue(refUrls[i]);
            }
            LDAPAttributeSet attribs = new LDAPAttributeSet();
            attribs.add((Object)attrib);
            this.entry = new LDAPEntry(refName, attribs);
            this.extractEntry(this.dn, this.fromContext, this.buff, this.entry);
        }
        catch (LDAPException ldape) {
            throw new SQLNamingException(ldape);
        }
    }

    private String getFieldName(String name) {
        String nname;
        if (this.revMap != null && (nname = (String)this.revMap.get(name)) != null) {
            return nname;
        }
        return name;
    }

    static {
        HEX_TO_STRING.put(HEX_COMMA, "\\,");
        HEX_TO_STRING.put(HEX_PLUS, "\\+");
        HEX_TO_STRING.put(HEX_DBL_QUOTE, "\\\"");
        HEX_TO_STRING.put(HEX_BACK_SLASH, "\\\\");
        HEX_TO_STRING.put(HEX_LESS, "\\<");
        HEX_TO_STRING.put(HEX_MORE, "\\>");
        HEX_TO_STRING.put(HEX_SEMI_COLON, "\\;");
    }
}

