/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.jndi;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.controls.LDAPSortControl;
import com.novell.ldap.controls.LDAPSortKey;
import com.octetstring.jdbcLdap.backend.DirectoryRetrieveResults;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.jndi.SQLNamingException;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSelect;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSqlAbs;
import java.sql.SQLException;
import java.util.HashMap;

public class RetrieveResults
implements DirectoryRetrieveResults {
    public Object searchJldap(JdbcLdapSelect select) throws SQLException {
        try {
            LDAPConnection con = select.getConnection();
            String[] fields = select.getSearchAttributes();
            fields = fields != null ? fields : new String[]{};
            String[] searchAttribs = fields.length == 1 && fields[0].equalsIgnoreCase("dn") ? new String[]{"1.1"} : fields;
            String useBase = JndiLdapConnection.getRealBase(select);
            String filter = select.getFilterWithParams();
            LDAPSearchConstraints constraints = null;
            if (select.getJDBCConnection().getMaxSizeLimit() >= 0) {
                constraints = con.getSearchConstraints();
                constraints.setMaxResults(select.getJDBCConnection().getMaxSizeLimit());
            }
            if (select.getJDBCConnection().getMaxTimeLimit() >= 0) {
                if (constraints == null) {
                    constraints = con.getSearchConstraints();
                }
                constraints.setTimeLimit(select.getJDBCConnection().getMaxTimeLimit());
            }
            LDAPSortKey[] keys = null;
            if (select.getSqlStore().getOrderby() != null) {
                keys = new LDAPSortKey[select.getSqlStore().getOrderby().length];
                int m = keys.length;
                for (int i = 0; i < m; ++i) {
                    keys[i] = new LDAPSortKey(this.getFieldName(select.getSqlStore().getOrderby()[i], select.getSqlStore().getFieldMap()));
                }
            }
            if (select.getJDBCConnection().isDSML() || select.getJDBCConnection().isSPML()) {
                return con.search(useBase, select.getSearchScope(), filter, searchAttribs, false, constraints);
            }
            if (keys != null) {
                constraints.setControls(new LDAPControl[]{new LDAPSortControl(keys, true)});
            }
            return con.search(useBase, select.getSearchScope(), filter, searchAttribs, false, null, constraints);
        }
        catch (LDAPException e) {
            throw new SQLNamingException(e);
        }
    }

    public LDAPSearchResults searchUpInsJldap(JdbcLdapSqlAbs sql) throws SQLException {
        try {
            LDAPConnection con = sql.getConnection();
            String useBase = JndiLdapConnection.getRealBase(sql);
            String filter = sql.getFilterWithParams();
            LDAPSearchConstraints constraints = null;
            if (sql.getJDBCConnection().getMaxSizeLimit() >= 0) {
                constraints = con.getSearchConstraints();
                constraints.setMaxResults(sql.getJDBCConnection().getMaxSizeLimit());
            }
            if (sql.getJDBCConnection().getMaxTimeLimit() >= 0) {
                if (constraints == null) {
                    constraints = con.getSearchConstraints();
                }
                constraints.setTimeLimit(sql.getJDBCConnection().getMaxTimeLimit());
            }
            return con.search(useBase, sql.getSearchScope(), filter, new String[]{"1.1"}, false, constraints);
        }
        catch (LDAPException e) {
            throw new SQLNamingException(e);
        }
    }

    private String getFieldName(String name, HashMap revMap) {
        String nname;
        if (revMap != null && (nname = (String)revMap.get(name)) != null) {
            return nname;
        }
        return name;
    }
}

