/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.jndi;

import com.novell.ldap.DsmlConnection;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.LDAPUrl;
import com.novell.ldap.SPMLConnection;
import com.octetstring.jdbcLdap.jndi.SQLNamingException;
import com.octetstring.jdbcLdap.sql.JdbcLdapDBMetaData;
import com.octetstring.jdbcLdap.sql.JdbcLdapPreparedStatement;
import com.octetstring.jdbcLdap.sql.JdbcLdapStatement;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.SqlToLdap;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapInsert;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSelect;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapSqlAbs;
import com.octetstring.jdbcLdap.util.AddPattern;
import com.octetstring.jdbcLdap.util.TableDef;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.directory.DirContext;

public class JndiLdapConnection
implements Connection {
    public static final String IMPL_UPDATE_ENTRY = "UpdateEntry";
    public static final String IMPL_UPDATE = "UPDATE";
    public static final String IMPL_RETRIEVE_RESULTS = "RETRIEVE_RESULTS";
    public static final String IMPL_INSERT = "INSERT";
    public static final String IMPL_DELETE = "DELETE";
    public static final String DSML_BASE_DN = "DSML_BASE_DN";
    public static final String SPML_IMPL = "SPML_IMPL";
    public static final String SPML_BASE_DN = "SPML_BASE_DN";
    public static final String LDAP_COMMA = "\\,";
    public static final String LDAP_EQUALS = "\\=";
    public static final String LDAP_PLUS = "\\+";
    public static final String LDAP_LESS = "\\<";
    public static final String LDAP_GREATER = "\\>";
    public static final String LDAP_SEMI_COLON = "\\;";
    public static final String OBJECT_SCOPE = "objectScope";
    public static final String ONELEVEL_SCOPE = "oneLevelScope";
    public static final String SUBTREE_SCOPE = "subTreeScope";
    public static final String CONCAT_ATTS = "CONCAT_ATTS";
    public static final String EXP_ROWS = "EXP_ROWS";
    public static final String AUTHENTICATION_TYPE = "java.naming.security.authentication";
    public static final String NO_AUTHENTICATION = "none";
    public static final String SIMPLE_AUTHENTICATION = "simple";
    public static final String SEARCH_SCOPE = "SEARCH_SCOPE";
    public static final String CACHE_STATEMENTS = "CACHE_STATEMENTS";
    public static final String PRE_FETCH = "PRE_FETCH";
    public static final String SIZE_LIMIT = "SIZE_LIMIT";
    public static final String TIME_LIMIT = "TIME_LIMIT";
    public static final String NO_SOAP = "NO_SOAP";
    public static final String IGNORE_TRANSACTIONS = "IGNORE_TRANSACTIONS";
    public static final String BACKEND_PACKAGE = "BACKEND_PACKAGE";
    public static final String NO_CONNECTION = "NO_CONNECTION";
    static final String USER = "user";
    static final String PASSWORD = "password";
    static final String SECURE = "secure";
    static final int ELIM_JDBC = 5;
    static final int ELIM_JDBC_DSML = 12;
    static final int ELIM_JDBC_SPML = 12;
    HashMap statements;
    LDAPConnection con;
    Hashtable env;
    boolean cacheStatements;
    boolean expandRow = false;
    String scope;
    String baseDN;
    SqlToLdap sql2ldap;
    boolean concatAtts;
    StringBuffer tmpBuff;
    private boolean ignoreTransactions;
    boolean preFetch;
    private int size;
    private int time;
    private boolean isDsml;
    private boolean isSPML;
    private boolean noSoap;
    HashMap tables;
    private String url;
    private String user;
    private String implPackage;
    private boolean noConnection;
    HashMap implClasses;

    public void cacheStatement(String sql, SqlStore stmt) {
        if (this.cacheStatements()) {
            this.statements.put(sql, stmt);
        }
    }

    public SqlStore getCache(String sql) {
        return (SqlStore)this.statements.get(sql);
    }

    public void setConcatAtts(boolean concat) {
        this.concatAtts = concat;
    }

    public boolean getConcatAtts() {
        return this.concatAtts;
    }

    public DirContext getContext() {
        return null;
    }

    public boolean cacheStatements() {
        return this.cacheStatements;
    }

    public String getSearchScope() {
        return this.scope;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public JndiLdapConnection(LDAPConnection connection) {
        this.statements = new HashMap();
        this.sql2ldap = new SqlToLdap();
        this.env = new Hashtable();
        this.concatAtts = false;
        boolean authFound = false;
        this.tmpBuff = new StringBuffer();
        this.con = connection;
        this.baseDN = "";
        this.cacheStatements = true;
        this.tables = new HashMap();
    }

    public JndiLdapConnection(String url, Properties props) throws SQLException {
        String prop;
        this.url = url;
        this.statements = new HashMap();
        this.sql2ldap = new SqlToLdap();
        this.env = new Hashtable();
        this.concatAtts = false;
        boolean authFound = false;
        this.tmpBuff = new StringBuffer();
        this.ignoreTransactions = false;
        this.isDsml = url.startsWith("jdbc:dsml");
        this.isSPML = url.startsWith("jdbc:spml");
        String spmlImpl = null;
        this.noConnection = false;
        this.implPackage = "com.octetstring.jdbcLdap.jndi";
        Enumeration<?> en = props.propertyNames();
        this.tables = new HashMap();
        String user = null;
        String pass = null;
        this.preFetch = true;
        boolean secure = false;
        boolean isLDAP = url.startsWith("jdbc:ldap");
        this.noSoap = false;
        while (en.hasMoreElements()) {
            prop = (String)en.nextElement();
            if (prop.equalsIgnoreCase(SECURE)) {
                if (props.getProperty(prop) == null || !props.getProperty(prop).equalsIgnoreCase("true")) continue;
                secure = true;
                continue;
            }
            if (!prop.equalsIgnoreCase(NO_CONNECTION) || !props.getProperty(prop).equalsIgnoreCase("true")) continue;
            this.noConnection = true;
        }
        en = props.propertyNames();
        if (isLDAP && !this.noConnection) {
            LDAPUrl ldapUrl;
            this.con = secure ? new LDAPConnection((LDAPSocketFactory)new LDAPJSSESecureSocketFactory()) : new LDAPConnection();
            try {
                ldapUrl = new LDAPUrl(url.substring(5));
                this.con.connect(ldapUrl.getHost(), ldapUrl.getPort());
            }
            catch (MalformedURLException e1) {
                throw new SQLNamingException(e1);
            }
            catch (LDAPException e1) {
                throw new SQLNamingException(e1);
            }
            this.baseDN = ldapUrl.getDN();
            if (this.baseDN == null) {
                this.baseDN = "";
            }
        } else if (this.isDsml) {
            this.con = new DsmlConnection();
            try {
                this.con.connect(url.substring(12), 0);
            }
            catch (LDAPException e1) {
                throw new SQLNamingException(e1);
            }
            this.baseDN = props.getProperty(DSML_BASE_DN, "");
        } else if (this.isSPML) {
            while (en.hasMoreElements()) {
                prop = (String)en.nextElement();
                if (!prop.equalsIgnoreCase(SPML_IMPL)) continue;
                spmlImpl = props.getProperty(prop);
            }
            en = props.propertyNames();
            this.con = new SPMLConnection(spmlImpl);
            try {
                this.con.connect(url.substring(12), 0);
            }
            catch (LDAPException e1) {
                throw new SQLNamingException(e1);
            }
            this.baseDN = props.getProperty(SPML_BASE_DN, "dc=spml,dc=com");
        } else if (this.noConnection) {
            this.con = null;
            this.baseDN = "";
        }
        while (en.hasMoreElements()) {
            prop = (String)en.nextElement();
            if (prop.equalsIgnoreCase(USER)) {
                this.user = user = props.getProperty(prop);
                continue;
            }
            if (prop.equalsIgnoreCase(PASSWORD)) {
                pass = props.getProperty(prop);
                continue;
            }
            if (prop.equalsIgnoreCase(CACHE_STATEMENTS)) {
                this.cacheStatements = props.getProperty(prop).equalsIgnoreCase("true");
                continue;
            }
            if (prop.equalsIgnoreCase(EXP_ROWS)) {
                this.expandRow = props.getProperty(prop).equalsIgnoreCase("true");
                continue;
            }
            if (prop.equalsIgnoreCase(SEARCH_SCOPE)) {
                this.scope = props.getProperty(prop);
                continue;
            }
            if (prop.equalsIgnoreCase(AUTHENTICATION_TYPE)) continue;
            if (prop.equalsIgnoreCase(CONCAT_ATTS)) {
                this.concatAtts = props.getProperty(prop).equalsIgnoreCase("true");
                continue;
            }
            if (prop.equalsIgnoreCase(IGNORE_TRANSACTIONS)) {
                this.ignoreTransactions = props.getProperty(prop).equalsIgnoreCase("true");
                continue;
            }
            if (prop.equalsIgnoreCase(PRE_FETCH)) {
                this.preFetch = PRE_FETCH.equalsIgnoreCase(props.getProperty(prop));
                continue;
            }
            if (prop.equalsIgnoreCase(SIZE_LIMIT)) {
                this.size = Integer.parseInt(props.getProperty(prop));
                continue;
            }
            if (prop.equalsIgnoreCase(NO_SOAP)) {
                this.noSoap = props.getProperty(prop).equalsIgnoreCase("true");
                ((DsmlConnection)this.con).setUseSoap(!this.noSoap);
                continue;
            }
            if (prop.equalsIgnoreCase(TIME_LIMIT)) {
                this.time = Integer.parseInt(props.getProperty(prop));
                if (this.time <= 0) continue;
                LDAPConstraints genconstraints = this.con.getConstraints();
                genconstraints.setTimeLimit(this.time);
                this.con.setConstraints(genconstraints);
                continue;
            }
            if (prop.equalsIgnoreCase("TABLE_DEF")) {
                try {
                    this.generateTables(props.getProperty(prop));
                    continue;
                }
                catch (FileNotFoundException e1) {
                    throw new SQLNamingException(e1);
                }
                catch (IOException e1) {
                    throw new SQLNamingException(e1);
                }
                catch (LDAPException e1) {
                    throw new SQLNamingException(e1);
                }
            }
            if (!prop.equalsIgnoreCase(BACKEND_PACKAGE)) continue;
            this.implPackage = props.getProperty(prop);
        }
        try {
            if (user != null && pass != null && !this.noConnection) {
                this.con.bind(3, user, pass.getBytes());
            }
        }
        catch (LDAPException e) {
            throw new SQLNamingException(e);
        }
        this.implClasses = new HashMap();
        try {
            this.implClasses.put(IMPL_DELETE, Class.forName(this.implPackage + ".Delete").newInstance());
            this.implClasses.put(IMPL_INSERT, Class.forName(this.implPackage + ".Insert").newInstance());
            this.implClasses.put(IMPL_RETRIEVE_RESULTS, Class.forName(this.implPackage + ".RetrieveResults").newInstance());
            this.implClasses.put(IMPL_UPDATE, Class.forName(this.implPackage + ".Update").newInstance());
            this.implClasses.put(IMPL_UPDATE_ENTRY, Class.forName(this.implPackage + ".UpdateEntry").newInstance());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setTransactionIsolation(int param) throws SQLException {
        if (!this.ignoreTransactions) {
            throw new SQLException("LDAP Does Not Support Transactions");
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    public void close() throws SQLException {
        try {
            if (this.con != null) {
                this.con.disconnect();
            }
        }
        catch (LDAPException e) {
            throw new SQLNamingException(e);
        }
    }

    public void commit() throws SQLException {
        if (!this.ignoreTransactions) {
            throw new SQLException("LDAP Does Not Support Transactions");
        }
    }

    public boolean isClosed() throws SQLException {
        return this.con == null || !this.con.isConnectionAlive();
    }

    public String ldapClean(String val) {
        this.tmpBuff.setLength(0);
        int m = val.length();
        block9: for (int i = 0; i < m; ++i) {
            char c = val.charAt(i);
            switch (c) {
                case ',': {
                    this.tmpBuff.append(LDAP_COMMA);
                    continue block9;
                }
                case '=': {
                    this.tmpBuff.append(LDAP_EQUALS);
                    continue block9;
                }
                case '+': {
                    this.tmpBuff.append(LDAP_PLUS);
                    continue block9;
                }
                case '<': {
                    this.tmpBuff.append(LDAP_LESS);
                    continue block9;
                }
                case '>': {
                    this.tmpBuff.append(LDAP_GREATER);
                    continue block9;
                }
                case '#': {
                    this.tmpBuff.append("\\#");
                    continue block9;
                }
                case ';': {
                    this.tmpBuff.append(LDAP_SEMI_COLON);
                    continue block9;
                }
                default: {
                    this.tmpBuff.append(c);
                }
            }
        }
        System.out.println("cleaned? : " + this.tmpBuff.toString());
        return this.tmpBuff.toString();
    }

    public void setCatalog(String str) throws SQLException {
    }

    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setHoldability(int param) throws SQLException {
    }

    public void rollback() throws SQLException {
        if (!this.ignoreTransactions) {
            throw new SQLException("LDAP Does Not Support Transactions");
        }
    }

    public String getCatalog() throws SQLException {
        return this.baseDN;
    }

    public PreparedStatement prepareStatement(String str, int param) throws SQLException {
        return new JdbcLdapPreparedStatement(str, this);
    }

    public PreparedStatement prepareStatement(String str, int param, int param2, int param3) throws SQLException {
        return new JdbcLdapPreparedStatement(str, this);
    }

    public PreparedStatement prepareStatement(String str, int param, int param2) throws SQLException {
        return new JdbcLdapPreparedStatement(str, this);
    }

    public void setAutoCommit(boolean param) throws SQLException {
        if (!this.ignoreTransactions) {
            throw new SQLException("LDAP Does Not Support Transactions");
        }
    }

    public CallableStatement prepareCall(String str) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String str, int[] values) throws SQLException {
        return new JdbcLdapPreparedStatement(str, this);
    }

    public void setTypeMap(Map map) throws SQLException {
    }

    public int getHoldability() throws SQLException {
        return -1;
    }

    public Savepoint setSavepoint(String str) throws SQLException {
        return null;
    }

    public Statement createStatement(int param, int param1, int param2) throws SQLException {
        return new JdbcLdapStatement(this);
    }

    public Statement createStatement(int param, int param1) throws SQLException {
        return new JdbcLdapStatement(this);
    }

    public Statement createStatement() throws SQLException {
        return new JdbcLdapStatement(this);
    }

    public String nativeSQL(String str) throws SQLException {
        return this.sql2ldap.convertToLdap(str, null);
    }

    public String nativeSQL(String str, HashMap fieldMap) throws SQLException {
        return this.sql2ldap.convertToLdap(str, fieldMap);
    }

    public CallableStatement prepareCall(String str, int param, int param2) throws SQLException {
        throw new SQLException("LDAP Does Not Support Stored Procedures");
    }

    public CallableStatement prepareCall(String str, int param, int param2, int param3) throws SQLException {
        throw new SQLException("LDAP Does Not Support Stored Procedures");
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String str) throws SQLException {
        return new JdbcLdapPreparedStatement(str, this);
    }

    public void setReadOnly(boolean param) throws SQLException {
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    public PreparedStatement prepareStatement(String str, String[] str1) throws SQLException {
        return new JdbcLdapPreparedStatement(str, this);
    }

    public int getTransactionIsolation() throws SQLException {
        return -1;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new JdbcLdapDBMetaData(this);
    }

    public void clearWarnings() throws SQLException {
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (!this.ignoreTransactions) {
            throw new SQLException("LDAP Does Not Support Transactions");
        }
    }

    public boolean isExpandRow() {
        return this.expandRow;
    }

    public void setExpandRow(boolean b) {
        this.expandRow = b;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public LDAPConnection getConnection() {
        return this.con;
    }

    public String getBaseContext() {
        return this.baseDN;
    }

    public static String getRealBase(JdbcLdapSqlAbs sql) {
        boolean useComma;
        String localBase = sql instanceof JdbcLdapInsert ? ((JdbcLdapInsert)sql).getDistinguishedName() : sql.getBaseContext();
        String base = sql.getConnectionBase();
        boolean appendBase = base != null && base.trim().length() != 0 && !localBase.endsWith(base);
        boolean bl = useComma = localBase.trim().length() != 0;
        String useBase = appendBase ? localBase + (useComma ? "," : "") + base : localBase;
        return useBase;
    }

    public LDAPSearchResults search(String SQL) throws SQLException {
        JdbcLdapSelect search = new JdbcLdapSelect();
        search.init(this, SQL);
        return (LDAPSearchResults)search.executeQuery();
    }

    public boolean isPreFetch() {
        return this.preFetch;
    }

    public void setPreFetch(boolean preFetch) {
        this.preFetch = preFetch;
    }

    public void setMaxSizeLimit(int size) {
        this.size = size;
    }

    public void setMaxTimeLimit(int time) {
        this.time = time;
    }

    public int getMaxSizeLimit() {
        return this.size;
    }

    public int getMaxTimeLimit() {
        return this.time;
    }

    public boolean isDSML() {
        return this.isDsml;
    }

    public boolean isSPML() {
        return this.isSPML;
    }

    private void generateTables(String propsPath) throws FileNotFoundException, IOException, LDAPException {
        Properties props = new Properties();
        props.load(new FileInputStream(propsPath));
        int numTables = Integer.parseInt(props.getProperty("numTables"));
        for (int i = 0; i < numTables; ++i) {
            String name = props.getProperty("table." + i + ".name");
            String base = props.getProperty("table." + i + ".base");
            String scope = props.getProperty("table." + i + ".scope");
            String objectClasses = props.getProperty("table." + i + ".ocs");
            StringTokenizer toker = new StringTokenizer(objectClasses, ",", false);
            String[] ocs = new String[toker.countTokens()];
            int j = 0;
            while (toker.hasMoreTokens()) {
                ocs[j++] = toker.nextToken();
            }
            String addPattern = props.getProperty("table." + i + ".addPattern");
            toker = new StringTokenizer(addPattern, "|");
            HashMap<String, Object> addPatternMap = new HashMap<String, Object>();
            while (toker.hasMoreTokens()) {
                String pattern = toker.nextToken();
                HashSet<String> dontAddSet = new HashSet<String>();
                String defOC = null;
                if (pattern.indexOf(35) != -1) {
                    String dontAdd = pattern.substring(pattern.indexOf(35) + 1);
                    StringTokenizer tokda = new StringTokenizer(dontAdd, ",");
                    while (tokda.hasMoreTokens()) {
                        dontAddSet.add(tokda.nextToken().toUpperCase());
                    }
                    pattern = pattern.substring(0, pattern.indexOf(35));
                }
                if (pattern.indexOf(38) != -1) {
                    defOC = pattern.substring(pattern.indexOf(38) + 1);
                    pattern = pattern.substring(0, pattern.indexOf(38));
                }
                AddPattern pat = new AddPattern(pattern, dontAddSet, defOC);
                StringTokenizer tokpat = new StringTokenizer(pattern, ",");
                HashMap<String, Object> curr = addPatternMap;
                while (tokpat.hasMoreTokens()) {
                    String node = tokpat.nextToken();
                    Object o = curr.get(node);
                    if (o != null) continue;
                    if (tokpat.hasMoreTokens()) {
                        HashMap n = new HashMap();
                        curr.put(node, n);
                        curr = n;
                        continue;
                    }
                    curr.put(node, pat);
                }
            }
            TableDef tbl = new TableDef(name, base, scope, ocs, this.con, addPatternMap);
            this.tables.put(name, tbl);
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public Map getTableDefs() {
        return this.tables;
    }

    public HashMap getImplClasses() {
        return this.implClasses;
    }

    public boolean isNoCon() {
        return this.noConnection;
    }
}

