/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.jndi;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.octetstring.jdbcLdap.backend.DirectoryInsert;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.jndi.SQLNamingException;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapInsert;
import com.octetstring.jdbcLdap.util.Pair;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;

public class Insert
implements DirectoryInsert {
    public void doInsert(JdbcLdapInsert insert) throws SQLException {
        DirContext con = insert.getContext();
        BasicAttributes atts = new BasicAttributes();
        SqlStore store = insert.getSqlStore();
        String[] fields = store.getFields();
        String[] vals = insert.getVals();
        LinkedList fieldsMap = store.getFieldsMap();
        try {
            for (Pair p : fieldsMap) {
                String field = p.getName();
                if (atts.get(field) == null) {
                    atts.put(new BasicAttribute(field, p.getValue()));
                    continue;
                }
                ((BasicAttribute)atts.get(field)).add(p.getValue());
            }
            con.createSubcontext(insert.getDistinguishedName(), (Attributes)atts);
        }
        catch (NamingException ne) {
            throw new SQLNamingException(ne);
        }
    }

    public void doInsertJldap(JdbcLdapInsert insert) throws SQLException {
        LDAPConnection con = insert.getConnection();
        BasicAttributes atts = new BasicAttributes();
        SqlStore store = insert.getSqlStore();
        String[] fields = store.getFields();
        String[] vals = insert.getVals();
        LinkedList fieldsMap = store.getFieldsMap();
        LDAPAttributeSet attribs = new LDAPAttributeSet();
        try {
            LDAPAttribute attrib;
            Iterator it = fieldsMap.iterator();
            Set dontAdd = insert.getSqlStore().getDontAdd();
            boolean usedOC = false;
            while (it.hasNext()) {
                Pair p = (Pair)it.next();
                if (dontAdd != null && dontAdd.contains(p.getNameUpperCase())) continue;
                String field = p.getName();
                if (field.equalsIgnoreCase("objectClass")) {
                    usedOC = true;
                }
                if ((attrib = attribs.getAttribute(field)) == null) {
                    attrib = new LDAPAttribute(field);
                    attribs.add((Object)attrib);
                }
                attrib.addValue(p.getValue());
            }
            if (!usedOC && insert.getSqlStore().getDefOC() != null) {
                attrib = new LDAPAttribute("objectClass");
                attrib.addValue(insert.getSqlStore().getDefOC());
                attribs.add((Object)attrib);
            }
            con.add(new LDAPEntry(JndiLdapConnection.getRealBase(insert), attribs));
        }
        catch (LDAPException ne) {
            throw new SQLNamingException(ne);
        }
    }
}

