/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.jndi;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class FieldStore {
    static final String DECIMAL = ".";
    static final String DASH = "-";
    static final String COLON = ":";
    String name;
    int numVals;
    int type;
    boolean determined;

    public FieldStore() {
        this.numVals = 0;
        this.determined = false;
    }

    public FieldStore(String name, int vals) {
        this.name = name;
        this.numVals = vals;
        this.determined = false;
    }

    public String getName() {
        return this.name;
    }

    public int getNumVals() {
        return this.numVals;
    }

    public int getType() {
        if (this.determined) {
            return this.type;
        }
        return 12;
    }

    public void determineType(String val) {
        if (this.determined || val == null || val.length() == 0) {
            return;
        }
        if (Character.isDigit(val.charAt(0))) {
            this.mightNumeric(val);
        } else {
            this.type = 12;
            this.determined = true;
        }
    }

    protected void mightNumeric(String val) {
        int pos1 = val.indexOf(DASH);
        int pos2 = val.indexOf(COLON);
        if (pos1 != -1 || pos2 != -1) {
            this.mightDateTime(val, pos1, pos2);
        } else if (val.indexOf(DECIMAL) != -1) {
            try {
                Double.valueOf(val);
                this.type = 8;
                this.determined = true;
            }
            catch (Exception e) {
                this.type = 12;
                this.determined = true;
            }
        } else {
            try {
                long ltmp = Long.parseLong(val);
                this.type = 4;
                this.determined = true;
            }
            catch (Exception e) {
                this.type = 12;
                this.determined = true;
            }
        }
    }

    protected void mightDateTime(String val, int pos1, int pos2) {
        if (pos1 != -1 && pos2 != -1 && pos1 < pos2) {
            try {
                Timestamp.valueOf(val);
                this.type = 93;
                this.determined = true;
            }
            catch (IllegalArgumentException e) {
                this.type = 12;
                this.determined = true;
            }
        } else if (pos1 != -1 || pos2 != -1) {
            if (pos1 == -1) {
                try {
                    Time.valueOf(val);
                    this.type = 92;
                    this.determined = true;
                }
                catch (IllegalArgumentException e) {
                    this.type = 12;
                    this.determined = true;
                }
            } else {
                try {
                    Date.valueOf(val);
                    this.type = 91;
                    this.determined = true;
                }
                catch (IllegalArgumentException e) {
                    this.type = 12;
                    this.determined = true;
                }
            }
        } else {
            this.type = 12;
            this.determined = true;
        }
    }
}

