/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.jndi;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchResults;
import com.octetstring.jdbcLdap.backend.DirectoryDelete;
import com.octetstring.jdbcLdap.backend.DirectoryRetrieveResults;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.jndi.SQLNamingException;
import com.octetstring.jdbcLdap.sql.SqlStore;
import com.octetstring.jdbcLdap.sql.statements.JdbcLdapDelete;
import java.sql.SQLException;

public class Delete
implements DirectoryDelete {
    public int doDeleteJldap(JdbcLdapDelete del) throws SQLException {
        DirectoryRetrieveResults res = (DirectoryRetrieveResults)del.getCon().getImplClasses().get("RETRIEVE_RESULTS");
        LDAPConnection con = del.getConnection();
        StringBuffer buf = new StringBuffer();
        SqlStore store = del.getSqlStore();
        int count = 0;
        if (store.getSimple()) {
            try {
                con.delete(JndiLdapConnection.getRealBase(del));
            }
            catch (LDAPException ne) {
                throw new SQLNamingException(ne);
            }
            return 1;
        }
        try {
            LDAPSearchResults enumer = res.searchUpInsJldap(del);
            while (enumer.hasMore()) {
                LDAPEntry entry = enumer.next();
                con.delete(entry.getDN());
                ++count;
            }
            return count;
        }
        catch (LDAPException ne) {
            throw new SQLNamingException(ne);
        }
    }
}

