/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.novell.ldap.LDAPUrl;
import com.novell.ldap.util.DN;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TreeObject {
    public static final Pattern refPat = Pattern.compile("^cn=Referral\\[(.*)\\].*$", 2);
    TreeObject parent;
    String name;
    String displayName;
    String base;
    String url;
    HashMap attributes;
    HashMap children;
    boolean getSQL = true;
    boolean isRef;
    int conId;
    JndiLdapConnection con;

    public TreeObject(String name, TreeObject parent, String topBase, boolean getSQL, HashMap children, HashMap attributes) {
        this(name, parent, topBase, getSQL);
        this.children = children;
        this.attributes = attributes;
        this.conId = 0;
    }

    public TreeObject(String name, TreeObject parent, String topBase, boolean getSQL) {
        this(name, parent, topBase);
        this.getSQL = getSQL;
        this.children = new HashMap();
        this.attributes = new HashMap();
        this.conId = 0;
    }

    public TreeObject(String name, TreeObject parent, String topBase) {
        if (parent == null || parent.getName().equalsIgnoreCase("RootDSE")) {
            if (name.trim().length() == 0) {
                this.base = name;
                this.name = "RootDSE";
            } else {
                this.base = name;
                this.name = name;
            }
        } else if (name.indexOf(44) == -1) {
            name = "RootDSE";
            this.base = " ";
        } else {
            this.name = new DN(name).explodeDN(false)[0];
            this.base = name.endsWith(parent.getBase()) || parent.getName().equalsIgnoreCase("RootDSE") ? name : (name.lastIndexOf(topBase) == -1 ? name : name.substring(name.indexOf(44) + 1, name.lastIndexOf(topBase)));
        }
        Matcher m = refPat.matcher(name);
        this.isRef = m.matches();
        if (this.isRef && this.getSQL) {
            this.url = m.group(1);
            this.displayName = name;
            try {
                LDAPUrl ldapUrl = new LDAPUrl(this.url);
                this.name = ldapUrl.getDN();
                this.base = name.substring(name.lastIndexOf(93) + 2);
                if (this.base.indexOf(63) != -1) {
                    this.base = this.base.substring(0, this.base.indexOf(63));
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            this.displayName = this.name;
        }
        this.parent = parent;
        this.conId = 0;
    }

    public TreeObject getParent() {
        return this.parent;
    }

    public String toString() {
        return this.displayName;
    }

    public String getBase() {
        return this.base;
    }

    public TreeObject getChild(String name) {
        return (TreeObject)this.children.get(name);
    }

    public void addChild(String name, TreeObject to) {
        this.children.put(name, to);
    }

    public boolean isRef() {
        return this.isRef;
    }

    public JndiLdapConnection getRefCon() {
        return this.con;
    }

    public void setRefConnection(JndiLdapConnection con) {
        this.con = con;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getRefUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public void setConId(int id) {
        this.conId = id;
    }

    public int getConId() {
        return this.conId;
    }
}

