/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.octetstring.jdbcLdap.browser.Browser;
import com.octetstring.jdbcLdap.browser.JdbcLdapBrowser;
import com.octetstring.jdbcLdap.browser.JdbcLdapBrowserApp;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import com.octetstring.jdbcLdap.util.LDIF;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.ResultSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

class ToLdif
extends SelectionAdapter {
    JdbcLdapBrowserApp app;

    public ToLdif(JdbcLdapBrowserApp app) {
        this.app = app;
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.app.tabs.getSelection() == null) {
            MessageDialog.openError((Shell)this.app.shell, (String)"Error", (String)"No Browsers Oppened");
            return;
        }
        JdbcLdapBrowser browser = ((Browser)this.app.browsers.get((Object)this.app.tabs.getSelection().getText())).browser;
        if (browser.isDB) {
            MessageDialog.openError((Shell)this.app.shell, (String)"Can not generate LDIF", (String)"LDIF can only be generated by directory services");
            return;
        }
        String SQL = browser.SQL.getText();
        if (SQL == null || !SQL.toLowerCase().startsWith("select")) {
            MessageDialog.openError((Shell)this.app.shell, (String)"Error", (String)"No Query Entered");
            return;
        }
        FileDialog fd = new FileDialog(this.app.shell, 8192);
        fd.setFilterExtensions(new String[]{"ldif"});
        fd.setText("Save LDIF To");
        fd.open();
        String saveTo = fd.getFileName();
        try {
            JndiLdapConnection con = (JndiLdapConnection)browser.getConnection();
            con.setExpandRow(false);
            con.setConcatAtts(true);
            SQL = browser.insertScope(SQL);
            ResultSet rs = con.createStatement().executeQuery(SQL);
            LDIF ldif = new LDIF(rs, "DN", false);
            con.setExpandRow(true);
            con.setConcatAtts(false);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(new File(fd.getFilterPath() + "/" + fd.getFileName()))));
            pw.println(ldif.toString());
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.app.shell, (String)"Query Could Not Be Executed", (String)e.toString());
        }
    }
}

