/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.octetstring.jdbcLdap.browser.Browser;
import com.octetstring.jdbcLdap.browser.JdbcLdapBrowser;
import com.octetstring.jdbcLdap.browser.JdbcLdapBrowserApp;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

class ToCSV
extends SelectionAdapter {
    JdbcLdapBrowserApp app;

    public ToCSV(JdbcLdapBrowserApp app) {
        this.app = app;
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.app.tabs.getSelection() == null) {
            MessageDialog.openError((Shell)this.app.shell, (String)"Error", (String)"No Browsers Oppened");
            return;
        }
        JdbcLdapBrowser browser = ((Browser)this.app.browsers.get((Object)this.app.tabs.getSelection().getText())).browser;
        String SQL = browser.SQL.getText().replace('\n', ' ');
        if (SQL == null || !SQL.toLowerCase().startsWith("select")) {
            MessageDialog.openError((Shell)this.app.shell, (String)"Error", (String)"No Query Entered");
            return;
        }
        FileDialog fd = new FileDialog(this.app.shell, 8192);
        fd.setFilterExtensions(new String[]{"csv"});
        fd.setText("Save CSV To");
        fd.open();
        String saveTo = fd.getFileName();
        try {
            int i;
            Connection con = browser.getConnection();
            if (con instanceof JndiLdapConnection) {
                ((JndiLdapConnection)con).setExpandRow(false);
                ((JndiLdapConnection)con).setConcatAtts(true);
                SQL = browser.insertScope(SQL);
                ((JndiLdapConnection)con).setExpandRow(true);
                ((JndiLdapConnection)con).setConcatAtts(false);
            }
            ResultSet rs = con.createStatement().executeQuery(SQL);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(new File(fd.getFilterPath() + "/" + fd.getFileName()))));
            ResultSetMetaData md = rs.getMetaData();
            int m = md.getColumnCount();
            for (i = 1; i <= m; ++i) {
                pw.print("\"" + md.getColumnName(i) + "\"");
                if (i >= m) continue;
                pw.print(",");
            }
            pw.println();
            while (rs.next()) {
                m = md.getColumnCount();
                for (i = 1; i <= m; ++i) {
                    pw.print("\"" + rs.getString(md.getColumnName(i)) + "\"");
                    if (i >= m) continue;
                    pw.print(",");
                }
                pw.println();
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.app.shell, (String)"Query Could Not Be Executed", (String)e.toString());
        }
    }
}

