/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.novell.ldap.LDAPException;
import com.novell.ldap.rfc2251.RfcFilter;
import com.novell.ldap.util.Base64;
import com.octetstring.jdbcLdap.browser.SearchDialog;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class SearchOKPressed
implements SelectionListener {
    Text base;
    Text attribs;
    Text filter;
    Button baseScope;
    Button oneScope;
    Button subScope;
    SearchDialog search;

    public SearchOKPressed(Text base, Text attribs, Button baseScope, Button oneScope, Button subScope, SearchDialog search, Text filter) {
        this.base = base;
        this.attribs = attribs;
        this.baseScope = baseScope;
        this.oneScope = oneScope;
        this.subScope = subScope;
        this.search = search;
        this.filter = filter;
    }

    public void widgetSelected(SelectionEvent e) {
        String SQL = "SELECT ";
        String attribs = this.attribs.getText();
        attribs = attribs.trim().length() == 0 || attribs.indexOf(42) != -1 ? "*" : attribs + ",DN";
        SQL = SQL + " " + attribs + " FROM ";
        SQL = this.baseScope.getSelection() ? SQL + "objectScope;" : (this.oneScope.getSelection() ? SQL + "oneLevelScope;" : SQL + "subTreeScope;");
        try {
            SQL = SQL + this.base.getText() + " " + this.filterToWhere(this.filter.getText());
        }
        catch (IndexOutOfBoundsException err) {
            err.printStackTrace();
            MessageDialog.openError((Shell)this.search.shell, (String)"Invalid Filter", (String)"Bad Search Filter");
            return;
        }
        this.search.sql = SQL;
        this.search.shell.close();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private static String byteString(byte[] value) {
        String toReturn = null;
        if (Base64.isValidUTF8((byte[])value, (boolean)true)) {
            try {
                toReturn = new String(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Default JVM does not support UTF-8 encoding" + e);
            }
        } else {
            StringBuffer binary = new StringBuffer();
            for (int i = 0; i < value.length; ++i) {
                if (value[i] >= 0) {
                    binary.append("\\0");
                    binary.append(Integer.toHexString(value[i]));
                    continue;
                }
                binary.append("\\" + Integer.toHexString(value[i]).substring(6));
            }
            toReturn = binary.toString();
        }
        return toReturn;
    }

    private void stringFilter(Iterator itr, StringBuffer filter) {
        int op = -1;
        String comp = null;
        boolean isFirst = true;
        while (itr.hasNext()) {
            Object filterpart = itr.next();
            if (filterpart instanceof Integer) {
                op = (Integer)filterpart;
                switch (op) {
                    case 0: {
                        comp = " AND ";
                        break;
                    }
                    case 1: {
                        comp = " OR ";
                        break;
                    }
                    case 2: {
                        filter.append(" NOT ");
                        break;
                    }
                    case 3: {
                        filter.append((String)itr.next());
                        filter.append("='");
                        byte[] value = (byte[])itr.next();
                        filter.append(SearchOKPressed.byteString(value)).append('\'');
                        if (comp == null || !itr.hasNext()) break;
                        filter.append(comp);
                        break;
                    }
                    case 5: {
                        filter.append((String)itr.next());
                        filter.append(">=");
                        byte[] value = (byte[])itr.next();
                        filter.append(SearchOKPressed.byteString(value));
                        if (comp == null || !itr.hasNext()) break;
                        filter.append(comp);
                        break;
                    }
                    case 6: {
                        filter.append((String)itr.next());
                        filter.append("<=");
                        byte[] value = (byte[])itr.next();
                        filter.append(SearchOKPressed.byteString(value));
                        if (comp == null || !itr.hasNext()) break;
                        filter.append(comp);
                        break;
                    }
                    case 7: {
                        filter.append((String)itr.next());
                        filter.append(" IS NOT NULL ");
                        if (comp == null || !itr.hasNext()) break;
                        filter.append(comp);
                        break;
                    }
                    case 8: {
                        filter.append((String)itr.next());
                        filter.append("~=");
                        byte[] value = (byte[])itr.next();
                        filter.append(SearchOKPressed.byteString(value));
                        if (comp == null || !itr.hasNext()) break;
                        filter.append(comp);
                        break;
                    }
                    case 9: {
                        String oid = (String)itr.next();
                        filter.append((String)itr.next());
                        filter.append(':');
                        filter.append(oid);
                        filter.append(":=");
                        filter.append((String)itr.next());
                        if (comp == null || !itr.hasNext()) break;
                        filter.append(comp);
                        break;
                    }
                    case 4: {
                        filter.append((String)itr.next());
                        filter.append(" LIKE '");
                        boolean noStarLast = false;
                        while (itr.hasNext()) {
                            op = (Integer)itr.next();
                            switch (op) {
                                case 0: {
                                    filter.append((String)itr.next());
                                    filter.append('%');
                                    noStarLast = false;
                                    break;
                                }
                                case 1: {
                                    if (noStarLast) {
                                        filter.append('%');
                                    }
                                    filter.append((String)itr.next());
                                    filter.append('%');
                                    noStarLast = false;
                                    break;
                                }
                                case 2: {
                                    if (noStarLast) {
                                        filter.append('%');
                                    }
                                    filter.append((String)itr.next());
                                }
                            }
                            filter.append('\'');
                            if (comp == null || !itr.hasNext()) continue;
                            if (isFirst) {
                                isFirst = false;
                                continue;
                            }
                            filter.append(comp);
                        }
                        break;
                    }
                }
            } else if (filterpart instanceof Iterator) {
                this.stringFilter((Iterator)filterpart, filter);
            }
            if (comp == null || !itr.hasNext()) continue;
            if (isFirst) {
                isFirst = false;
                filter.append('(');
                continue;
            }
            filter.append(comp);
        }
        if (comp != null) {
            filter.append(')');
        }
    }

    String filterToWhere(String filter) {
        if (filter.trim().length() == 0 || filter.trim().equalsIgnoreCase("(objectClass=*)") || filter.trim().equalsIgnoreCase("objectClass=*")) {
            return "";
        }
        String where = "";
        try {
            RfcFilter rfcFilter = new RfcFilter(filter.trim());
            StringBuffer buff = new StringBuffer();
            this.stringFilter(rfcFilter.getFilterIterator(), buff);
            where = buff.toString();
        }
        catch (LDAPException e) {
            e.printStackTrace();
        }
        return " WHERE " + where;
    }
}

