/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.novell.ldap.LDAPDN;
import com.novell.ldap.util.DN;
import com.octetstring.jdbcLdap.browser.JdbcLdapBrowser;
import com.octetstring.jdbcLdap.browser.TreeObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ResultLoader {
    JdbcLdapBrowser browser;
    String scope;
    LinkedList rows;

    public ResultLoader(JdbcLdapBrowser browser) throws SQLException {
        this.browser = browser;
        this.scope = "";
    }

    private void addToTree(HashMap entrys, TreeObject root, ResultSet rs) throws SQLException {
        String name = rs.getString("DN");
        TreeObject to = (TreeObject)entrys.get(name);
        if (to == null) {
            String nname;
            if (root.getName().equalsIgnoreCase("RootDSE")) {
                nname = name;
            } else if (name.lastIndexOf(root.toString()) == -1) {
                nname = "cn=Unknown";
            } else {
                nname = name.substring(0, name.lastIndexOf(root.toString()));
                if (nname.endsWith(",")) {
                    nname = nname.substring(0, nname.length() - 1);
                }
            }
            DN dn = new DN(nname);
            Iterator it = dn.getRDNs().iterator();
            String[] dnparts = dn.explodeDN(false);
            TreeObject tmp = root;
            TreeObject parent = null;
            for (int i = dnparts.length - 1; i > 0; --i) {
                parent = tmp;
                if ((tmp = tmp.getChild(dnparts[i])) != null) continue;
                String fname = "";
                int m = dnparts.length;
                for (int j = i; j < m; ++j) {
                    fname = fname + LDAPDN.escapeRDN((String)dnparts[j]) + ",";
                }
                fname = !root.getName().equalsIgnoreCase("RootDSE") ? fname + root.toString() : fname.substring(0, fname.length() - 1);
                tmp = new TreeObject(fname, parent, root.getBase(), false);
                parent.addChild(dnparts[i], tmp);
            }
            to = new TreeObject(name, tmp, root.getBase(), false);
            tmp.addChild(dnparts[0], to);
            entrys.put(name, to);
        }
        HashMap attribs = to.attributes;
        ResultSetMetaData rsmd = rs.getMetaData();
        int m = rsmd.getColumnCount();
        for (int i = 1; i <= m; ++i) {
            LinkedList attribVals;
            String attribname = rsmd.getColumnName(i);
            String val = rs.getString(attribname);
            if (attribs.containsKey(attribname)) {
                attribVals = (LinkedList)attribs.get(attribname);
                if (attribVals.contains(val)) continue;
                attribVals.add(val);
                continue;
            }
            attribVals = new LinkedList();
            attribVals.add(val);
            attribs.put(attribname, attribVals);
        }
    }

    public void loadResults(String sql, Table table, TreeViewer tv) throws SQLException {
        Connection con = this.browser.getConnection();
        Statement stmt = this.browser.getConnection().createStatement();
        this.rows = new LinkedList();
        HashMap<String, TreeObject> entries = new HashMap<String, TreeObject>();
        TreeObject root = null;
        if (!this.browser.isDB) {
            root = new TreeObject(this.browser.baseDN, null, this.browser.baseDN, false);
            entries.put(this.browser.baseDN, root);
        }
        try {
            int start;
            TableColumn tc;
            ResultSet rs = stmt.executeQuery(sql);
            int maxCols = 1;
            if (!this.browser.isDB) {
                tc = new TableColumn(table, 16384);
                tc.setText("DN");
                tc.setWidth(50);
                start = 2;
            } else {
                start = 1;
                maxCols = 0;
            }
            while (rs.next()) {
                HashMap row = new HashMap();
                this.rows.add(row);
                TableItem tbli = null;
                if (!this.browser.isDB) {
                    this.addToTree(entries, root, rs);
                }
                tbli = new TableItem(table, 0);
                ResultSetMetaData rsmd = rs.getMetaData();
                String value = null;
                if (!this.browser.isDB) {
                    value = rs.getString("DN");
                    value = value != null ? value : "null";
                    tbli.setText(0, value);
                }
                int m = rsmd.getColumnCount();
                for (int i = start; i <= m; ++i) {
                    if (rsmd.getColumnName(i).equalsIgnoreCase("DN")) continue;
                    if (i > maxCols) {
                        tc = new TableColumn(table, 16384);
                        tc.setText(rsmd.getColumnName(i));
                        tc.setWidth(50);
                        maxCols = i;
                    }
                    value = (value = rs.getString(rsmd.getColumnName(i))) != null ? value : "null";
                    tbli.setText(i - 1, value);
                }
            }
            if (!this.browser.isDB) {
                tv.setInput((Object)root);
            }
        }
        catch (SQLException e) {
            MessageDialog.openError((Shell)table.getShell(), (String)"Error Occurred", (String)e.toString());
            e.printStackTrace();
        }
        tv.expandAll();
    }

    public LinkedList getTableView() {
        return this.rows;
    }

    public TreeObject getTreeView() {
        return null;
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.browser.getConnection().createStatement().executeUpdate(sql);
    }
}

