/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.octetstring.jdbcLdap.browser.ConnectionInfo;
import com.octetstring.jdbcLdap.browser.ConnectionStore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;

class ManageConfig
extends SelectionAdapter {
    ConnectionInfo cons;
    boolean add;

    public ManageConfig(boolean add, ConnectionInfo cons) {
        this.cons = cons;
        this.add = add;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof Combo) {
            ConnectionStore cs = this.cons.configs.getConnectionInfo(this.cons.name.getText());
            if (cs == null) {
                return;
            }
            this.cons.server.setText(cs.server != null ? cs.server : "");
            this.cons.port.setText(cs.port != null ? cs.port : "");
            this.cons.base.setText(cs.base != null ? cs.base : "");
            this.cons.user.setText(cs.user != null ? cs.user : "");
            this.cons.password.setText(cs.pass != null ? cs.pass : "");
            this.cons.dsml.setSelection(cs.isDsml);
            this.cons.followReferrals.setSelection(cs.followReferrals);
            this.cons.ssl.setSelection(cs.isSSL);
            this.cons.spml.setSelection(cs.isSpml);
            this.cons.ldap.setSelection(!cs.isSpml && !cs.isDsml && !cs.isJDBC);
            if (this.cons.jdbc.getSelection()) {
                this.cons.serverlabel.setText("JDBC Driver ");
                this.cons.serverlabel.setText("JDBC URL ");
            }
            this.cons.extraURL.setText(cs.extraUrl);
        } else {
            String name = null;
            if (this.add) {
                try {
                    name = this.cons.name.getText();
                    this.cons.configs.saveConfig(this.cons.name.getText(), this.cons.user.getText(), this.cons.password.getText(), this.cons.server.getText(), this.cons.port.getText(), this.cons.base.getText(), this.cons.dsml.getSelection(), this.cons.followReferrals.getSelection(), this.cons.ssl.getSelection(), this.cons.spml.getSelection(), this.cons.jdbc.getSelection(), this.cons.extraURL.getText());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MessageDialog.openError((Shell)this.cons.shell, (String)"Error Occurred When Loading Config", (String)e1.toString());
                }
            } else {
                try {
                    this.cons.configs.deleteConfig(this.cons.name.getText());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MessageDialog.openError((Shell)this.cons.shell, (String)"Error Occurred When Deleting Config", (String)e1.toString());
                }
            }
            this.cons.loadNames();
            if (name != null) {
                this.cons.name.setText(name);
            }
        }
    }
}

