/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.octetstring.jdbcLdap.browser.ConnectionInfo;
import com.octetstring.jdbcLdap.browser.ConnectionStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;

class LoadCfg
implements PaintListener,
SelectionListener,
ModifyListener {
    ConnectionInfo cons;
    String current = "";

    public LoadCfg(ConnectionInfo cons) {
        this.cons = cons;
    }

    public void paintControl(PaintEvent e) {
        this.loadConfig();
    }

    private void loadConfig() {
        String curr = this.cons.name.getText();
        if (!curr.equals(this.current)) {
            this.current = curr;
            ConnectionStore cs = this.cons.configs.getConnectionInfo(this.current);
            if (cs == null) {
                return;
            }
            this.cons.server.setText(cs.server != null ? cs.server : "");
            this.cons.port.setText(cs.port != null ? cs.port : "");
            this.cons.base.setText(cs.base != null ? cs.base : "");
            this.cons.user.setText(cs.user != null ? cs.user : "");
            this.cons.password.setText(cs.pass != null ? cs.pass : "");
            this.cons.pass2.setText(cs.pass != null ? cs.pass : "");
            this.cons.dsml.setSelection(cs.isDsml);
            this.cons.followReferrals.setSelection(cs.followReferrals);
            this.cons.ssl.setSelection(cs.isSSL);
            this.cons.spml.setSelection(cs.isSpml);
            this.cons.ldap.setSelection(!cs.isSpml && !cs.isDsml && !cs.isJDBC);
            this.cons.jdbc.setSelection(cs.isJDBC);
            this.cons.port.setEnabled(!this.cons.dsml.getSelection() && !this.cons.spml.getSelection());
            this.cons.ssl.setEnabled(!this.cons.dsml.getSelection() && !this.cons.spml.getSelection() && !this.cons.jdbc.getSelection());
            if (this.cons.spml.getSelection() || this.cons.jdbc.getSelection()) {
                this.cons.base.setEnabled(false);
                this.cons.fetchDns.setSelection(false);
            }
            if (this.cons.jdbc.getSelection()) {
                this.cons.serverlabel.setText("JDBC Driver ");
                this.cons.serverlabel.setText("JDBC URL ");
            }
            this.cons.extraURL.setText(cs.extraUrl);
            Control[] ctls = this.cons.shell.getChildren();
            int m = ctls.length;
            for (int i = 0; i < m; ++i) {
                ctls[i].redraw();
            }
            this.cons.shell.redraw();
        }
    }

    public void widgetSelected(SelectionEvent arg0) {
        this.loadConfig();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void modifyText(ModifyEvent arg0) {
        this.loadConfig();
    }
}

