/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.octetstring.jdbcLdap.browser.JdbcLdapBrowser;
import com.octetstring.jdbcLdap.browser.JdbcTreeObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class JdbcTree
implements ITreeContentProvider,
ILabelProvider {
    public Object[] getChildren(Object arg0) {
        try {
            JdbcTreeObject treeObj = (JdbcTreeObject)arg0;
            switch (treeObj.getType()) {
                case 0: {
                    Object[] ret = this.getSchemas(treeObj);
                    if (ret == null) {
                        return this.getTables(null, treeObj);
                    }
                    return ret;
                }
                case 1: {
                    return this.getTables(treeObj.getName(), treeObj);
                }
                case 2: {
                    return new Object[0];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Object[0];
        }
        return new Object[0];
    }

    private Object[] getSchemas(JdbcTreeObject treeObj) throws SQLException {
        Connection con = treeObj.getBrowser().jdbcCon;
        ResultSet rs = con.getMetaData().getSchemas();
        ArrayList<JdbcTreeObject> schems = new ArrayList<JdbcTreeObject>();
        if (rs == null || !rs.next()) {
            return null;
        }
        do {
            String name = rs.getString("TABLE_SCHEM");
            schems.add(new JdbcTreeObject(1, name, treeObj.getBrowser()));
        } while (rs.next());
        return schems.toArray();
    }

    private Object[] getTables(String schema, JdbcTreeObject treeObj) throws SQLException {
        Connection con = treeObj.getBrowser().jdbcCon;
        ResultSet tables = con.getMetaData().getTables(null, schema, "%", null);
        ArrayList<JdbcTreeObject> tbls = new ArrayList<JdbcTreeObject>();
        while (tables.next()) {
            tbls.add(new JdbcTreeObject(2, tables.getString("TABLE_NAME"), treeObj.getBrowser(), schema));
        }
        return tbls.toArray();
    }

    public Object getParent(Object arg0) {
        return null;
    }

    public boolean hasChildren(Object arg0) {
        return true;
    }

    public Object[] getElements(Object val) {
        if (val instanceof JdbcLdapBrowser) {
            JdbcLdapBrowser browser = (JdbcLdapBrowser)val;
            String url = browser.jdbcUrl;
            if ((url = url.substring(url.lastIndexOf("/") + 1)).indexOf(63) != -1) {
                url = url.substring(0, url.indexOf(63));
            }
            return new Object[]{new JdbcTreeObject(0, url, browser)};
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }

    public Image getImage(Object arg0) {
        return null;
    }

    public String getText(Object arg0) {
        if (arg0 instanceof JdbcTreeObject) {
            return ((JdbcTreeObject)arg0).getName();
        }
        return "?";
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }
}

