/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.octetstring.jdbcLdap.browser.AboutPressed;
import com.octetstring.jdbcLdap.browser.AddEntry;
import com.octetstring.jdbcLdap.browser.AppQuitPressed;
import com.octetstring.jdbcLdap.browser.Browser;
import com.octetstring.jdbcLdap.browser.CloseAllPressed;
import com.octetstring.jdbcLdap.browser.CloseDropDown;
import com.octetstring.jdbcLdap.browser.ConnectionInfo;
import com.octetstring.jdbcLdap.browser.CopyName;
import com.octetstring.jdbcLdap.browser.DrawCloseMenu;
import com.octetstring.jdbcLdap.browser.JdbcLdapBrowser;
import com.octetstring.jdbcLdap.browser.LoadRebind;
import com.octetstring.jdbcLdap.browser.ModifyEntry;
import com.octetstring.jdbcLdap.browser.NewBrowserPressed;
import com.octetstring.jdbcLdap.browser.OpenPreferences;
import com.octetstring.jdbcLdap.browser.SearchDialog;
import com.octetstring.jdbcLdap.browser.ToCSV;
import com.octetstring.jdbcLdap.browser.ToLdif;
import com.octetstring.jdbcLdap.browser.TreeObject;
import java.io.File;
import java.util.HashMap;
import java.util.prefs.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class JdbcLdapBrowserApp {
    public static final String VERSION = "2.1";
    public static final String BUILD = "6117M";
    static JdbcLdapBrowserApp app;
    Shell shell;
    Display display;
    CTabFolder tabs;
    HashMap browsers;
    Menu menuBar;
    Menu fileMenu;
    static Image open;
    static Image close;
    static Image closeAll;
    static Image ldap;
    static Image appIcon;
    static Image toLdif;
    static Image rebind;
    static Image add;
    static Image copy;
    static Image refresh;
    static Image search;
    static Image db;
    Font tabFont;
    int sizeLimit;
    int timeLimit;
    public boolean autoExec;
    public String driversDir;
    public int historyLimit;
    static Image ws;

    public JdbcLdapBrowserApp() throws Exception {
        app = this;
        this.loadPrefs();
        this.display = new Display();
        open = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("fileopen.gif"));
        close = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("kill.gif"));
        closeAll = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("cancel.gif"));
        ldap = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("ldap.gif"));
        appIcon = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("appIcon.gif"));
        toLdif = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("toldif.gif"));
        rebind = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("rebind.gif"));
        add = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("add.gif"));
        copy = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("copy.gif"));
        refresh = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("refresh.gif"));
        search = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("search.gif"));
        db = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("db.gif"));
        ws = new Image((Device)this.display, JdbcLdapBrowserApp.class.getResourceAsStream("ws.gif"));
        this.browsers = new HashMap();
        Shell shell = new Shell(this.display);
        shell.setImage(appIcon);
        this.shell = shell;
        shell.setText("SQL Directory Browser By Octet String Inc.");
        GridLayout gr = new GridLayout();
        gr.numColumns = 1;
        shell.setLayout((Layout)gr);
        this.menuBar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(this.menuBar);
        Menu fileMenu = new Menu(shell.getMenuBar());
        MenuItem newBrowser = new MenuItem(this.menuBar, 64);
        newBrowser.setText("File");
        newBrowser.setMenu(fileMenu);
        MenuItem newBrowserItem = new MenuItem(fileMenu, 8);
        newBrowserItem.setText("New Browser");
        newBrowserItem.setImage(open);
        newBrowserItem.addSelectionListener((SelectionListener)new NewBrowserPressed(this));
        MenuItem rebindMenuItem = new MenuItem(fileMenu, 8);
        rebindMenuItem.addSelectionListener((SelectionListener)new LoadRebind(this));
        rebindMenuItem.setText("Rebind");
        rebindMenuItem.setImage(rebind);
        MenuItem close = new MenuItem(fileMenu, 64);
        close.setText("Close...");
        close.setImage(JdbcLdapBrowserApp.close);
        close.addSelectionListener((SelectionListener)new CloseDropDown(this));
        Menu closeMenu = new Menu(close);
        closeMenu.addMenuListener((MenuListener)new DrawCloseMenu(this));
        close.setMenu(closeMenu);
        MenuItem closeAll = new MenuItem(fileMenu, 8);
        closeAll.setText("Close All");
        closeAll.setImage(JdbcLdapBrowserApp.closeAll);
        closeAll.addSelectionListener((SelectionListener)new CloseAllPressed(this));
        new MenuItem(fileMenu, 2);
        MenuItem quit = new MenuItem(fileMenu, 8);
        quit.setText("Quit");
        quit.addSelectionListener((SelectionListener)new AppQuitPressed(shell));
        Menu editMenu = new Menu(shell.getMenuBar());
        MenuItem editName = new MenuItem(this.menuBar, 64);
        editName.setText("Edit");
        editName.setMenu(editMenu);
        MenuItem copyName = new MenuItem(editMenu, 8);
        copyName.setText("Copy Name");
        copyName.setImage(copy);
        copyName.addSelectionListener((SelectionListener)new CopyName(this));
        Menu genSQLMenu = new Menu(shell.getMenuBar());
        MenuItem genSQLMenuName = new MenuItem(this.menuBar, 64);
        genSQLMenuName.setText("Generate SQL");
        genSQLMenuName.setMenu(genSQLMenu);
        JdbcLdapBrowserApp.drawEditMenu(genSQLMenu, false);
        Menu helpMenu = new Menu(shell.getMenuBar());
        MenuItem helpName = new MenuItem(this.menuBar, 64);
        helpName.setText("Help");
        helpName.setMenu(helpMenu);
        MenuItem prefsName = new MenuItem(helpMenu, 8);
        prefsName.setText("SQL Directory Browser Preferences");
        prefsName.addSelectionListener((SelectionListener)new OpenPreferences());
        MenuItem aboutName = new MenuItem(helpMenu, 8);
        aboutName.setText("About SQL Directory Browser");
        aboutName.addSelectionListener((SelectionListener)new AboutPressed(shell));
        GridData grd = new GridData();
        grd.horizontalAlignment = 1;
        ToolBar toolBar = new ToolBar((Composite)shell, 0x800100);
        toolBar.setLayoutData((Object)grd);
        ToolItem newBrowserToolItem = new ToolItem(toolBar, 8);
        newBrowserToolItem.setToolTipText("New Browser");
        newBrowserToolItem.setImage(open);
        newBrowserToolItem.setText("New Browser");
        newBrowserToolItem.addSelectionListener((SelectionListener)new NewBrowserPressed(this));
        ToolItem closeBrowserItem = new ToolItem(toolBar, 4);
        closeBrowserItem.setToolTipText("Close");
        closeBrowserItem.setText("Close");
        closeBrowserItem.setImage(JdbcLdapBrowserApp.close);
        closeBrowserItem.addSelectionListener((SelectionListener)new CloseDropDown(this));
        ToolItem closeAllBrowserItem = new ToolItem(toolBar, 8);
        closeAllBrowserItem.setToolTipText("Close All");
        closeAllBrowserItem.setText("Close All");
        closeAllBrowserItem.setImage(JdbcLdapBrowserApp.closeAll);
        closeAllBrowserItem.addSelectionListener((SelectionListener)new CloseAllPressed(this));
        new ToolItem(toolBar, 2);
        ToolItem rebindItem = new ToolItem(toolBar, 8);
        rebindItem.setToolTipText("Rebind");
        rebindItem.setText("Rebind");
        rebindItem.setImage(rebind);
        rebindItem.addSelectionListener((SelectionListener)new LoadRebind(this));
        ToolItem toLdifItem = new ToolItem(toolBar, 8);
        toLdifItem.setToolTipText("Export Current Qury To LDIF");
        toLdifItem.setText("To LDIF");
        toLdifItem.setImage(toLdif);
        toLdifItem.addSelectionListener((SelectionListener)new ToLdif(this));
        ToolItem toCsvItem = new ToolItem(toolBar, 8);
        toCsvItem.setToolTipText("Export Current Qury To CSV");
        toCsvItem.setText("To CSV");
        toCsvItem.setImage(toLdif);
        toCsvItem.addSelectionListener((SelectionListener)new ToCSV(this));
        toolBar.pack();
        this.tabs = new CTabFolder((Composite)shell, 2176);
        this.tabs.setSimple(false);
        FontData fd = new FontData();
        fd.setName(this.tabs.getFont().getFontData()[0].getName());
        fd.setHeight(this.tabs.getFont().getFontData()[0].getHeight());
        fd.setStyle(1);
        this.tabFont = new Font((Device)this.display, fd);
        this.tabs.setFont(this.tabFont);
        this.tabs.setSelectionForeground(this.display.getSystemColor(30));
        this.tabs.setSelectionBackground(this.display.getSystemColor(31));
        grd = new GridData();
        grd.grabExcessHorizontalSpace = true;
        grd.grabExcessVerticalSpace = true;
        grd.verticalAlignment = 4;
        grd.horizontalAlignment = 4;
        this.tabs.setLayoutData((Object)grd);
        shell.open();
        while (!shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        open.dispose();
        appIcon.dispose();
        close.dispose();
        closeAll.dispose();
        this.tabFont.dispose();
        toLdif.dispose();
        rebind.dispose();
        copy.dispose();
        add.dispose();
    }

    protected void addBrowser() throws Exception {
        ConnectionInfo con = new ConnectionInfo();
        con.showWindow(this.display);
        if (!con.doOpen) {
            return;
        }
        JdbcLdapBrowser w = null;
        w = !con.bjdbc ? new JdbcLdapBrowser(con.sserver, con.sport, con.sbase, con.suser, con.spassword, con.bfollowReferrals, con.bIsDSML, con.bSsl, con.bspml, con.textraURL) : new JdbcLdapBrowser(con.sserver, con.sport, con.suser, con.spassword);
        w.setName(con.sname);
        if (this.browsers.containsKey(con.sname)) {
            throw new Exception(con.sname + " Already Exists");
        }
        CTabItem ti = new CTabItem(this.tabs, 0);
        ti.setText(con.sname);
        if (con.bjdbc) {
            ti.setImage(db);
        } else if (con.bIsDSML || con.bspml) {
            ti.setImage(ws);
        } else {
            ti.setImage(ldap);
        }
        Composite c = new Composite((Composite)this.tabs, 0);
        ti.setControl((Control)c);
        w.createContents(c);
        Browser b = new Browser();
        b.browser = w;
        b.tab = ti;
        this.browsers.put(con.sname, b);
        ti.getParent().setSelection(ti);
    }

    public void removeBrowser(String browser) {
        Browser b = (Browser)this.browsers.remove(browser);
        JdbcLdapBrowser jdbcLdapBrowser = b.browser;
        CTabItem tab = b.tab;
        tab.dispose();
        try {
            jdbcLdapBrowser.con.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public JdbcLdapBrowser getCurrentBrowser() {
        CTabFolder tabs = this.tabs;
        CTabItem tab = tabs.getSelection();
        if (tab != null) {
            String name = tab.getText();
            return ((Browser)this.browsers.get((Object)name)).browser;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        new JdbcLdapBrowserApp();
    }

    public static void drawEditMenu(Menu popup, boolean addCopy) {
        MenuItem mi;
        if (addCopy) {
            mi = new MenuItem(popup, 8);
            mi.setText("Copy Name");
            mi.setImage(copy);
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (app.getCurrentBrowser() == null) {
                        MessageDialog.openError((Shell)JdbcLdapBrowserApp.app.shell, (String)"No Browsers Opened", (String)"No Browsers Opened");
                        return;
                    }
                    app.getCurrentBrowser().copyName();
                }
            });
        }
        mi = new MenuItem(popup, 8);
        mi.setText("Generate Search SQL...");
        mi.setImage(search);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (app.getCurrentBrowser() == null) {
                    MessageDialog.openError((Shell)JdbcLdapBrowserApp.app.shell, (String)"No Browsers Opened", (String)"No Browsers Opened");
                    return;
                }
                String base = JdbcLdapBrowserApp.app.getCurrentBrowser().tv.getTree().getSelection().length == 0 ? JdbcLdapBrowserApp.app.getCurrentBrowser().baseDN : ((TreeObject)JdbcLdapBrowserApp.app.getCurrentBrowser().tv.getTree().getSelection()[0].getData()).getBase();
                JdbcLdapBrowser browser = app.getCurrentBrowser();
                browser.SQL.setText(new SearchDialog((Display)Display.getCurrent(), (String)base).sql);
                if (JdbcLdapBrowserApp.app.autoExec) {
                    browser.executeSQL();
                }
            }
        });
        mi = new MenuItem(popup, 8);
        mi.setText("Generate SQL To Add New Entry...");
        mi.setImage(add);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (app.getCurrentBrowser() == null) {
                    MessageDialog.openError((Shell)JdbcLdapBrowserApp.app.shell, (String)"No Browsers Opened", (String)"No Browsers Opened");
                    return;
                }
                String base = JdbcLdapBrowserApp.app.getCurrentBrowser().tv.getTree().getSelection().length == 0 ? JdbcLdapBrowserApp.app.getCurrentBrowser().baseDN : ((TreeObject)JdbcLdapBrowserApp.app.getCurrentBrowser().tv.getTree().getSelection()[0].getData()).getBase();
                JdbcLdapBrowserApp.app.getCurrentBrowser().SQL.setText(new AddEntry((Display)Display.getCurrent(), (String)base).sql);
                JdbcLdapBrowser browser = app.getCurrentBrowser();
                if (JdbcLdapBrowserApp.app.autoExec) {
                    browser.executeSQL();
                }
            }
        });
        mi = new MenuItem(popup, 8);
        mi.setText("Generate SQL To Modify Current Entry...");
        mi.setImage(add);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (app.getCurrentBrowser() == null) {
                    MessageDialog.openError((Shell)JdbcLdapBrowserApp.app.shell, (String)"No Browsers Opened", (String)"No Browsers Opened");
                    return;
                }
                String base = JdbcLdapBrowserApp.app.getCurrentBrowser().tv.getTree().getSelection().length == 0 ? JdbcLdapBrowserApp.app.getCurrentBrowser().baseDN : ((TreeObject)JdbcLdapBrowserApp.app.getCurrentBrowser().tv.getTree().getSelection()[0].getData()).getBase();
                JdbcLdapBrowserApp.app.getCurrentBrowser().SQL.setText(new ModifyEntry((Display)Display.getCurrent(), (String)base).sql);
                JdbcLdapBrowser browser = app.getCurrentBrowser();
                if (JdbcLdapBrowserApp.app.autoExec) {
                    browser.executeSQL();
                }
            }
        });
        mi = new MenuItem(popup, 8);
        mi.setText("Generate SQL To Delete Current Entry");
        mi.setImage(close);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (app.getCurrentBrowser() == null) {
                    MessageDialog.openError((Shell)JdbcLdapBrowserApp.app.shell, (String)"No Browsers Opened", (String)"No Browsers Opened");
                    return;
                }
                String base = JdbcLdapBrowserApp.app.getCurrentBrowser().tv.getTree().getSelection().length == 0 ? JdbcLdapBrowserApp.app.getCurrentBrowser().baseDN : ((TreeObject)JdbcLdapBrowserApp.app.getCurrentBrowser().tv.getTree().getSelection()[0].getData()).getBase();
                JdbcLdapBrowserApp.app.getCurrentBrowser().SQL.setText("DELETE FROM " + base);
                JdbcLdapBrowser browser = app.getCurrentBrowser();
                if (JdbcLdapBrowserApp.app.autoExec && MessageDialog.openConfirm((Shell)JdbcLdapBrowserApp.app.shell, (String)"Delete Entry?", (String)("Delete : " + browser.SQL.getText()))) {
                    browser.executeSQL();
                }
            }
        });
        if (addCopy) {
            mi = new MenuItem(popup, 8);
            mi.setText("Refresh Children");
            mi.setImage(refresh);
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (app.getCurrentBrowser() == null) {
                        MessageDialog.openError((Shell)JdbcLdapBrowserApp.app.shell, (String)"No Browsers Opened", (String)"No Browsers Opened");
                        return;
                    }
                    JdbcLdapBrowserApp.app.getCurrentBrowser().tv.refresh(JdbcLdapBrowserApp.app.getCurrentBrowser().tv.getTree().getSelection()[0].getData());
                }
            });
        }
    }

    public void loadPrefs() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        this.sizeLimit = Integer.parseInt(prefs.get("JDBC_LDAP_SIZE_LIMIT", "0"));
        this.timeLimit = Integer.parseInt(prefs.get("JDBC_LDAP_TIME_LIMIT", "0"));
        this.autoExec = prefs.getBoolean("JDBC_LDAP_AUTO_EXEC", true);
        this.driversDir = prefs.get("JDBC_LDAP_DRIVER_PATH", System.getProperty("user.home") + File.separator + "jdbcDrivers");
        this.historyLimit = Integer.parseInt(prefs.get("JDBC_LDAP_HIST_LIMIT", "16"));
    }

    public void setPrefs() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        prefs.put("JDBC_LDAP_SIZE_LIMIT", Integer.toString(this.sizeLimit));
        prefs.put("JDBC_LDAP_TIME_LIMIT", Integer.toString(this.timeLimit));
        prefs.put("JDBC_LDAP_AUTO_EXEC", Boolean.toString(this.autoExec));
        prefs.put("JDBC_LDAP_DRIVER_PATH", this.driversDir);
        prefs.putInt("JDBC_LDAP_HIST_LIMIT", this.historyLimit);
    }
}

