/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.novell.ldap.LDAPUrl;
import com.novell.ldap.util.Base64;
import com.octetstring.jdbcLdap.browser.AttributeLabel;
import com.octetstring.jdbcLdap.browser.AttributesList;
import com.octetstring.jdbcLdap.browser.ConnectionStore;
import com.octetstring.jdbcLdap.browser.DbLabelProvider;
import com.octetstring.jdbcLdap.browser.DirTree;
import com.octetstring.jdbcLdap.browser.ExecuteSQLPressed;
import com.octetstring.jdbcLdap.browser.GetKey;
import com.octetstring.jdbcLdap.browser.JdbcLdapBrowserApp;
import com.octetstring.jdbcLdap.browser.JdbcMetaDataView;
import com.octetstring.jdbcLdap.browser.JdbcTree;
import com.octetstring.jdbcLdap.browser.JdbcTreeObject;
import com.octetstring.jdbcLdap.browser.ResultLoader;
import com.octetstring.jdbcLdap.browser.ShowPopup;
import com.octetstring.jdbcLdap.browser.TreeObject;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class JdbcLdapBrowser {
    CTabFolder tabs;
    Font tabFont;
    JndiLdapConnection con;
    String url;
    String server;
    String port;
    String base;
    String user;
    String pass;
    boolean followReferrals;
    boolean isDsml;
    String lastSQL;
    ArrayList reffedCons;
    Text SQL;
    ResultLoader results;
    Clipboard clipboard;
    TreeViewer tv;
    String baseDN;
    private boolean isSSL;
    protected ExecuteSQLPressed executeSQL;
    protected Button executeButton;
    boolean isSpml;
    URLClassLoader driverLoader;
    Connection jdbcCon;
    List history;
    boolean isDB;
    private String jdbcDriver;
    String jdbcUrl;
    String name;
    private String extraUrl;

    public JdbcLdapBrowser(String server, String port, String base, String user, String pass, boolean followRefferals, boolean isDsml, boolean isSSL, boolean isSpml, String extraUrl) throws Exception {
        this.clipboard = new Clipboard(Display.getCurrent());
        ConnectionStore conStore = new ConnectionStore();
        conStore.server = server;
        conStore.port = port;
        conStore.base = base;
        conStore.user = user;
        conStore.pass = pass;
        conStore.followReferrals = followRefferals;
        conStore.isDsml = isDsml;
        conStore.isSSL = isSSL;
        conStore.isSpml = isSpml;
        this.base = base;
        this.user = user;
        this.pass = pass;
        this.isDsml = isDsml;
        this.isSSL = isSSL;
        this.isSpml = isSpml;
        this.extraUrl = extraUrl;
        this.con = JdbcLdapBrowser.createConnection(server, port, base, user, pass, followRefferals, isDsml, isSSL, isSpml, extraUrl);
        this.baseDN = conStore.base;
        this.url = !isDsml ? "jdbc:ldap://" + server + ":" + port + "/" + base + "?EXP_ROWS:=true&secure:=" + (isSSL ? "true" : "false") : "jdbc:dsml:" + server + "?EXP_ROWS:=true";
        conStore.con = this.con;
        this.reffedCons = new ArrayList();
        this.reffedCons.add(conStore);
        this.results = new ResultLoader(this);
        this.lastSQL = null;
        this.isDB = false;
    }

    public JdbcLdapBrowser(String driver, String url, String user, String pass) {
        this.isDB = true;
        this.jdbcDriver = driver;
        this.jdbcUrl = url;
        this.user = user;
        this.pass = pass;
        this.clipboard = new Clipboard(Display.getCurrent());
        File dir = new File(JdbcLdapBrowserApp.app.driversDir);
        if (dir.isDirectory() && dir.exists()) {
            File[] children = dir.listFiles();
            URL[] urls = new URL[children.length];
            for (int i = 0; i < children.length; ++i) {
                try {
                    urls[i] = children[i].toURL();
                    continue;
                }
                catch (MalformedURLException e2) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Could not load drivers", (String)e2.toString());
                }
            }
            this.driverLoader = new URLClassLoader(urls);
        } else {
            this.driverLoader = new URLClassLoader(new URL[0]);
        }
        try {
            this.jdbcCon = this.getJdbcConnection();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Could not load JDBC Driver", (String)e.toString());
        }
        try {
            this.results = new ResultLoader(this);
        }
        catch (SQLException e1) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Could not create result loader", (String)e1.toString());
        }
    }

    private Connection getJdbcConnection() throws SQLException, SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Driver driverImpl = (Driver)this.driverLoader.loadClass(this.jdbcDriver).newInstance();
        Properties props = new Properties();
        props.put("user", this.user);
        props.put("password", this.pass);
        return driverImpl.connect(this.jdbcUrl, props);
    }

    public Connection getConnection() throws SQLException {
        if (!this.isDB) {
            return this.getConnection(0);
        }
        return this.jdbcCon;
    }

    public JndiLdapConnection getConnection(int id) throws SQLException {
        if (id >= this.reffedCons.size()) {
            return null;
        }
        ConnectionStore conStore = (ConnectionStore)this.reffedCons.get(id);
        JndiLdapConnection con = conStore.con;
        boolean isopen = false;
        try {
            isopen = !con.isClosed();
        }
        catch (SQLException e) {
            isopen = false;
        }
        try {
            if (!isopen) {
                if (MessageDialog.openQuestion((Shell)this.tabs.getShell(), (String)"Reconnect?", (String)"Connection Broken, Reconnect?")) {
                    conStore.con = con = JdbcLdapBrowser.createConnection(conStore.server, conStore.port, conStore.base, conStore.user, conStore.pass, conStore.followReferrals, conStore.isDsml, conStore.isSSL, conStore.isSpml, conStore.extraUrl);
                    con.setMaxSizeLimit(JdbcLdapBrowserApp.app.sizeLimit);
                    con.setMaxTimeLimit(JdbcLdapBrowserApp.app.timeLimit);
                    return con;
                }
                throw new SQLException("No Connection");
            }
            con.setMaxSizeLimit(JdbcLdapBrowserApp.app.sizeLimit);
            con.setMaxTimeLimit(JdbcLdapBrowserApp.app.timeLimit);
            return con;
        }
        catch (SQLException e) {
            if (MessageDialog.openQuestion((Shell)this.tabs.getShell(), (String)"Reconnect?", (String)(e.toString() + " - Connection Broken, Reconnect?"))) {
                conStore.con = con = JdbcLdapBrowser.createConnection(conStore.server, conStore.port, conStore.base, conStore.user, conStore.pass, conStore.followReferrals, conStore.isDsml, conStore.isSSL, this.isSpml, conStore.extraUrl);
                con.setMaxSizeLimit(JdbcLdapBrowserApp.app.sizeLimit);
                con.setMaxTimeLimit(JdbcLdapBrowserApp.app.timeLimit);
                return con;
            }
            throw new SQLException("No Conection - " + e.toString());
        }
    }

    public int createRefConnection(String url) throws SQLException {
        ConnectionStore conStore = new ConnectionStore();
        LDAPUrl ldapUrl = null;
        try {
            ldapUrl = new LDAPUrl(url);
        }
        catch (MalformedURLException e) {
            throw new SQLException(e.toString());
        }
        conStore.server = ldapUrl.getHost();
        conStore.port = Integer.toString(ldapUrl.getPort());
        conStore.base = ldapUrl.getDN();
        conStore.pass = this.pass;
        conStore.user = this.user;
        conStore.followReferrals = true;
        conStore.con = JdbcLdapBrowser.createConnection(conStore.server, conStore.port, conStore.base, conStore.user, conStore.pass, conStore.followReferrals, conStore.isDsml, conStore.isSSL, this.isSpml, conStore.extraUrl);
        this.reffedCons.add(conStore);
        return this.reffedCons.size() - 1;
    }

    public static JndiLdapConnection createConnection(String server, String port, String base, String user, String pass, boolean followReferrals, boolean isDsml, boolean isSSL, boolean isSpml, String extraUrl) throws SQLException {
        try {
            Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e.toString());
        }
        JndiLdapConnection con = isDsml ? (JndiLdapConnection)DriverManager.getConnection("jdbc:dsml://" + server + "?EXP_ROWS:=true&secure:=" + (isSSL ? "true" : "false") + (extraUrl.trim().length() != 0 ? "&" + extraUrl : ""), user, pass) : (isSpml ? (JndiLdapConnection)DriverManager.getConnection("jdbc:spml://" + server + "?EXP_ROWS:=true&secure:=" + (isSSL ? "true" : "false") + (extraUrl.trim().length() != 0 ? "&" + extraUrl : ""), user, pass) : (JndiLdapConnection)DriverManager.getConnection("jdbc:ldap://" + server + ":" + port + "/" + "" + "?EXP_ROWS:=true&PRE_FETCH:=false&secure:=" + (isSSL ? "true" : "false") + (extraUrl.trim().length() != 0 ? "&" + extraUrl : ""), user, pass));
        return con;
    }

    protected void createContents(Composite parent) {
        if (!this.isDB) {
            this.createLDAPContents(parent);
        } else {
            this.createDBContents(parent);
        }
    }

    private void createDBContents(Composite parent) {
        GridLayout gr = new GridLayout();
        gr.numColumns = 1;
        gr.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)gr);
        this.tabs = new CTabFolder(parent, 2176);
        this.tabs.setSimple(false);
        this.tabs.setSelectionForeground(parent.getDisplay().getSystemColor(30));
        this.tabs.setSelectionBackground(parent.getDisplay().getSystemColor(31));
        FontData fd = new FontData();
        fd.setName(this.tabs.getFont().getFontData()[0].getName());
        fd.setHeight(this.tabs.getFont().getFontData()[0].getHeight());
        fd.setStyle(1);
        this.tabFont = new Font((Device)parent.getDisplay(), fd);
        this.tabs.setFont(this.tabFont);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.tabs.setLayoutData((Object)gd);
        CTabItem ti = new CTabItem(this.tabs, 0);
        ti.setText("Database Meta-Data Browser");
        SashForm sash_form = new SashForm((Composite)this.tabs, 256);
        ti.setControl((Control)sash_form);
        this.tabs.setSelection(0);
        this.tv = new TreeViewer((Composite)sash_form);
        this.tv.getTree().addKeyListener((KeyListener)new GetKey(this));
        this.tv.setContentProvider((IContentProvider)new JdbcTree());
        this.tv.setInput((Object)this);
        final TableViewer tbv = new TableViewer((Composite)sash_form, 67584);
        TableColumn column = new TableColumn(tbv.getTable(), 16384);
        column.setText("Name");
        column.setWidth(75);
        column = new TableColumn(tbv.getTable(), 16384);
        column.setText("Type");
        column.setWidth(200);
        column = new TableColumn(tbv.getTable(), 16384);
        column.setText("Length");
        column.setWidth(200);
        column = new TableColumn(tbv.getTable(), 16384);
        column.setText("Description");
        column.setWidth(200);
        tbv.getTable().setHeaderVisible(true);
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selectedNode = selection.getFirstElement();
                tbv.setInput(selectedNode);
            }
        });
        ShowPopup pop = new ShowPopup(this);
        this.tv.getTree().addMouseListener((MouseListener)pop);
        this.tv.getTree().addKeyListener((KeyListener)pop);
        Table tbvDB = new Table((Composite)this.tabs, 67584);
        tbvDB.setLinesVisible(true);
        tbvDB.setHeaderVisible(true);
        JdbcMetaDataView view = new JdbcMetaDataView();
        tbv.setContentProvider((IContentProvider)view);
        tbv.setLabelProvider((IBaseLabelProvider)view);
        ti = new CTabItem(this.tabs, 0);
        ti.setControl((Control)tbvDB);
        ti.setText("Results View");
        Composite c = new Composite(parent, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        c.setLayoutData((Object)gd);
        gr = new GridLayout();
        gr.numColumns = 4;
        gr.makeColumnsEqualWidth = false;
        c.setLayout((Layout)gr);
        Label l = new Label(c, 0);
        l.setText("SQL : ");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.SQL = new Text(c, 2114);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 15;
        this.SQL.setLayoutData((Object)gd);
        this.executeButton = new Button(c, 8);
        this.executeButton.setText(" Execute ");
        gd = new GridData();
        gd.horizontalAlignment = 3;
        this.executeSQL = new ExecuteSQLPressed(this.tabs, this.results, this.SQL, this.tv, this);
        this.executeButton.addSelectionListener((SelectionListener)this.executeSQL);
        Button b = new Button(c, 8);
        b.setText(" Clear Browser ");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)this.executeSQL);
        l = new Label(c, 0);
        this.history = new List(c, 2816);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 14;
        gd.widthHint = 200;
        this.history.setLayoutData((Object)gd);
        this.history.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                JdbcLdapBrowser.this.SQL.setText(JdbcLdapBrowser.this.history.getSelection()[0]);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.loadHistory();
    }

    private void createLDAPContents(Composite parent) {
        try {
            GridLayout gr = new GridLayout();
            gr.numColumns = 1;
            gr.makeColumnsEqualWidth = false;
            parent.setLayout((Layout)gr);
            this.tabs = new CTabFolder(parent, 2176);
            this.tabs.setSimple(false);
            this.tabs.setSelectionForeground(parent.getDisplay().getSystemColor(30));
            this.tabs.setSelectionBackground(parent.getDisplay().getSystemColor(31));
            FontData fd = new FontData();
            fd.setName(this.tabs.getFont().getFontData()[0].getName());
            fd.setHeight(this.tabs.getFont().getFontData()[0].getHeight());
            fd.setStyle(1);
            this.tabFont = new Font((Device)parent.getDisplay(), fd);
            this.tabs.setFont(this.tabFont);
            GridLayout gl = new GridLayout();
            gl.numColumns = 1;
            GridData gd = new GridData();
            gd.grabExcessVerticalSpace = true;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = 4;
            gd.horizontalAlignment = 4;
            this.tabs.setLayoutData((Object)gd);
            CTabItem ti = new CTabItem(this.tabs, 0);
            ti.setText("Tree View");
            SashForm sash_form = new SashForm((Composite)this.tabs, 256);
            ti.setControl((Control)sash_form);
            this.tabs.setSelection(0);
            this.tv = new TreeViewer((Composite)sash_form);
            this.tv.getTree().addKeyListener((KeyListener)new GetKey(this));
            this.tv.setContentProvider((IContentProvider)new DirTree(this));
            this.tv.setInput((Object)new TreeObject(this.baseDN, null, this.baseDN));
            final TableViewer tbv = new TableViewer((Composite)sash_form, 67584);
            tbv.setContentProvider((IContentProvider)new AttributesList(this));
            tbv.setLabelProvider((IBaseLabelProvider)new AttributeLabel());
            TableColumn column = new TableColumn(tbv.getTable(), 16384);
            column.setText("Name");
            column.setWidth(75);
            column = new TableColumn(tbv.getTable(), 16384);
            column.setText("Value");
            column.setWidth(200);
            tbv.getTable().setHeaderVisible(true);
            this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object selectedNode = selection.getFirstElement();
                    tbv.setInput(selectedNode);
                }
            });
            ShowPopup pop = new ShowPopup(this);
            this.tv.getTree().addMouseListener((MouseListener)pop);
            this.tv.getTree().addKeyListener((KeyListener)pop);
            Table tbvDB = new Table((Composite)this.tabs, 67584);
            tbvDB.setLinesVisible(true);
            tbvDB.setHeaderVisible(true);
            DbLabelProvider dbLbl = new DbLabelProvider();
            ti = new CTabItem(this.tabs, 0);
            ti.setControl((Control)tbvDB);
            ti.setText("Table View");
            Composite c = new Composite(parent, 0);
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            c.setLayoutData((Object)gd);
            gr = new GridLayout();
            gr.numColumns = 4;
            gr.makeColumnsEqualWidth = false;
            c.setLayout((Layout)gr);
            Label l = new Label(c, 0);
            l.setText("SQL : ");
            gd = new GridData();
            gd.horizontalAlignment = 1;
            l.setLayoutData((Object)gd);
            this.SQL = new Text(c, 2114);
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            gd.verticalSpan = 15;
            this.SQL.setLayoutData((Object)gd);
            this.executeButton = new Button(c, 8);
            this.executeButton.setText(" Execute ");
            gd = new GridData();
            gd.horizontalAlignment = 3;
            this.executeSQL = new ExecuteSQLPressed(this.tabs, this.results, this.SQL, this.tv, this);
            this.executeButton.addSelectionListener((SelectionListener)this.executeSQL);
            Button b = new Button(c, 8);
            b.setText(" Clear Browser ");
            gd = new GridData();
            gd.horizontalAlignment = 1;
            b.setLayoutData((Object)gd);
            b.addSelectionListener((SelectionListener)this.executeSQL);
            l = new Label(c, 0);
            this.history = new List(c, 2816);
            gd = new GridData();
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            gd.verticalSpan = 14;
            gd.widthHint = 200;
            this.history.setLayoutData((Object)gd);
            this.history.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    JdbcLdapBrowser.this.SQL.setText(JdbcLdapBrowser.this.history.getSelection()[0]);
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            this.loadHistory();
            c = new Composite(parent, 0);
            gl = new GridLayout();
            gl.numColumns = 4;
            gl.makeColumnsEqualWidth = true;
            c.setLayout((Layout)gl);
            gd = new GridData();
            gd.horizontalAlignment = 2;
            c.setLayoutData((Object)gd);
            Button baseScope = new Button(c, 16);
            baseScope.setText("Base Scope");
            baseScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    JdbcLdapBrowser.this.results.scope = "objectScope";
                }
            });
            Button oneLevelScope = new Button(c, 16);
            oneLevelScope.setText("One Level Scope");
            oneLevelScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    JdbcLdapBrowser.this.results.scope = "oneLevelScope";
                }
            });
            Button subTreeScope = new Button(c, 16);
            subTreeScope.setText("Sub Tree Scope");
            subTreeScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    JdbcLdapBrowser.this.results.scope = "subTreeScope";
                }
            });
            Button inSqlScope = new Button(c, 16);
            inSqlScope.setSelection(true);
            inSqlScope.setText("Scope In SQL");
            inSqlScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    JdbcLdapBrowser.this.results.scope = "";
                }
            });
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setLastSQL(String sql) {
        this.lastSQL = sql;
    }

    public String getLastSQL() {
        return this.lastSQL;
    }

    public String insertScope(String SQL) {
        if (this.results.scope.trim().length() != 0) {
            String lsql = SQL.toLowerCase();
            int begin = lsql.startsWith("select") || lsql.startsWith("delete") ? lsql.indexOf("from") + 5 : (lsql.startsWith("update entry") ? lsql.indexOf("update entry") + 13 : lsql.indexOf("update") + 7);
            SQL = begin - 1 < SQL.length() ? SQL.substring(0, begin) + this.results.scope + ";" + SQL.substring(begin) : SQL + " " + this.results.scope + ";";
        }
        return SQL;
    }

    public void copyName() {
        TreeItem[] items = this.tv.getTree().getSelection();
        Object obj = items[0].getData();
        TextTransfer text_transfer = TextTransfer.getInstance();
        if (obj instanceof TreeObject) {
            TreeObject to = (TreeObject)items[0].getData();
            this.clipboard.setContents(new Object[]{to.getBase()}, new Transfer[]{text_transfer});
        } else {
            JdbcTreeObject to = (JdbcTreeObject)items[0].getData();
            String toCopy = null;
            toCopy = to.parentName == null ? to.toString() : to.parentName + "." + to.toString();
            this.clipboard.setContents(new Object[]{toCopy}, new Transfer[]{text_transfer});
        }
    }

    public void executeSQL() {
        this.executeSQL.executeCMD(this.executeButton.getText());
    }

    public void setName(String sname) {
        this.name = sname;
    }

    public void loadHistory() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String hist = prefs.get("JDBC_LDAP_HISTORY_" + this.name, "");
        StringTokenizer toker = new StringTokenizer(hist, "|");
        while (toker.hasMoreTokens()) {
            this.history.add(new String(Base64.decode((String)toker.nextToken())));
        }
    }
}

