/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.novell.ldap.util.Base64;
import com.octetstring.jdbcLdap.browser.JdbcLdapBrowser;
import com.octetstring.jdbcLdap.browser.JdbcLdapBrowserApp;
import com.octetstring.jdbcLdap.browser.ResultLoader;
import com.octetstring.jdbcLdap.browser.TreeObject;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

class ExecuteSQLPressed
extends SelectionAdapter {
    CTabFolder tabs;
    ResultLoader results;
    Text sql;
    TreeViewer tv;
    String scope;
    JdbcLdapBrowser browser;

    public ExecuteSQLPressed(CTabFolder tabs, ResultLoader results, Text sql, TreeViewer tv, JdbcLdapBrowser browser) {
        this.tabs = tabs;
        this.tv = tv;
        this.results = results;
        this.sql = sql;
        this.browser = browser;
    }

    public void widgetSelected(SelectionEvent event) {
        String buttonname = ((Button)event.widget).getText();
        this.executeCMD(buttonname);
    }

    public void executeCMD(String buttonname) {
        this.tabs.getItem(this.tabs.getItemCount() - 1).dispose();
        Table tbvDB = new Table((Composite)this.tabs, 67584);
        tbvDB.setLinesVisible(true);
        tbvDB.setHeaderVisible(true);
        CTabItem ti = new CTabItem(this.tabs, 0);
        ti.setControl((Control)tbvDB);
        ti.setText("Table View");
        if (buttonname.trim().equalsIgnoreCase("execute")) {
            String orgSQL = this.sql.getText();
            String SQL = this.sql.getText().replace('\n', ' ');
            System.out.println(SQL);
            int index = this.browser.history.indexOf(orgSQL);
            if (this.browser.history.indexOf(orgSQL) >= 0) {
                this.browser.history.remove(index);
            }
            this.browser.history.add(orgSQL, 0);
            if (this.browser.history.getItemCount() >= JdbcLdapBrowserApp.app.historyLimit) {
                this.browser.history.remove(JdbcLdapBrowserApp.app.historyLimit, this.browser.history.getItemCount() - 1);
            }
            this.storeHistory();
            if (SQL.toLowerCase().startsWith("select")) {
                SQL = this.addScopeAndDN(SQL);
                try {
                    this.results.loadResults(SQL, tbvDB, this.tv);
                    this.browser.setLastSQL(SQL);
                }
                catch (SQLException e) {
                    MessageDialog.openError((Shell)this.tabs.getShell(), (String)"Error", (String)e.toString());
                    return;
                }
                TableColumn[] tcs = tbvDB.getColumns();
                int m = tcs.length;
                for (int i = 0; i < m; ++i) {
                    tcs[i].pack();
                }
                this.tabs.setSelection(ti);
            } else {
                if (SQL.toLowerCase().startsWith("update") && !this.browser.isDB) {
                    SQL = this.browser.insertScope(SQL);
                }
                try {
                    int result = this.results.executeUpdate(SQL);
                    MessageDialog.openInformation((Shell)this.tabs.getShell(), (String)"SQL Update", (String)("Records Effected : " + result));
                }
                catch (SQLException sql) {
                    MessageDialog.openError((Shell)this.tabs.getShell(), (String)"Error Occurred", (String)sql.toString());
                }
            }
        } else {
            this.browser.setLastSQL(null);
            if (!this.browser.isDB) {
                this.tv.setInput((Object)new TreeObject(this.results.browser.baseDN, null, this.results.browser.baseDN));
            } else {
                this.tv.setInput((Object)this.browser);
            }
        }
    }

    private void storeHistory() {
        StringBuffer buff = new StringBuffer();
        String[] hist = this.browser.history.getItems();
        int m = hist.length;
        for (int i = 0; i < m; ++i) {
            buff.append(Base64.encode((String)hist[i]));
            if (i + 1 >= m) continue;
            buff.append('|');
        }
        Preferences prefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        prefs.put("JDBC_LDAP_HISTORY_" + this.browser.name, buff.toString());
    }

    private String addScopeAndDN(String SQL) {
        if (!this.browser.isDB) {
            SQL = this.browser.insertScope(SQL);
            String lsql = SQL.toLowerCase();
            int index = lsql.indexOf(" from");
            String attrs = lsql.substring(6, index);
            StringTokenizer toker = new StringTokenizer(attrs);
            boolean hasdn = false;
            while (toker.hasMoreTokens()) {
                String token = toker.nextToken();
                hasdn = hasdn || token.equals("dn") || token.equals("*");
            }
            if (!hasdn) {
                SQL = "SELECT DN," + SQL.substring(6);
            }
        }
        return SQL;
    }
}

