/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.octetstring.jdbcLdap.browser.JdbcLdapBrowser;
import com.octetstring.jdbcLdap.browser.TreeObject;
import com.octetstring.jdbcLdap.jndi.JndiLdapConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public class DirTree
implements ITreeContentProvider {
    JdbcLdapBrowser browser;
    Statement stmt;

    public DirTree(JdbcLdapBrowser browser) throws SQLException {
        this.browser = browser;
    }

    public Object[] getChildren(Object obj) {
        String sql;
        TreeObject to = (TreeObject)obj;
        ResultSet namingContexts = null;
        if (!to.getSQL) {
            return to.children.values().toArray();
        }
        JndiLdapConnection con = null;
        try {
            con = (JndiLdapConnection)this.browser.getConnection();
        }
        catch (SQLException e) {
            MessageDialog.openError((Shell)this.browser.tabs.getShell(), (String)"Error", (String)e.toString());
            return new Object[0];
        }
        int conid = to.getConId();
        if (to.isRef()) {
            try {
                if (to.conId == 0) {
                    to.setConId(this.browser.createRefConnection(to.getRefUrl()));
                }
                con = this.browser.getConnection(to.getConId());
                sql = "SELECT dn FROM oneLevelScope;" + to.getName();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.browser.tabs.getShell(), (String)"Error", (String)e.toString());
                return new Object[0];
            }
        }
        try {
            con = this.browser.getConnection(to.getConId());
            String base = to.getBase();
            if (base.equalsIgnoreCase("RootDSE")) {
                sql = "SELECT namingContexts FROM objectScope; ";
                namingContexts = con.createStatement().executeQuery(sql);
            } else {
                sql = "SELECT dn FROM oneLevelScope;" + to.getBase();
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.browser.tabs.getShell(), (String)"Error", (String)e.toString());
            return new Object[0];
        }
        sql = sql.trim();
        if (sql.length() > 0 && sql.charAt(sql.length() - 1) == ',') {
            sql = sql.substring(0, sql.lastIndexOf(44));
        }
        LinkedList<TreeObject> children = new LinkedList<TreeObject>();
        try {
            ResultSet rs = null;
            String dnAttrib = "DN";
            if (namingContexts == null) {
                rs = con.createStatement().executeQuery(sql);
            } else {
                rs = namingContexts;
                dnAttrib = "namingContexts";
            }
            while (rs.next()) {
                TreeObject nto = new TreeObject(rs.getString(1), to, con.getBaseDN());
                nto.setConId(to.getConId());
                children.add(nto);
            }
        }
        catch (SQLException e) {
            MessageDialog.openError((Shell)this.browser.tabs.getShell(), (String)"Error", (String)e.toString());
            e.printStackTrace();
        }
        return children.toArray();
    }

    public Object getParent(Object base) {
        TreeObject to = (TreeObject)base;
        return to.getParent();
    }

    public boolean hasChildren(Object arg0) {
        return true;
    }

    public Object[] getElements(Object arg0) {
        TreeObject to = (TreeObject)arg0;
        return new Object[]{new TreeObject(to.toString(), null, to.getBase(), to.getSQL, to.children, to.attributes)};
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }
}

