/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.octetstring.jdbcLdap.browser.CheckPasswords;
import com.octetstring.jdbcLdap.browser.ConfigStore;
import com.octetstring.jdbcLdap.browser.FetchBasePressed;
import com.octetstring.jdbcLdap.browser.JdbcLdapBrowserApp;
import com.octetstring.jdbcLdap.browser.LoadCfg;
import com.octetstring.jdbcLdap.browser.ManageConfig;
import com.octetstring.jdbcLdap.browser.OkPressed;
import com.octetstring.jdbcLdap.browser.QuitPressed;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectionInfo {
    Text server;
    Text port;
    Text user;
    Text password;
    Text pass2;
    Button fetchDns;
    Button followReferrals;
    Button dsml;
    Button ssl;
    Button spml;
    Button ldap;
    Combo base;
    Combo name;
    Text extraURL;
    String sserver;
    String sport;
    String suser;
    String spassword;
    String sbase;
    String sname;
    Shell shell;
    boolean doOpen;
    boolean bfollowReferrals;
    boolean bIsDSML;
    boolean bSsl;
    boolean bspml;
    boolean bjdbc;
    ConfigStore configs;
    protected Button jdbc;
    protected Label serverlabel;
    protected Label serverport;
    public String textraURL;

    public void showWindow(Display display) {
        try {
            this.configs = new ConfigStore();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            MessageDialog.openError((Shell)this.shell, (String)"Error Occurred While Loading Configs", (String)("The error : " + e.toString()));
        }
        this.shell = new Shell(display);
        this.shell.setText("Enter Connection Information");
        this.shell.setImage(JdbcLdapBrowserApp.open);
        this.createContents(this.shell);
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void loadNames() {
        if (this.configs == null) {
            return;
        }
        this.name.removeAll();
        Iterator it = this.configs.getConfigLabels().iterator();
        while (it.hasNext()) {
            this.name.add(it.next().toString());
        }
    }

    private void createContents(Shell parent) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 4;
        gl.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)gl);
        Label l = new Label((Composite)parent, 0);
        l.setText("Name ");
        GridData gr = new GridData();
        gr.horizontalSpan = 1;
        gr.horizontalAlignment = 4;
        this.name = new Combo((Composite)parent, 2048);
        gr = new GridData();
        gr.horizontalSpan = 3;
        gr.horizontalAlignment = 4;
        gr.grabExcessHorizontalSpace = true;
        this.name.setLayoutData((Object)gr);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.name.addPaintListener((PaintListener)new LoadCfg(this));
        } else {
            this.name.addSelectionListener((SelectionListener)new LoadCfg(this));
        }
        this.loadNames();
        Button addCfg = new Button((Composite)parent, 8);
        addCfg.setText(" Save ");
        gr = new GridData();
        gr.horizontalSpan = 2;
        gr.horizontalAlignment = 3;
        addCfg.setLayoutData((Object)gr);
        addCfg.addSelectionListener((SelectionListener)new ManageConfig(true, this));
        Button delCfg = new Button((Composite)parent, 8);
        delCfg.setText(" Delete ");
        gr = new GridData();
        gr.horizontalSpan = 2;
        gr.horizontalAlignment = 1;
        delCfg.setLayoutData((Object)gr);
        delCfg.addSelectionListener((SelectionListener)new ManageConfig(false, this));
        this.serverlabel = new Label((Composite)parent, 0);
        this.serverlabel.setText("Server              ");
        gr = new GridData();
        gr.horizontalSpan = 1;
        gr.horizontalAlignment = 4;
        this.server = new Text((Composite)parent, 2048);
        gr = new GridData();
        gr.horizontalSpan = 3;
        gr.horizontalAlignment = 4;
        gr.grabExcessHorizontalSpace = true;
        this.server.setLayoutData((Object)gr);
        this.serverport = new Label((Composite)parent, 0);
        this.serverport.setText("Port          ");
        gr = new GridData();
        gr.horizontalSpan = 1;
        gr.horizontalAlignment = 4;
        this.port = new Text((Composite)parent, 2048);
        gr = new GridData();
        gr.horizontalSpan = 3;
        gr.horizontalAlignment = 4;
        gr.grabExcessHorizontalSpace = true;
        this.port.setLayoutData((Object)gr);
        l = new Label((Composite)parent, 0);
        l.setText("Base (Leave blank for all)");
        gr = new GridData();
        gr.horizontalSpan = 1;
        gr.horizontalAlignment = 4;
        this.base = new Combo((Composite)parent, 4);
        gr = new GridData();
        gr.horizontalSpan = 3;
        gr.horizontalAlignment = 4;
        gr.grabExcessHorizontalSpace = true;
        this.base.setLayoutData((Object)gr);
        this.fetchDns = new Button((Composite)parent, 8);
        this.fetchDns.setText("Retrieve Bases");
        gr = new GridData();
        gr.horizontalSpan = 4;
        gr.horizontalAlignment = 4;
        gr.grabExcessHorizontalSpace = true;
        this.fetchDns.setLayoutData((Object)gr);
        l = new Label((Composite)parent, 0);
        l.setText("Username ");
        gr = new GridData();
        gr.horizontalSpan = 1;
        gr.horizontalAlignment = 4;
        this.user = new Text((Composite)parent, 2048);
        gr = new GridData();
        gr.horizontalSpan = 3;
        gr.horizontalAlignment = 4;
        gr.grabExcessHorizontalSpace = true;
        this.user.setLayoutData((Object)gr);
        l = new Label((Composite)parent, 0);
        l.setText("Password ");
        gr = new GridData();
        gr.horizontalSpan = 1;
        gr.horizontalAlignment = 4;
        this.password = new Text((Composite)parent, 2048);
        gr = new GridData();
        gr.horizontalSpan = 3;
        gr.horizontalAlignment = 4;
        gr.grabExcessHorizontalSpace = true;
        this.password.setLayoutData((Object)gr);
        this.password.setEchoChar('*');
        l = new Label((Composite)parent, 0);
        l.setText("Password Confirm");
        gr = new GridData();
        gr.horizontalSpan = 1;
        gr.horizontalAlignment = 4;
        this.pass2 = new Text((Composite)parent, 2048);
        gr = new GridData();
        gr.horizontalSpan = 3;
        gr.horizontalAlignment = 4;
        gr.grabExcessHorizontalSpace = true;
        this.pass2.setLayoutData((Object)gr);
        this.pass2.setEchoChar('*');
        l = new Label((Composite)parent, 0);
        l.setText("Extra URL Options");
        gr = new GridData();
        gr.horizontalSpan = 1;
        gr.horizontalAlignment = 4;
        this.extraURL = new Text((Composite)parent, 2048);
        gr = new GridData();
        gr.horizontalSpan = 3;
        gr.horizontalAlignment = 4;
        gr.grabExcessHorizontalSpace = true;
        this.extraURL.setLayoutData((Object)gr);
        this.ssl = new Button((Composite)parent, 32);
        this.ssl.setText("Use SSL/TLS");
        gr = new GridData();
        gr.horizontalSpan = 4;
        gr.horizontalAlignment = 2;
        this.ssl.setLayoutData((Object)gr);
        this.ssl.setVisible(true);
        l = new Label((Composite)parent, 0);
        l.setText("Connection Type :");
        this.ldap = new Button((Composite)parent, 16);
        this.ldap.setText("LDAPv3");
        this.ldap.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ConnectionInfo.this.serverlabel.setText("Server ");
                ConnectionInfo.this.serverport.setText("Port ");
                ConnectionInfo.this.base.setEnabled(true);
                ConnectionInfo.this.fetchDns.setEnabled(true);
                ConnectionInfo.this.ssl.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.dsml = new Button((Composite)parent, 16);
        this.dsml.setText("DSMLv2");
        this.dsml.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ConnectionInfo.this.serverlabel.setText("Server ");
                ConnectionInfo.this.serverport.setText("Port ");
                ConnectionInfo.this.port.setEnabled(!ConnectionInfo.this.dsml.getSelection() && !ConnectionInfo.this.spml.getSelection());
                ConnectionInfo.this.ssl.setEnabled(!ConnectionInfo.this.dsml.getSelection() && !ConnectionInfo.this.spml.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.spml = new Button((Composite)parent, 16);
        this.spml.setText("SPML");
        this.spml.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ConnectionInfo.this.port.setEnabled(!ConnectionInfo.this.spml.getSelection() && !ConnectionInfo.this.dsml.getSelection());
                ConnectionInfo.this.ssl.setEnabled(!ConnectionInfo.this.spml.getSelection() && !ConnectionInfo.this.dsml.getSelection());
                if (ConnectionInfo.this.spml.getSelection()) {
                    ConnectionInfo.this.base.setText("ou=Users,dc=spml,dc=com");
                }
                ConnectionInfo.this.base.setEnabled(!ConnectionInfo.this.spml.getSelection());
                ConnectionInfo.this.fetchDns.setEnabled(!ConnectionInfo.this.spml.getSelection());
                ConnectionInfo.this.serverlabel.setText("Server ");
                ConnectionInfo.this.serverport.setText("Port ");
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.jdbc = new Button((Composite)parent, 16);
        this.jdbc.setText("JDBC Connection");
        gr = new GridData();
        gr.horizontalSpan = 6;
        gr.horizontalAlignment = 2;
        this.jdbc.setLayoutData((Object)gr);
        this.jdbc.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ConnectionInfo.this.serverlabel.setText("JDBC Driver ");
                ConnectionInfo.this.serverport.setText("JDBC URL ");
                ConnectionInfo.this.base.setEnabled(false);
                ConnectionInfo.this.fetchDns.setEnabled(false);
                ConnectionInfo.this.ssl.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.followReferrals = new Button((Composite)parent, 32);
        this.followReferrals.setText("Follow Referrals");
        gr = new GridData();
        gr.horizontalSpan = 4;
        gr.horizontalAlignment = 3;
        this.followReferrals.setLayoutData((Object)gr);
        this.followReferrals.setVisible(false);
        this.followReferrals = new Button((Composite)parent, 32);
        this.followReferrals.setText("Follow Referrals");
        gr = new GridData();
        gr.horizontalSpan = 6;
        gr.horizontalAlignment = 3;
        this.followReferrals.setLayoutData((Object)gr);
        this.followReferrals.setVisible(false);
        this.fetchDns.addSelectionListener((SelectionListener)new FetchBasePressed(this.shell, this.server, this.port, this.user, this.password, this.base, this.dsml, this.ssl, this.spml, this.extraURL));
        Button ok = new Button((Composite)parent, 8);
        ok.setText(" OK ");
        parent.setDefaultButton(ok);
        gr = new GridData();
        gr.horizontalSpan = 2;
        gr.horizontalAlignment = 3;
        ok.setLayoutData((Object)gr);
        ok.addSelectionListener((SelectionListener)new OkPressed(this));
        Button quit = new Button((Composite)parent, 8);
        quit.setText(" QUIT ");
        gr = new GridData();
        gr.horizontalSpan = 2;
        gr.horizontalAlignment = 1;
        quit.setLayoutData((Object)gr);
        quit.addSelectionListener((SelectionListener)new QuitPressed(this.shell, this));
        this.password.addKeyListener((KeyListener)new CheckPasswords(ok, addCfg, this.password, this.pass2));
        this.pass2.addKeyListener((KeyListener)new CheckPasswords(ok, addCfg, this.password, this.pass2));
    }
}

