/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.jdbcLdap.browser;

import com.octetstring.jdbcLdap.browser.ConnectionStore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigStore {
    Element root;
    String prefsFile;
    Document doc;
    TreeMap configs;

    public ConfigStore() throws Exception {
        String home = System.getProperty("user.home");
        this.prefsFile = home + "/.jdbcLdapBrowserCfg";
        this.configs = new TreeMap();
        File f = new File(this.prefsFile);
        if (f.exists()) {
            this.parseConfigs();
        } else {
            this.createConfig();
        }
    }

    public void saveConfig(String label, String user, String pass, String host, String port, String base, boolean isDSML, boolean followReferrals, boolean isSSL, boolean isSpml, boolean isJdbc, String extraUrl) throws Exception {
        ConnectionStore cs = new ConnectionStore();
        Element svr = null;
        NodeList nl = this.doc.getDocumentElement().getElementsByTagName("server");
        int m = nl.getLength();
        for (int i = 0; i < m; ++i) {
            if (!((Element)nl.item(i)).getAttribute("name").equalsIgnoreCase(label)) continue;
            svr = (Element)nl.item(i);
            break;
        }
        if (svr == null) {
            svr = this.doc.createElement("server");
            this.root.appendChild(svr);
        }
        svr.setAttribute("name", label);
        cs.base = base;
        svr.setAttribute("base", base);
        cs.followReferrals = followReferrals;
        svr.setAttribute("followReferrals", Boolean.toString(followReferrals));
        cs.isDsml = isDSML;
        svr.setAttribute("isDSML", Boolean.toString(isDSML));
        cs.isSpml = isSpml;
        svr.setAttribute("isSPML", Boolean.toString(isSpml));
        cs.isSSL = isSSL;
        svr.setAttribute("isSSL", Boolean.toString(isSSL));
        cs.pass = pass;
        svr.setAttribute("pass", pass);
        cs.port = port;
        svr.setAttribute("port", port);
        cs.server = host;
        svr.setAttribute("server", host);
        cs.user = user;
        svr.setAttribute("user", user);
        cs.isJDBC = isJdbc;
        svr.setAttribute("isJDBC", Boolean.toString(isJdbc));
        cs.extraUrl = extraUrl;
        svr.setAttribute("extraUrl", cs.extraUrl);
        this.configs.put(label, cs);
        this.storeConfigs();
    }

    private void parseConfigs() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        this.doc = db.parse(this.prefsFile);
        this.root = this.doc.getDocumentElement();
        NodeList nl = this.doc.getDocumentElement().getElementsByTagName("server");
        int m = nl.getLength();
        for (int i = 0; i < m; ++i) {
            ConnectionStore cs = new ConnectionStore();
            Element svr = (Element)nl.item(i);
            String label = svr.getAttribute("name");
            String tmp = svr.getAttribute("isDSML");
            cs.isDsml = tmp.equals("1") || tmp.equalsIgnoreCase("true");
            tmp = svr.getAttribute("followReferrals");
            cs.followReferrals = tmp.equals("1") || tmp.equalsIgnoreCase("true");
            tmp = svr.getAttribute("isSSL");
            cs.isSSL = tmp.equals("1") || tmp.equalsIgnoreCase("true");
            tmp = svr.getAttribute("isJDBC");
            cs.isJDBC = tmp.equals("1") || tmp.equalsIgnoreCase("true");
            cs.pass = svr.getAttribute("pass");
            cs.port = svr.getAttribute("port");
            cs.server = svr.getAttribute("server");
            cs.user = svr.getAttribute("user");
            cs.base = svr.getAttribute("base");
            cs.extraUrl = svr.getAttribute("extraUrl");
            this.configs.put(label, cs);
        }
    }

    private void createConfig() throws Exception {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return;
        }
        this.doc = builder.newDocument();
        this.root = this.doc.createElement("servers");
        this.doc.appendChild(this.root);
        this.storeConfigs();
    }

    private void storeConfigs() throws Exception {
        try {
            DOMSource xmlSource = new DOMSource(this.doc);
            StreamResult res = new StreamResult(new FileOutputStream(this.prefsFile));
            TransformerFactory transf = TransformerFactory.newInstance();
            Transformer trans = transf.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("method", "xml");
            trans.transform(xmlSource, res);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Exception("Could Not Find File : " + this.prefsFile, e);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new Exception("Could not store configuration", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new Exception("Could not store configuration", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
            throw new Exception("Could not store configuration", e);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new Exception("Could not store configuration", e);
        }
    }

    public void deleteConfig(String label) throws Exception {
        this.configs.remove(label);
        Element svr = null;
        NodeList nl = this.doc.getDocumentElement().getElementsByTagName("server");
        int m = nl.getLength();
        for (int i = 0; i < m; ++i) {
            if (!((Element)nl.item(i)).getAttribute("name").equalsIgnoreCase(label)) continue;
            svr = (Element)nl.item(i);
            this.root.removeChild(svr);
        }
        this.storeConfigs();
    }

    public Set getConfigLabels() {
        return this.configs.keySet();
    }

    public ConnectionStore getConnectionInfo(String name) {
        return (ConnectionStore)this.configs.get(name);
    }
}

